/*
 * Decompiled with CFR 0.152.
 */
package de.intektor.grapple_hooks;

import de.intektor.grapple_hooks.entity.EntityGrapplingHook;
import de.intektor.grapple_hooks.event.GrappleEventHandler;
import de.intektor.grapple_hooks.item.ItemGrapple;
import de.intektor.grapple_hooks.network.MessageToServer;
import de.intektor.grapple_hooks.network.MessageToServerHandler;
import de.intektor.grapple_hooks.server.ServerProxy;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;

@Mod(modid="grapple_hooks", name="Grapple Hooks", version="1.0.4", acceptedMinecraftVersions="[1.8.9]")
public class GrappleHooks {
    public static final String modid = "grapple_hooks";
    public static final String MODID = "grapple_hooks";
    public static final String name = "Grapple Hooks";
    public static final String NAME = "Grapple Hooks";
    public static final String version = "1.0.4";
    public static final String VERSION = "1.0.4";
    @SidedProxy(clientSide="de.intektor.grapple_hooks.client.ClientProxy", serverSide="de.intektor.grapple_hooks.server.ServerProxy")
    public static ServerProxy proxy;
    public static SimpleNetworkWrapper network;
    public static Item WOODEN_GRAPPLE;
    public static Item STONE_GRAPPLE;
    public static Item IRON_GRAPPLE;
    public static Item GOLDEN_GRAPPLE;
    public static Item DIAMOND_GRAPPLE;
    public static Item IRIDIUM_GRAPPLE;
    public static Item SPIDER_GRAPPLE;
    public static Item CREATIVE_GRAPPLE;
    public static boolean allowGrapplingPlayers;
    public static boolean allowGrapplingEntities;
    public static boolean allowGrapplingItems;
    public static CreativeTabs GRAPPLE_HOOKS_CREATIVE_TAB;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        network = NetworkRegistry.INSTANCE.newSimpleChannel("grapple_hooks");
        network.registerMessage(MessageToServerHandler.MotionPressHandler.class, MessageToServer.MotionPress.class, 0, Side.SERVER);
        WOODEN_GRAPPLE = new ItemGrapple.WoodenGrapple();
        STONE_GRAPPLE = new ItemGrapple.StoneGrapple();
        IRON_GRAPPLE = new ItemGrapple.IronGrapple();
        GOLDEN_GRAPPLE = new ItemGrapple.GoldenGrapple();
        DIAMOND_GRAPPLE = new ItemGrapple.DiamondGrapple();
        IRIDIUM_GRAPPLE = new ItemGrapple.IridiumGrapple();
        CREATIVE_GRAPPLE = new ItemGrapple.CreativeGrapple();
        MinecraftForge.EVENT_BUS.register((Object)new GrappleEventHandler());
        EntityRegistry.registerModEntity(EntityGrapplingHook.class, (String)"GrapplingHookEntity", (int)0, (Object)this, (int)200, (int)100, (boolean)true);
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(WOODEN_GRAPPLE), (Object[])new Object[]{"WAW", "WDW", "WWW", Character.valueOf('W'), new ItemStack(Blocks.field_150344_f), Character.valueOf('A'), new ItemStack(Items.field_151032_g), Character.valueOf('D'), new ItemStack(Blocks.field_150367_z)});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(STONE_GRAPPLE), (Object[])new Object[]{"SSS", "SGS", "SSS", Character.valueOf('S'), new ItemStack(Blocks.field_150347_e), Character.valueOf('G'), new ItemStack(WOODEN_GRAPPLE)});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(IRON_GRAPPLE), (Object[])new Object[]{"SSS", "SGS", "SSS", Character.valueOf('S'), new ItemStack(Items.field_151042_j), Character.valueOf('G'), new ItemStack(STONE_GRAPPLE)});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(GOLDEN_GRAPPLE), (Object[])new Object[]{"SSS", "SGS", "SSS", Character.valueOf('S'), new ItemStack(Items.field_151043_k), Character.valueOf('G'), new ItemStack(IRON_GRAPPLE)});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(DIAMOND_GRAPPLE), (Object[])new Object[]{"SSS", "SGS", "SSS", Character.valueOf('S'), new ItemStack(Items.field_151045_i), Character.valueOf('G'), new ItemStack(GOLDEN_GRAPPLE)});
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        int CHANCE_IRIDIUM_GRAPPLE_DUNGEON_CHEST = config.getInt("DUNGEON_CHEST: ", "Iridium Grapple Chest Spawn Rate: 1 = very very rare, 10 = common, 20 = too much", 1, 1, 20000, "");
        int CHANCE_IRIDIUM_GRAPPLE_MINESHAFT_CORRIDOR = config.getInt("MINESHAFT_CORRIDOR: ", "Iridium Grapple Chest Spawn Rate: 1 = very very rare, 10 = common, 20 = too much", 1, 1, 20000, "");
        int CHANCE_IRIDIUM_GRAPPLE_NETHER_FORTRESS = config.getInt("NETHER_FORTRESS: ", "Iridium Grapple Chest Spawn Rate: 1 = very very rare, 10 = common, 20 = too much", 1, 1, 20000, "");
        int CHANCE_IRIDIUM_GRAPPLE_PYRAMID_DESERT_CHEST = config.getInt("PYRAMID_DESERT_CHEST: ", "Iridium Grapple Chest Spawn Rate: 1 = very very rare, 10 = common, 20 = too much", 1, 1, 20000, "");
        int CHANCE_IRIDIUM_GRAPPLE_PYRAMID_JUNGLE_CHEST = config.getInt("PYRAMID_JUNGLE_CHEST: ", "Iridium Grapple Chest Spawn Rate: 1 = very very rare, 10 = common, 20 = too much", 1, 1, 20000, "");
        int CHANCE_IRIDIUM_GRAPPLE_PYRAMID_JUNGLE_DISPENSER = config.getInt("PYRAMID_JUNGLE_DISPENSER: ", "Iridium Grapple Chest Spawn Rate: 1 = very very rare, 10 = common, 20 = too much", 1, 1, 20000, "");
        int CHANCE_IRIDIUM_GRAPPLE_STRONGHOLD_CORRIDOR = config.getInt("STRONGHOLD_CORRIDOR: ", "Iridium Grapple Chest Spawn Rate: 1 = very very rare, 10 = common, 20 = too much", 1, 1, 20000, "");
        int CHANCE_IRIDIUM_GRAPPLE_STRONGHOLD_CROSSING = config.getInt("STRONGHOLD_CROSSING: ", "Iridium Grapple Chest Spawn Rate: 1 = very very rare, 10 = common, 20 = too much", 1, 1, 20000, "");
        int CHANCE_IRIDIUM_GRAPPLE_STRONGHOLD_LIBRARY = config.getInt("STRONGHOLD_LIBRARY: ", "Iridium Grapple Chest Spawn Rate: 1 = very very rare, 10 = common, 20 = too much", 1, 1, 20000, "");
        allowGrapplingPlayers = config.getBoolean("Allow grappling players?: ", "Grapple Settings", true, "");
        allowGrapplingEntities = config.getBoolean("Allow grappling entities?: ", "Grapple Settings", true, "");
        allowGrapplingItems = config.getBoolean("Allow grappling items?: ", "Grapple Settings", true, "");
        if (config.hasChanged()) {
            config.save();
        }
        ChestGenHooks.addItem((String)"dungeonChest", (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(IRIDIUM_GRAPPLE), 1, 1, CHANCE_IRIDIUM_GRAPPLE_DUNGEON_CHEST));
        ChestGenHooks.addItem((String)"mineshaftCorridor", (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(IRIDIUM_GRAPPLE), 1, 1, CHANCE_IRIDIUM_GRAPPLE_MINESHAFT_CORRIDOR));
        ChestGenHooks.addItem((String)"netherFortress", (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(IRIDIUM_GRAPPLE), 1, 1, CHANCE_IRIDIUM_GRAPPLE_NETHER_FORTRESS));
        ChestGenHooks.addItem((String)"pyramidDesertyChest", (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(IRIDIUM_GRAPPLE), 1, 1, CHANCE_IRIDIUM_GRAPPLE_PYRAMID_DESERT_CHEST));
        ChestGenHooks.addItem((String)"pyramidJungleChest", (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(IRIDIUM_GRAPPLE), 1, 1, CHANCE_IRIDIUM_GRAPPLE_PYRAMID_JUNGLE_CHEST));
        ChestGenHooks.addItem((String)"pyramidJungleDispenser", (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(IRIDIUM_GRAPPLE), 1, 1, CHANCE_IRIDIUM_GRAPPLE_PYRAMID_JUNGLE_DISPENSER));
        ChestGenHooks.addItem((String)"strongholdCorridor", (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(IRIDIUM_GRAPPLE), 1, 1, CHANCE_IRIDIUM_GRAPPLE_STRONGHOLD_CORRIDOR));
        ChestGenHooks.addItem((String)"strongholdCrossing", (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(IRIDIUM_GRAPPLE), 1, 1, CHANCE_IRIDIUM_GRAPPLE_STRONGHOLD_CROSSING));
        ChestGenHooks.addItem((String)"strongholdLibrary", (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(IRIDIUM_GRAPPLE), 1, 1, CHANCE_IRIDIUM_GRAPPLE_STRONGHOLD_LIBRARY));
        proxy.init();
    }

    static {
        allowGrapplingPlayers = true;
        allowGrapplingEntities = true;
        allowGrapplingItems = true;
        GRAPPLE_HOOKS_CREATIVE_TAB = new CreativeTabs("ItemGrapple Hooks Tab"){

            public Item func_78016_d() {
                return IRON_GRAPPLE;
            }
        };
    }
}

