/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.nei;

import codechicken.nei.ItemList;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.google.common.collect.Lists;
import fiskfille.tf.TransformersAPI;
import fiskfille.tf.common.energon.Energon;
import fiskfille.tf.common.energon.IEnergon;
import fiskfille.tf.common.fluid.FluidEnergon;
import fiskfille.tf.common.fluid.TFFluids;
import fiskfille.tf.common.item.ItemFuelCanister;
import fiskfille.tf.common.item.TFItems;
import fiskfille.tf.nei.EnergonProcessorRecipeHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class PowerSourceRecipeHandler
extends EnergonProcessorRecipeHandler {
    private ArrayList<EnergonProcessorRecipeHandler.CachedProcessorRecipe> processorRecipes;

    @Override
    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"recipe.power_source");
    }

    @Override
    public TemplateRecipeHandler newInstance() {
        if (this.processorRecipes == null || this.processorRecipes.isEmpty()) {
            this.findProcessorRecipes();
        }
        return super.newInstance();
    }

    private void findProcessorRecipes() {
        this.processorRecipes = Lists.newArrayList();
        for (ItemStack item : ItemList.items) {
            this.loadProcessorCraftingRecipes(item);
            this.loadProcessorUsageRecipes(item);
        }
    }

    public void loadProcessorCraftingRecipes(ItemStack result) {
        Item item = result.func_77973_b();
        if (item instanceof IFluidContainerItem) {
            int amount;
            IFluidContainerItem container = (IFluidContainerItem)item;
            FluidStack stack = container.getFluid(result);
            int n = amount = stack != null ? stack.amount : 0;
            if (!ItemFuelCanister.isEmpty(result) && stack.getFluid() == TFFluids.energon) {
                Map<String, Float> ratios = FluidEnergon.getRatios(stack);
                for (EnergonProcessorRecipeHandler.CrystalPair crystal : crystals) {
                    String id = crystal.energon.getEnergonType().getId();
                    int mass = crystal.energon.getMass();
                    if (!(ratios.get(id).floatValue() > 0.0f) || amount < mass) continue;
                    result.field_77994_a = 1;
                    EnergonProcessorRecipeHandler.CachedProcessorRecipe recipe = new EnergonProcessorRecipeHandler.CachedProcessorRecipe(crystal.stack, result);
                    FluidStack stack1 = new FluidStack(TFFluids.energon, 0);
                    for (Map.Entry<String, Float> e : ratios.entrySet()) {
                        Energon energon = TransformersAPI.getEnergonTypeByName(e.getKey());
                        int amount1 = Math.round(e.getValue().floatValue() * (float)amount);
                        if (e.getKey().equals(id)) {
                            amount1 -= mass;
                        }
                        if (amount1 <= 0) continue;
                        stack1.amount += amount1;
                        FluidEnergon.merge(stack1, FluidEnergon.create(energon, 0), amount1);
                    }
                    recipe.tank.fill(stack1, true);
                    recipe.computeVisuals();
                    this.processorRecipes.add(recipe);
                }
            }
        }
    }

    public void loadProcessorUsageRecipes(ItemStack ingredient) {
        Item item = ingredient.func_77973_b();
        if (item instanceof IEnergon || item instanceof ItemBlock && Block.func_149634_a((Item)item) instanceof IEnergon) {
            EnergonProcessorRecipeHandler.CachedProcessorRecipe recipe = new EnergonProcessorRecipeHandler.CachedProcessorRecipe(new ItemStack(ingredient.func_77973_b(), 1, ingredient.func_77960_j()), new ItemStack(TFItems.fuelCanister));
            FluidStack stack = FluidEnergon.create(ingredient);
            ((ItemFuelCanister)recipe.result.item.func_77973_b()).fill(recipe.result.item, stack, true);
            recipe.computeVisuals();
            this.processorRecipes.add(recipe);
        }
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
    }

    @Override
    public void loadUsageRecipes(ItemStack ingredient) {
        if (this.processorRecipes == null || this.processorRecipes.isEmpty()) {
            this.findProcessorRecipes();
        }
        for (EnergonProcessorRecipeHandler.PowerSourcePair powerSource : powerSources) {
            if (!powerSource.stack.contains(ingredient)) continue;
            this.arecipes.add(new CachedPowerSourceRecipe(powerSource));
        }
    }

    public List<String> handleItemTooltip(GuiRecipe gui, ItemStack stack, List<String> currenttip, int recipe) {
        CachedPowerSourceRecipe crecipe = (CachedPowerSourceRecipe)((Object)this.arecipes.get(recipe));
        EnergonProcessorRecipeHandler.PowerSourcePair powerSource = crecipe.powerSource;
        float burnTime = (float)powerSource.burnTime / 200.0f;
        if (gui.isMouseOver(powerSource.stack, recipe) && burnTime < 1.0f) {
            burnTime = 1.0f / burnTime;
            String s_time = Float.toString(burnTime);
            if (burnTime == (float)Math.round(burnTime)) {
                s_time = Integer.toString((int)burnTime);
            }
            currenttip.add(NEIClientUtils.translate((String)"recipe.fuel.required", (Object[])new Object[]{s_time}));
        } else if ((gui.isMouseOver(crecipe.getResult(), recipe) || gui.isMouseOver(crecipe.getIngredient(), recipe)) && burnTime > 1.0f) {
            String s_time = Float.toString(burnTime);
            if (burnTime == (float)Math.round(burnTime)) {
                s_time = Integer.toString((int)burnTime);
            }
            currenttip.add(NEIClientUtils.translate((String)("recipe.fuel." + (gui.isMouseOver(crecipe.getResult(), recipe) ? "produced" : "processed")), (Object[])new Object[]{s_time}));
        }
        return currenttip;
    }

    @Override
    public List<EnergonProcessorRecipeHandler.CachedProcessorRecipe> getProcessorRecipes() {
        return this.processorRecipes;
    }

    public class CachedPowerSourceRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public EnergonProcessorRecipeHandler.PowerSourcePair powerSource;

        public CachedPowerSourceRecipe(EnergonProcessorRecipeHandler.PowerSourcePair powerSource) {
            super((TemplateRecipeHandler)PowerSourceRecipeHandler.this);
            this.powerSource = powerSource;
        }

        public PositionedStack getIngredient() {
            return ((EnergonProcessorRecipeHandler.CachedProcessorRecipe)((Object)((PowerSourceRecipeHandler)PowerSourceRecipeHandler.this).processorRecipes.get((int)(PowerSourceRecipeHandler.this.cycleticks / 48 % ((PowerSourceRecipeHandler)PowerSourceRecipeHandler.this).processorRecipes.size())))).ingredient;
        }

        public PositionedStack getResult() {
            return ((EnergonProcessorRecipeHandler.CachedProcessorRecipe)((Object)((PowerSourceRecipeHandler)PowerSourceRecipeHandler.this).processorRecipes.get((int)(PowerSourceRecipeHandler.this.cycleticks / 48 % ((PowerSourceRecipeHandler)PowerSourceRecipeHandler.this).processorRecipes.size())))).result;
        }

        public PositionedStack getOtherStack() {
            return this.powerSource.stack;
        }
    }
}

