/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.ItemList;
import codechicken.nei.PositionedStack;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import fiskfille.tf.TransformersAPI;
import fiskfille.tf.client.gui.GuiEnergonProcessor;
import fiskfille.tf.common.energon.Energon;
import fiskfille.tf.common.energon.IEnergon;
import fiskfille.tf.common.fluid.FluidEnergon;
import fiskfille.tf.common.fluid.FluidTankTF;
import fiskfille.tf.common.fluid.TFFluids;
import fiskfille.tf.common.item.ItemFuelCanister;
import fiskfille.tf.common.item.TFItems;
import fiskfille.tf.common.recipe.PowerManager;
import fiskfille.tf.helper.TFFluidRenderHelper;
import fiskfille.tf.helper.TFFormatHelper;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import org.lwjgl.opengl.GL11;

public class EnergonProcessorRecipeHandler
extends TemplateRecipeHandler {
    public static ArrayList<PowerSourcePair> powerSources;
    public static ArrayList<CrystalPair> crystals;

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiEnergonProcessor.class;
    }

    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"recipe.energon_processor");
    }

    public TemplateRecipeHandler newInstance() {
        if (powerSources == null || powerSources.isEmpty()) {
            this.findPowerSources();
        }
        if (crystals == null || crystals.isEmpty()) {
            this.findCrystals();
        }
        return super.newInstance();
    }

    private void findPowerSources() {
        powerSources = Lists.newArrayList();
        for (Map.Entry<ItemStack, Integer> e : PowerManager.powerSources.entrySet()) {
            if (e.getValue() <= 0) continue;
            powerSources.add(new PowerSourcePair(e.getKey().func_77946_l(), e.getValue()));
        }
    }

    private void findCrystals() {
        crystals = Lists.newArrayList();
        for (ItemStack itemstack : ItemList.items) {
            Item item = itemstack.func_77973_b();
            if (!(item instanceof IEnergon) && (!(item instanceof ItemBlock) || !(Block.func_149634_a((Item)item) instanceof IEnergon))) continue;
            IEnergon ienergon = (IEnergon)(item instanceof ItemBlock ? Block.func_149634_a((Item)item) : item);
            crystals.add(new CrystalPair(itemstack, ienergon));
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        Item item = result.func_77973_b();
        if (item instanceof IFluidContainerItem) {
            int amount;
            IFluidContainerItem container = (IFluidContainerItem)item;
            FluidStack stack = container.getFluid(result);
            int n = amount = stack != null ? stack.amount : 0;
            if (!ItemFuelCanister.isEmpty(result) && stack.getFluid() == TFFluids.energon) {
                Map<String, Float> ratios = FluidEnergon.getRatios(stack);
                for (CrystalPair crystal : crystals) {
                    String id = crystal.energon.getEnergonType().getId();
                    int mass = crystal.energon.getMass();
                    if (!(ratios.get(id).floatValue() > 0.0f) || amount < mass) continue;
                    result.field_77994_a = 1;
                    CachedProcessorRecipe recipe = new CachedProcessorRecipe(crystal.stack, result);
                    FluidStack stack1 = new FluidStack(TFFluids.energon, 0);
                    for (Map.Entry<String, Float> e : ratios.entrySet()) {
                        Energon energon = TransformersAPI.getEnergonTypeByName(e.getKey());
                        int amount1 = Math.round(e.getValue().floatValue() * (float)amount);
                        if (e.getKey().equals(id)) {
                            amount1 -= mass;
                        }
                        if (amount1 <= 0) continue;
                        stack1.amount += amount1;
                        FluidEnergon.merge(stack1, FluidEnergon.create(energon, 0), amount1);
                    }
                    recipe.tank.fill(stack1, true);
                    recipe.computeVisuals();
                    this.arecipes.add(recipe);
                }
            }
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        Item item = ingredient.func_77973_b();
        if (item instanceof IEnergon || item instanceof ItemBlock && Block.func_149634_a((Item)item) instanceof IEnergon) {
            CachedProcessorRecipe recipe = new CachedProcessorRecipe(new ItemStack(ingredient.func_77973_b(), 1, ingredient.func_77960_j()), new ItemStack(TFItems.fuelCanister));
            FluidStack stack = FluidEnergon.create(ingredient);
            ((ItemFuelCanister)recipe.result.item.func_77973_b()).fill(recipe.result.item, stack, true);
            recipe.computeVisuals();
            this.arecipes.add(recipe);
        }
    }

    public String getGuiTexture() {
        return "transformers:textures/gui/container/energon_processor.png";
    }

    public void drawExtras(int recipe) {
        this.drawProgressBar(20, 25, 176, 0, 14, 14, 48, 7);
        this.drawProgressBar(42, 24, 176, 14, 24, 17, 48, 0);
        this.drawProgressBar(130, 25, 176, 31, 13, 12, 48, 0);
        GL11.glEnable((int)3042);
        TFFluidRenderHelper.renderIntoGUI(this.getProcessorRecipes().get((int)recipe).tank, 74, 8, 48, 48, GuiDraw.gui.getZLevel());
        GL11.glDisable((int)3042);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)72, (int)6, (int)204, (int)0, (int)52, (int)52);
    }

    public List<String> handleTooltip(GuiRecipe gui, List<String> currenttip, int recipe) {
        currenttip = super.handleTooltip(gui, currenttip, recipe);
        int guiLeft = (Integer)ObfuscationReflectionHelper.getPrivateValue(GuiContainer.class, (Object)gui, (int)4);
        int guiTop = (Integer)ObfuscationReflectionHelper.getPrivateValue(GuiContainer.class, (Object)gui, (int)5);
        Point mousepos = GuiDraw.getMousePosition();
        Point relMouse = new Point(mousepos.x - guiLeft, mousepos.y - guiTop);
        Point recipepos = gui.getRecipePosition(recipe);
        if (currenttip.isEmpty() && GuiContainerManager.getStackMouseOver((GuiContainer)gui) == null && new Rectangle(recipepos.x + 72, recipepos.y + 6, 52, 52).contains(relMouse)) {
            currenttip.addAll(TFFormatHelper.toString(this.getProcessorRecipes().get((int)recipe).tank.format()));
        }
        return currenttip;
    }

    public List<CachedProcessorRecipe> getProcessorRecipes() {
        ArrayList list = Lists.newArrayList();
        for (TemplateRecipeHandler.CachedRecipe recipe : this.arecipes) {
            if (!(recipe instanceof CachedProcessorRecipe)) continue;
            list.add((CachedProcessorRecipe)recipe);
        }
        return list;
    }

    public static class CrystalPair {
        public ItemStack stack;
        public IEnergon energon;

        public CrystalPair(ItemStack ingred, IEnergon energon) {
            this.stack = ingred;
            this.energon = energon;
        }
    }

    public static class PowerSourcePair {
        public PositionedStack stack;
        public int burnTime;

        public PowerSourcePair(ItemStack ingred, int burnTime) {
            this.stack = new PositionedStack((Object)ingred, 19, 42, false);
            this.burnTime = burnTime;
        }
    }

    public class CachedProcessorRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public PositionedStack ingredient;
        public PositionedStack result;
        public FluidTankTF tank;

        public CachedProcessorRecipe(ItemStack in, ItemStack out) {
            super((TemplateRecipeHandler)EnergonProcessorRecipeHandler.this);
            this.tank = new FluidTankTF(2000);
            this.ingredient = new PositionedStack((Object)in, 19, 6);
            this.result = new PositionedStack((Object)out, 133, 42);
        }

        public PositionedStack getIngredient() {
            return this.ingredient;
        }

        public PositionedStack getResult() {
            return this.result;
        }

        public PositionedStack getOtherStack() {
            return EnergonProcessorRecipeHandler.powerSources.get((int)(EnergonProcessorRecipeHandler.this.cycleticks / 48 % EnergonProcessorRecipeHandler.powerSources.size())).stack;
        }

        public void computeVisuals() {
            this.ingredient.generatePermutations();
        }
    }
}

