/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import fiskfille.tf.client.gui.GuiAlloyCrucible;
import fiskfille.tf.common.recipe.AlloyRecipes;
import fiskfille.tf.common.tileentity.TileEntityAlloyCrucible;
import fiskfille.tf.helper.TFFormatHelper;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.opengl.GL11;

public class AlloyCrucibleRecipeHandler
extends TemplateRecipeHandler {
    public static TileEntityAlloyCrucible tileentity;

    public TemplateRecipeHandler newInstance() {
        if (tileentity == null) {
            tileentity = new TileEntityAlloyCrucible();
            AlloyCrucibleRecipeHandler.tileentity.alloyResult = true;
        }
        return super.newInstance();
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(102, 38, 16, 16), "alloy_crucible", new Object[0]));
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiAlloyCrucible.class;
    }

    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"recipe.alloy_crucible");
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("alloy_crucible") && ((Object)((Object)this)).getClass() == AlloyCrucibleRecipeHandler.class) {
            Map recipes = AlloyRecipes.getInstance().getSmeltingList();
            for (Map.Entry e : recipes.entrySet()) {
                AlloyPair recipe = new AlloyPair((AlloyRecipes.AlloyIngredients)e.getKey(), (ItemStack)e.getValue());
                recipe.computeVisuals();
                this.arecipes.add(recipe);
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        Map recipes = AlloyRecipes.getInstance().getSmeltingList();
        for (Map.Entry e : recipes.entrySet()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)((ItemStack)e.getValue()), (ItemStack)result)) continue;
            AlloyPair recipe = new AlloyPair((AlloyRecipes.AlloyIngredients)e.getKey(), (ItemStack)e.getValue());
            recipe.computeVisuals();
            this.arecipes.add(recipe);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        Map recipes = AlloyRecipes.getInstance().getSmeltingList();
        block0: for (Map.Entry e : recipes.entrySet()) {
            AlloyPair recipe = new AlloyPair((AlloyRecipes.AlloyIngredients)e.getKey(), (ItemStack)e.getValue());
            for (int i = 0; i < recipe.getIngredients().size(); ++i) {
                if (!recipe.getIngredients().get(i).contains(ingredient)) continue;
                recipe.computeVisuals();
                this.arecipes.add(recipe);
                continue block0;
            }
        }
    }

    public String getGuiTexture() {
        return "transformers:textures/gui/container/alloy_crucible.png";
    }

    public void drawExtras(int recipe) {
        this.drawProgressBar(102, 40, 192, 0, 14, 14, 48, 3);
        this.drawProgressBar(44, 8, 176, 0, 16, 52, 2496, 7);
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)5, (int)11, (int)166, (int)65);
    }

    public List<String> handleTooltip(GuiRecipe gui, List<String> currenttip, int recipe) {
        currenttip = super.handleTooltip(gui, currenttip, recipe);
        int guiLeft = (Integer)ObfuscationReflectionHelper.getPrivateValue(GuiContainer.class, (Object)gui, (int)4);
        int guiTop = (Integer)ObfuscationReflectionHelper.getPrivateValue(GuiContainer.class, (Object)gui, (int)5);
        Point pos = GuiDraw.getMousePosition();
        Point offset = gui.getRecipePosition(recipe);
        Point relMouse = new Point(pos.x - guiLeft - offset.x, pos.y - guiTop - offset.y);
        if (new Rectangle(44, 8, 16, 52).contains(relMouse) && currenttip.isEmpty()) {
            AlloyCrucibleRecipeHandler.tileentity.smeltingResult = this.getResultStack((int)recipe).item;
            currenttip.add(StatCollector.func_74837_a((String)"gui.emb.amount", (Object[])new Object[]{TFFormatHelper.formatNumber((float)tileentity.getSmeltTimeMax() * tileentity.getConsumptionRate())}));
        }
        return currenttip;
    }

    public String getOverlayIdentifier() {
        return "alloy_crucible";
    }

    public class AlloyPair
    extends TemplateRecipeHandler.CachedRecipe {
        public ArrayList<PositionedStack> ingredients;
        public PositionedStack result;

        public AlloyPair(AlloyRecipes.AlloyIngredients alloy, ItemStack out) {
            super((TemplateRecipeHandler)AlloyCrucibleRecipeHandler.this);
            this.result = new PositionedStack((Object)out, 102, 17);
            this.ingredients = new ArrayList();
            for (int i = 0; i < alloy.getIngredients().length; ++i) {
                LinkedList ingredients = Lists.newLinkedList();
                List<String> list = alloy.getOreDictNames(i);
                for (int j = 0; j < list.size(); ++j) {
                    ingredients.addAll(OreDictionary.getOres((String)list.get(j)));
                }
                LinkedList items = ingredients;
                if (ingredients.isEmpty()) {
                    items = alloy.getIngredients()[i];
                }
                this.addSlotToContainer(73, 19 + i * 18, items);
            }
        }

        private void addSlotToContainer(int x, int y, Object item) {
            if (item != null) {
                PositionedStack stack = new PositionedStack(item, x - 5, y - 11, false);
                this.ingredients.add(stack);
            }
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(AlloyCrucibleRecipeHandler.this.cycleticks / 20, this.ingredients);
        }

        public PositionedStack getResult() {
            return this.result;
        }

        public void computeVisuals() {
            for (PositionedStack p : this.ingredients) {
                p.generatePermutations();
            }
        }
    }
}

