/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.helper;

import com.google.common.collect.Maps;
import fiskfille.tf.common.data.tile.TileData;
import fiskfille.tf.common.item.ItemCSD;
import fiskfille.tf.common.tileentity.IMultiTile;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;

public class TFTileHelper {
    private static Map<ItemCSD.DimensionalCoords, TileData> tileData = Maps.newHashMap();

    public static TileData getTileData(ItemCSD.DimensionalCoords coords) {
        return tileData.get((Object)coords);
    }

    public static Map<ItemCSD.DimensionalCoords, TileData> getTileData() {
        return tileData;
    }

    public static void clearTileData() {
        for (Map.Entry<ItemCSD.DimensionalCoords, TileData> e : tileData.entrySet()) {
            e.getValue().kill();
        }
    }

    public static void putServerData(TileData data) {
        TFTileHelper.putServerData(data.getCoords(), data);
    }

    public static void putServerData(ItemCSD.DimensionalCoords coords, TileData data) {
        if (data == null) {
            tileData.remove((Object)coords);
            return;
        }
        tileData.put(coords, data);
    }

    public static int[] getTileBaseOffsets(TileEntity tile, int metadata) {
        if (tile instanceof IMultiTile) {
            return ((IMultiTile)tile).getBaseOffsets(metadata);
        }
        return new int[]{0, 0, 0};
    }

    public static <T extends TileEntity> T getTileBase(T tile) {
        int[] offsets = TFTileHelper.getTileBaseOffsets(tile, tile != null ? tile.func_145832_p() : 0);
        if (offsets[0] != 0 || offsets[1] != 0 || offsets[2] != 0) {
            return (T)tile.func_145831_w().func_147438_o(tile.field_145851_c + offsets[0], tile.field_145848_d + offsets[1], tile.field_145849_e + offsets[2]);
        }
        return tile;
    }
}

