/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.helper;

import cpw.mods.fml.common.ObfuscationReflectionHelper;
import fiskfille.tf.client.model.transformer.definition.TFModelRegistry;
import fiskfille.tf.client.model.transformer.definition.TransformerModel;
import fiskfille.tf.common.data.TFData;
import fiskfille.tf.common.energon.power.IEnergyReceiver;
import fiskfille.tf.common.energon.power.IEnergyTransmitter;
import fiskfille.tf.common.energon.power.IReceiverRender;
import fiskfille.tf.common.energon.power.ITransmitterRender;
import fiskfille.tf.common.energon.power.ReceiverEntry;
import fiskfille.tf.common.energon.power.TransmissionHandler;
import fiskfille.tf.common.item.ItemCSD;
import fiskfille.tf.common.item.armor.ItemTransformerArmor;
import fiskfille.tf.common.tick.ClientTickHandler;
import fiskfille.tf.common.tileentity.TileEntityMachine;
import fiskfille.tf.common.tileentity.TileEntityRelayTower;
import fiskfille.tf.common.transformer.base.Transformer;
import fiskfille.tf.helper.TFArmorDyeHelper;
import fiskfille.tf.helper.TFEnergyHelper;
import fiskfille.tf.helper.TFHelper;
import fiskfille.tf.helper.TFTextureHelper;
import fiskfille.tf.helper.TFTileHelper;
import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.DestroyBlockProgress;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class TFRenderHelper {
    private static Minecraft mc = Minecraft.func_71410_x();
    private static RenderItem itemRender = new RenderItem();
    private static float lastBrightnessX;
    private static float lastBrightnessY;
    private static final Map<EntityPlayer, Double> previousMotionY;
    public static final int LIGHTING_LUMINOUS = 61680;

    public static void setLighting(int lighting) {
        TFRenderHelper.storeLighting();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)(lighting % 65536) / 255.0f), (float)((float)(lighting / 65536) / 255.0f));
    }

    public static void storeLighting() {
        lastBrightnessX = OpenGlHelper.lastBrightnessX;
        lastBrightnessY = OpenGlHelper.lastBrightnessY;
    }

    public static void resetLighting() {
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastBrightnessX, (float)lastBrightnessY);
    }

    public static float[] hexToRGB(int hex) {
        float r = (float)((hex & 0xFF0000) >> 16) / 255.0f;
        float g = (float)((hex & 0xFF00) >> 8) / 255.0f;
        float b = (float)(hex & 0xFF) / 255.0f;
        return new float[]{r, g, b};
    }

    public static void setupRenderLayers(Entity entity, ItemStack itemstack, ModelRenderer model) {
        if (itemstack != null && itemstack.func_77973_b() instanceof ItemTransformerArmor) {
            Transformer transformer = ((ItemTransformerArmor)itemstack.func_77973_b()).getTransformer();
            TransformerModel tfModel = TFModelRegistry.getModel(transformer);
            if (TFTextureHelper.isBoundTexture(TFTextureHelper.RES_ITEM_GLINT)) {
                model.func_78785_a(0.0625f);
            } else {
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                if (TFArmorDyeHelper.isDyed(itemstack)) {
                    float[] primaryColor = TFRenderHelper.hexToRGB(TFArmorDyeHelper.getPrimaryColor(itemstack));
                    float[] secondaryColor = TFRenderHelper.hexToRGB(TFArmorDyeHelper.getSecondaryColor(itemstack));
                    GL11.glColor4f((float)primaryColor[0], (float)primaryColor[1], (float)primaryColor[2], (float)1.0f);
                    mc.func_110434_K().func_110577_a(tfModel.getTexture(entity, "_primary"));
                    model.func_78785_a(0.0625f);
                    GL11.glColor4f((float)secondaryColor[0], (float)secondaryColor[1], (float)secondaryColor[2], (float)1.0f);
                    mc.func_110434_K().func_110577_a(tfModel.getTexture(entity, "_secondary"));
                    model.func_78785_a(0.0625f);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    mc.func_110434_K().func_110577_a(tfModel.getTexture(entity, "_base"));
                } else {
                    mc.func_110434_K().func_110577_a(tfModel.getTexture(entity, ""));
                }
                model.func_78785_a(0.0625f);
                if (tfModel.hasLightsLayer()) {
                    TFRenderHelper.setLighting(61680);
                    mc.func_110434_K().func_110577_a(tfModel.getTexture(entity, "_lights"));
                    model.func_78785_a(0.0625f);
                    TFRenderHelper.resetLighting();
                }
                GL11.glDisable((int)3042);
            }
        }
    }

    public static void startGlScissor(int x, int y, int width, int height) {
        ScaledResolution reso = new ScaledResolution(mc, TFRenderHelper.mc.field_71443_c, TFRenderHelper.mc.field_71440_d);
        double scaleW = (double)TFRenderHelper.mc.field_71443_c / reso.func_78327_c();
        double scaleH = (double)TFRenderHelper.mc.field_71440_d / reso.func_78324_d();
        if (width <= 0 || height <= 0) {
            return;
        }
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        GL11.glEnable((int)3089);
        GL11.glScissor((int)((int)Math.floor((double)x * scaleW)), (int)((int)Math.floor((double)TFRenderHelper.mc.field_71440_d - (double)(y + height) * scaleH)), (int)((int)Math.floor((double)(x + width) * scaleW) - (int)Math.floor((double)x * scaleW)), (int)((int)Math.floor((double)TFRenderHelper.mc.field_71440_d - (double)y * scaleH) - (int)Math.floor((double)TFRenderHelper.mc.field_71440_d - (double)(y + height) * scaleH)));
    }

    public static void endGlScissor() {
        GL11.glDisable((int)3089);
    }

    public static double getMotionY(EntityPlayer player) {
        double current = player == TFRenderHelper.mc.field_71439_g ? player.field_70181_x : player.field_70163_u - player.field_70167_r;
        double previous = previousMotionY.containsKey(player) ? previousMotionY.get(player) : 0.0;
        return TFHelper.median(current, previous, ClientTickHandler.renderTick);
    }

    public static void updateMotionY(EntityPlayer player) {
        previousMotionY.put(player, player == TFRenderHelper.mc.field_71439_g ? player.field_70181_x : player.field_70163_u - player.field_70167_r);
    }

    public static void renderTag(String s, float x, float y, float z) {
        RenderManager renderManager = RenderManager.field_78727_a;
        FontRenderer fontrenderer = renderManager.func_78716_a();
        float f2 = -0.02f;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)z);
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(TFRenderHelper.mc.field_71439_g.field_70177_z + 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-TFRenderHelper.mc.field_71439_g.field_70125_A), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)(-f2), (float)(-f2), (float)f2);
        GL11.glDisable((int)2896);
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glDisable((int)3553);
        tessellator.func_78382_b();
        int i = fontrenderer.func_78256_a(s) / 2;
        tessellator.func_78369_a(0.0f, 0.0f, 0.0f, 0.25f);
        tessellator.func_78377_a((double)(-i - 1), -1.0, 0.0);
        tessellator.func_78377_a((double)(-i - 1), 8.0, 0.0);
        tessellator.func_78377_a((double)(i + 1), 8.0, 0.0);
        tessellator.func_78377_a((double)(i + 1), -1.0, 0.0);
        tessellator.func_78381_a();
        GL11.glEnable((int)3553);
        GL11.glDepthMask((boolean)true);
        fontrenderer.func_78276_b(s, -fontrenderer.func_78256_a(s) / 2, 0, -1);
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    public static void faceVec(Vec3 src, Vec3 dst) {
        double d0 = dst.field_72450_a - src.field_72450_a;
        double d1 = dst.field_72448_b - src.field_72448_b;
        double d2 = dst.field_72449_c - src.field_72449_c;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        float yaw = (float)(Math.atan2(d2, d0) * 180.0 / Math.PI) - 90.0f;
        float pitch = (float)(-(Math.atan2(d1, d3) * 180.0 / Math.PI));
        GL11.glRotated((double)(-yaw), (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)pitch, (double)1.0, (double)0.0, (double)0.0);
    }

    public static void renderEnergyTransmissions(TileEntity transmitterTile, double x, double y, double z, float partialTicks) {
        GL11.glPushMatrix();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        TFRenderHelper.setLighting(61680);
        IEnergyTransmitter transmitter = (IEnergyTransmitter)transmitterTile;
        TransmissionHandler transmissionHandler = transmitter.getTransmissionHandler();
        boolean renderBeams = false;
        if (transmitterTile instanceof TileEntityRelayTower) {
            TileEntityRelayTower relay = (TileEntityRelayTower)transmitterTile;
            renderBeams = relay.data.isPowered;
        } else {
            boolean bl = renderBeams = transmitter.getEnergy() > 0.0f;
        }
        if (transmitterTile instanceof TileEntityMachine) {
            TileEntityMachine machine = (TileEntityMachine)transmitterTile;
            renderBeams &= machine.canActivate();
        }
        if (renderBeams) {
            for (ReceiverEntry entry : transmissionHandler.getReceivers()) {
                Vec3 dstOffset;
                Vec3 srcOffset;
                boolean invertCurrent = transmitterTile instanceof TileEntityRelayTower && ((TileEntityRelayTower)transmitterTile).data.invertCurrent.contains((Object)entry.getCoords());
                boolean canReach = entry.canReach();
                if (entry.getTile() == null) continue;
                TileEntity tile = transmitterTile;
                Vec3 srcOffset1 = transmitter.getEnergyOutputOffset();
                Vec3 dstOffset1 = entry.getReceiver().getEnergyInputOffset();
                if (tile instanceof ITransmitterRender) {
                    srcOffset1 = ((ITransmitterRender)tile).getRenderOutputOffset();
                }
                if (entry.getTile() instanceof IReceiverRender) {
                    dstOffset1 = ((IReceiverRender)entry.getTile()).getRenderInputOffset();
                }
                if (invertCurrent) {
                    tile = entry.getTile();
                    entry = new ReceiverEntry(transmitterTile);
                    entry.setCanReach(canReach);
                    srcOffset = dstOffset1.func_72441_c(0.0, 0.0, 0.0);
                    dstOffset = srcOffset1.func_72441_c(0.0, 0.0, 0.0);
                } else {
                    srcOffset = srcOffset1.func_72441_c(0.0, 0.0, 0.0);
                    dstOffset = dstOffset1.func_72441_c(0.0, 0.0, 0.0);
                }
                IEnergyReceiver receiver = entry.getReceiver();
                ItemCSD.DimensionalCoords coords = entry.getCoords();
                Vec3 src = srcOffset.func_72441_c((double)((float)tile.field_145851_c + 0.5f), (double)((float)tile.field_145848_d + 0.5f), (double)((float)tile.field_145849_e + 0.5f));
                Vec3 dst = dstOffset.func_72441_c((double)((float)coords.field_71574_a + 0.5f), (double)((float)coords.field_71572_b + 0.5f), (double)((float)coords.field_71573_c + 0.5f));
                if (!canReach) {
                    double d = 1.0 / dst.func_72438_d(src);
                    src = Vec3.func_72443_a((double)(src.field_72450_a + (dst.field_72450_a - src.field_72450_a) * d), (double)(src.field_72448_b + (dst.field_72448_b - src.field_72448_b) * d), (double)(src.field_72449_c + (dst.field_72449_c - src.field_72449_c) * d));
                    MovingObjectPosition mop = TFEnergyHelper.rayTraceBlocks(tile.func_145831_w(), src, dst);
                    if (mop != null) {
                        dst = mop.field_72307_f;
                    }
                }
                double x1 = 0.5 + srcOffset.field_72450_a;
                double y1 = 0.5 + srcOffset.field_72448_b;
                double z1 = 0.5 + srcOffset.field_72449_c;
                double deltaX = dst.field_72450_a - (double)tile.field_145851_c;
                double deltaY = dst.field_72448_b - (double)tile.field_145848_d;
                double deltaZ = dst.field_72449_c - (double)tile.field_145849_e;
                src = Vec3.func_72443_a((double)x1, (double)y1, (double)z1);
                dst = Vec3.func_72443_a((double)deltaX, (double)deltaY, (double)deltaZ);
                int primary = 5745583;
                int secondary = 8123128;
                int parentPrimary = primary;
                int parentSecondary = secondary;
                if (!canReach) {
                    primary = 11492183;
                    secondary = 16286075;
                }
                GL11.glPushMatrix();
                GL11.glTranslated((double)(x + x1), (double)(y + y1), (double)(z + z1));
                if (invertCurrent) {
                    GL11.glTranslated((double)(tile.field_145851_c - coords.field_71574_a), (double)(tile.field_145848_d - coords.field_71572_b), (double)(tile.field_145849_e - coords.field_71573_c));
                }
                TFRenderHelper.renderEnergyBeam(src, dst, primary, secondary, parentPrimary, parentSecondary);
                GL11.glPopMatrix();
            }
        }
        TFRenderHelper.resetLighting();
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glPopMatrix();
    }

    public static void renderEnergyBeam(Vec3 src, Vec3 dst, int primaryColor, int secondaryColor, int primaryParentColor, int secondaryParentColor) {
        Tessellator tessellator = Tessellator.field_78398_a;
        float partialTicks = ClientTickHandler.renderTick;
        float[] primary = TFRenderHelper.hexToRGB(primaryColor);
        float[] secondary = TFRenderHelper.hexToRGB(secondaryColor);
        float[] parentPrimary = TFRenderHelper.hexToRGB(primaryParentColor);
        float[] parentSecondary = TFRenderHelper.hexToRGB(secondaryParentColor);
        double width = 0.0625;
        double length = src.func_72438_d(dst);
        int segments = MathHelper.func_76128_c((double)(length * 8.0));
        TFRenderHelper.faceVec(src, dst);
        for (int i = 0; i < segments; ++i) {
            double segmentLength = length / (double)segments;
            double start = (double)i * segmentLength;
            double end = (double)(i + 1) * segmentLength;
            float f = (float)Math.cos((float)i / ((float)segments * 0.15625f) - ((float)TFRenderHelper.mc.field_71439_g.field_70173_aa + partialTicks) / 5.0f);
            float f1 = 1.0f - f;
            float f2 = Math.min((float)i / (float)segments * 3.0f, 1.0f);
            float f3 = 1.0f - f2;
            tessellator.func_78382_b();
            tessellator.func_78369_a((primary[0] * f + secondary[0] * f1) * f2 + (parentPrimary[0] * f + parentSecondary[0] * f1) * f3, (primary[1] * f + secondary[1] * f1) * f2 + (parentPrimary[1] * f + parentSecondary[1] * f1) * f3, (primary[2] * f + secondary[2] * f1) * f2 + (parentPrimary[2] * f + parentSecondary[2] * f1) * f3, 1.0f);
            tessellator.func_78377_a(width, width, end);
            tessellator.func_78377_a(width, width, start);
            tessellator.func_78377_a(-width, width, start);
            tessellator.func_78377_a(-width, width, end);
            tessellator.func_78377_a(-width, -width, start);
            tessellator.func_78377_a(width, -width, start);
            tessellator.func_78377_a(width, -width, end);
            tessellator.func_78377_a(-width, -width, end);
            tessellator.func_78377_a(-width, width, start);
            tessellator.func_78377_a(-width, -width, start);
            tessellator.func_78377_a(-width, -width, end);
            tessellator.func_78377_a(-width, width, end);
            tessellator.func_78377_a(width, -width, end);
            tessellator.func_78377_a(width, -width, start);
            tessellator.func_78377_a(width, width, start);
            tessellator.func_78377_a(width, width, end);
            if (i == segments - 1) {
                tessellator.func_78377_a(width, -width, end);
                tessellator.func_78377_a(width, width, end);
                tessellator.func_78377_a(-width, width, end);
                tessellator.func_78377_a(-width, -width, end);
            } else if (i == 0) {
                tessellator.func_78377_a(-width, width, start);
                tessellator.func_78377_a(width, width, start);
                tessellator.func_78377_a(width, -width, start);
                tessellator.func_78377_a(-width, -width, start);
            }
            tessellator.func_78381_a();
        }
    }

    public static void renderEnergyStatic(Vec3 src, Vec3 dst, double width, float intensity, int segments, long seed) {
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glPushMatrix();
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        TFRenderHelper.setLighting(61680);
        GL11.glTranslated((double)(-src.field_72450_a), (double)(-src.field_72448_b), (double)(-src.field_72449_c));
        TFRenderHelper.faceVec(dst, src);
        GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        float[] primary = TFRenderHelper.hexToRGB(5745583);
        float[] secondary = TFRenderHelper.hexToRGB(8123128);
        double length = src.func_72438_d(dst);
        Random rand = new Random(seed + (long)(TFRenderHelper.mc.field_71439_g.field_70173_aa * 10));
        Random randPrev = new Random(seed + (long)((TFRenderHelper.mc.field_71439_g.field_70173_aa - 1) * 10));
        src = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        for (int i = 0; i < segments; ++i) {
            float f = (float)i / (float)segments;
            dst = Vec3.func_72443_a((double)0.0, (double)((double)(i + 1) * length / (double)segments), (double)0.0);
            if (i < segments - 1) {
                float angle = (float)Math.toRadians(90.0f * intensity) * (1.0f - f);
                dst.func_72440_a((TFHelper.median(rand.nextFloat(), randPrev.nextFloat(), ClientTickHandler.renderTick) - 0.5f) * 2.0f * angle);
                dst.func_72442_b((TFHelper.median(rand.nextFloat(), randPrev.nextFloat(), ClientTickHandler.renderTick) - 0.5f) * 2.0f * angle);
                dst.func_72446_c((TFHelper.median(rand.nextFloat(), randPrev.nextFloat(), ClientTickHandler.renderTick) - 0.5f) * 2.0f * angle);
            } else {
                dst = Vec3.func_72443_a((double)0.0, (double)length, (double)0.0);
            }
            dst.field_72450_a = MathHelper.func_151237_a((double)dst.field_72450_a, (double)-0.078125, (double)0.078125);
            dst.field_72449_c = MathHelper.func_151237_a((double)dst.field_72449_c, (double)-0.078125, (double)0.078125);
            dst.field_72448_b = MathHelper.func_151237_a((double)dst.field_72448_b, (double)0.0, (double)length);
            double segmentLength = src.func_72438_d(dst);
            float f1 = (float)Math.cos((float)i / ((float)segments * 0.15625f));
            float f2 = 1.0f - f1;
            tessellator.func_78382_b();
            tessellator.func_78369_a(primary[0] * f1 + secondary[0] * f2, primary[1] * f1 + secondary[1] * f2, primary[2] * f1 + secondary[2] * f2, 1.0f);
            tessellator.func_78377_a(width, width, segmentLength);
            tessellator.func_78377_a(width, width, 0.0);
            tessellator.func_78377_a(-width, width, 0.0);
            tessellator.func_78377_a(-width, width, segmentLength);
            tessellator.func_78377_a(-width, -width, 0.0);
            tessellator.func_78377_a(width, -width, 0.0);
            tessellator.func_78377_a(width, -width, segmentLength);
            tessellator.func_78377_a(-width, -width, segmentLength);
            tessellator.func_78377_a(-width, width, 0.0);
            tessellator.func_78377_a(-width, -width, 0.0);
            tessellator.func_78377_a(-width, -width, segmentLength);
            tessellator.func_78377_a(-width, width, segmentLength);
            tessellator.func_78377_a(width, -width, segmentLength);
            tessellator.func_78377_a(width, -width, 0.0);
            tessellator.func_78377_a(width, width, 0.0);
            tessellator.func_78377_a(width, width, segmentLength);
            tessellator.func_78377_a(width, -width, segmentLength);
            tessellator.func_78377_a(width, width, segmentLength);
            tessellator.func_78377_a(-width, width, segmentLength);
            tessellator.func_78377_a(-width, -width, segmentLength);
            tessellator.func_78377_a(-width, width, 0.0);
            tessellator.func_78377_a(width, width, 0.0);
            tessellator.func_78377_a(width, -width, 0.0);
            tessellator.func_78377_a(-width, -width, 0.0);
            GL11.glPushMatrix();
            GL11.glTranslated((double)src.field_72450_a, (double)src.field_72448_b, (double)src.field_72449_c);
            TFRenderHelper.faceVec(src, dst);
            tessellator.func_78381_a();
            GL11.glPopMatrix();
            src = dst;
        }
        TFRenderHelper.resetLighting();
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glPopMatrix();
    }

    public static int getBlockDestroyProgress(World world, int x, int y, int z) {
        Map damagedBlocks = (Map)ObfuscationReflectionHelper.getPrivateValue(RenderGlobal.class, (Object)TFRenderHelper.mc.field_71438_f, (String[])new String[]{"damagedBlocks", "field_72738_E", "O"});
        if (!damagedBlocks.isEmpty()) {
            for (DestroyBlockProgress progress : damagedBlocks.values()) {
                int metadata = world.func_72805_g(progress.func_73110_b(), progress.func_73109_c(), progress.func_73108_d());
                int[] offsets = TFTileHelper.getTileBaseOffsets(world.func_147438_o(x, y, z), metadata);
                if (x != progress.func_73110_b() + offsets[0] || y != progress.func_73109_c() + offsets[1] || z != progress.func_73108_d() + offsets[2]) continue;
                return progress.func_73106_e();
            }
        }
        return -1;
    }

    public static void renderBlock(Block block, IIcon icon, RenderBlocks renderer) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        renderer.func_147768_a(block, 0.0, 0.0, 0.0, icon);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        renderer.func_147806_b(block, 0.0, 0.0, 0.0, icon);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        renderer.func_147761_c(block, 0.0, 0.0, 0.0, icon);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        renderer.func_147734_d(block, 0.0, 0.0, 0.0, icon);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        renderer.func_147798_e(block, 0.0, 0.0, 0.0, icon);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        renderer.func_147764_f(block, 0.0, 0.0, 0.0, icon);
        tessellator.func_78381_a();
    }

    public static void renderBlock(Block block, int meta, RenderBlocks renderer) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        renderer.func_147768_a(block, 0.0, 0.0, 0.0, block.func_149691_a(0, meta));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        renderer.func_147806_b(block, 0.0, 0.0, 0.0, block.func_149691_a(1, meta));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        renderer.func_147761_c(block, 0.0, 0.0, 0.0, block.func_149691_a(2, meta));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        renderer.func_147734_d(block, 0.0, 0.0, 0.0, block.func_149691_a(3, meta));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        renderer.func_147798_e(block, 0.0, 0.0, 0.0, block.func_149691_a(4, meta));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        renderer.func_147764_f(block, 0.0, 0.0, 0.0, block.func_149691_a(5, meta));
        tessellator.func_78381_a();
    }

    public static void renderBlockAllFaces(RenderBlocks renderer, Block block, int x, int y, int z, IIcon icon) {
        renderer.func_147768_a(block, (double)x, (double)y, (double)z, icon);
        renderer.func_147806_b(block, (double)x, (double)y, (double)z, icon);
        renderer.func_147761_c(block, (double)x, (double)y, (double)z, icon);
        renderer.func_147734_d(block, (double)x, (double)y, (double)z, icon);
        renderer.func_147798_e(block, (double)x, (double)y, (double)z, icon);
        renderer.func_147764_f(block, (double)x, (double)y, (double)z, icon);
    }

    public static boolean shouldOverrideView(EntityPlayer player) {
        return TFHelper.getHeight(player) != 1.8f || TFHelper.getScale(player) != 1.0f;
    }

    public static boolean shouldOverrideThirdPersonDistance(EntityPlayer player) {
        return player.field_70154_o == null && (TFHelper.getTransformer((EntityLivingBase)player) != null || TFData.PREV_TRANSFORMER.get(player) != null);
    }

    public static void renderItemIntoGUI(int x, int y, ItemStack itemstack) {
        if (itemstack != null) {
            FontRenderer font = itemstack.func_77973_b().getFontRenderer(itemstack);
            if (font == null) {
                font = TFRenderHelper.mc.field_71466_p;
            }
            itemRender.func_82406_b(font, mc.func_110434_K(), itemstack, x, y);
            if (itemstack.field_77994_a > 1) {
                itemRender.func_94148_a(font, mc.func_110434_K(), itemstack, x, y, itemstack.field_77994_a + "");
            }
        }
    }

    public static void setupRenderItemIntoGUI() {
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2903);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)3042);
        RenderHelper.func_74520_c();
    }

    public static void finishRenderItemIntoGUI() {
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2896);
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    static {
        previousMotionY = new WeakHashMap<EntityPlayer, Double>();
    }
}

