/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.material.MapColor;
import net.minecraft.util.MathHelper;

public class TFMathHelper {
    public static int[] split(int number, int digits, int m) {
        int i;
        int[] increments = new int[digits];
        int[] aint = new int[digits];
        int incr = 1;
        int total = 0;
        for (i = 0; i < digits; ++i) {
            increments[i] = incr;
            incr *= m;
        }
        for (i = digits - 1; i >= 0; --i) {
            int j = MathHelper.func_76128_c((double)((float)number / (float)increments[i]));
            aint[i] = j * increments[i] - total;
            total = j * increments[i];
        }
        return aint;
    }

    public static <T> Object getMinKey(Map<T, Integer> map) {
        Object minKey = null;
        int minValue = Integer.MAX_VALUE;
        for (Map.Entry<T, Integer> e : map.entrySet()) {
            int value = e.getValue();
            if (value >= minValue) continue;
            minValue = value;
            minKey = e.getKey();
        }
        return minKey;
    }

    public static MapColor getClosestMapColor(int color) {
        ArrayList colors = Lists.newArrayList();
        for (int i = 0; i < MapColor.field_76281_a.length; ++i) {
            MapColor mapColor = MapColor.field_76281_a[i];
            if (mapColor == null) continue;
            colors.add(mapColor.field_76291_p);
        }
        int color1 = TFMathHelper.getClosestColor(color, colors);
        for (int i = 0; i < MapColor.field_76281_a.length; ++i) {
            MapColor mapColor = MapColor.field_76281_a[i];
            if (mapColor == null || mapColor.field_76291_p != color1) continue;
            return mapColor;
        }
        return MapColor.field_151660_b;
    }

    public static int getClosestColor(int color, List<Integer> colors) {
        HashMap distances = Maps.newHashMap();
        Color color1 = new Color(color);
        for (int color2 : colors) {
            distances.put(color2, TFMathHelper.getColorDistance(color1, new Color(color2)));
        }
        return (Integer)TFMathHelper.getMinKey(distances);
    }

    public static int getColorDistance(Color a, Color b) {
        return (int)Math.sqrt(Math.pow(a.getRed() - b.getRed(), 2.0) + Math.pow(a.getGreen() - b.getGreen(), 2.0) + Math.pow(a.getBlue() - b.getBlue(), 2.0));
    }
}

