/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.helper;

import fiskfille.tf.TransformersMod;
import fiskfille.tf.common.data.TFData;
import fiskfille.tf.common.fluid.FluidTankTF;
import fiskfille.tf.common.item.armor.ItemTransformerArmor;
import fiskfille.tf.common.transformer.base.Transformer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class TFHelper {
    public static boolean isTransformer(EntityLivingBase entity) {
        return TFHelper.isTransformer(entity.func_71124_b(4), entity.func_71124_b(3), entity.func_71124_b(2), entity.func_71124_b(1));
    }

    public static boolean isTransformer(ItemStack ... itemstacks) {
        ItemStack itemstack = itemstacks[0];
        for (int i = 1; i < itemstacks.length; ++i) {
            if (TFHelper.getTransformerFromArmor(itemstack) == null || TFHelper.getTransformerFromArmor(itemstack) != TFHelper.getTransformerFromArmor(itemstacks[i])) {
                return false;
            }
            itemstack = itemstacks[i];
        }
        return true;
    }

    public static Transformer getTransformer(EntityLivingBase entity) {
        if (entity != null && TFHelper.isTransformer(entity)) {
            return TFHelper.getTransformerFromArmor(entity, 0);
        }
        return null;
    }

    public static Transformer getTransformer(ItemStack ... itemstacks) {
        if (TFHelper.isTransformer(itemstacks)) {
            return TFHelper.getTransformerFromArmor(itemstacks[0]);
        }
        return null;
    }

    public static Transformer getTransformerFromArmor(EntityLivingBase entity, int slot) {
        return TFHelper.getTransformerFromArmor(entity.func_71124_b(slot + 1));
    }

    public static Transformer getTransformerFromArmor(ItemStack itemstack) {
        Item item;
        if (itemstack != null && (item = itemstack.func_77973_b()) instanceof ItemTransformerArmor) {
            return ((ItemTransformerArmor)item).getTransformer();
        }
        return null;
    }

    public static boolean isFullyTransformed(EntityPlayer player) {
        return TFHelper.isTransformer((EntityLivingBase)player) && TFHelper.getTransformationTimer(player) == 1.0f;
    }

    public static boolean isInRobotMode(EntityPlayer player) {
        return TFHelper.isTransformer((EntityLivingBase)player) && TFHelper.getTransformationTimer(player) == 0.0f;
    }

    public static boolean isInStealthMode(EntityPlayer player) {
        Transformer transformer = TFHelper.getTransformer((EntityLivingBase)player);
        int altMode = TFData.ALT_MODE.get(player);
        if (altMode == -1) {
            altMode = TFData.PREV_ALT_MODE.get(player);
        }
        return transformer != null && transformer.hasStealthForce(player, altMode) && altMode != -1 && TFHelper.getStealthModeTimer(player) > 0.0f;
    }

    public static float getTransformationTimer(EntityPlayer player) {
        return TFHelper.median(TFData.TRANSFORM_PROGRESS.get(player).floatValue(), TFData.PREV_TRANSFORM_PROGRESS.get(player).floatValue(), TransformersMod.proxy.getRenderTick());
    }

    public static float getStealthModeTimer(EntityPlayer player) {
        return TFHelper.median(TFData.STEALTH_FORCE_PROGRESS.get(player).floatValue(), TFData.PREV_STEALTH_FORCE_PROGRESS.get(player).floatValue(), TransformersMod.proxy.getRenderTick());
    }

    public static void applyFluidUsage(FluidTankTF tank) {
        FluidStack fluidStack = tank.getFluid();
        int usage = tank.getUsage();
        if (fluidStack != null) {
            fluidStack.amount += usage;
            if (fluidStack.amount < 0) {
                fluidStack.amount = 0;
            } else if (fluidStack.amount > tank.getCapacity()) {
                fluidStack.amount = tank.getCapacity();
            }
        }
    }

    public static float median(float curr, float prev, float partialTicks) {
        return prev + (curr - prev) * partialTicks;
    }

    public static double median(double curr, double prev, float partialTicks) {
        return prev + (curr - prev) * (double)partialTicks;
    }

    public static float getWidth(EntityPlayer player) {
        return 0.6f;
    }

    public static float getHeight(EntityPlayer player) {
        return 1.8f + TFHelper.getCameraYOffset(player);
    }

    public static float getScale(EntityPlayer player) {
        return 1.0f;
    }

    public static float getCameraYOffset(EntityPlayer player) {
        Transformer transformer = TFHelper.getTransformer((EntityLivingBase)player);
        if (transformer != null) {
            int altMode = TFData.ALT_MODE.get(player);
            return TFHelper.median(transformer.getVehicleHeightOffset(player, altMode), transformer.getHeightOffset(player, altMode), TFHelper.getTransformationTimer(player));
        }
        return 0.0f;
    }

    public static boolean shouldOverrideScale(EntityPlayer player) {
        if (TFHelper.getTransformer((EntityLivingBase)player) == null && TFData.PREV_TRANSFORMER.get(player) != null) {
            return true;
        }
        return !player.func_70089_S() || (TFHelper.getTransformer((EntityLivingBase)player) != null || TFData.PREV_TRANSFORMER.get(player) != null) && (TFHelper.getHeight(player) != player.field_70131_O || TFHelper.getWidth(player) != player.field_70130_N);
    }

    public static int blend(int a, int b, float ratio) {
        if (ratio > 1.0f) {
            ratio = 1.0f;
        } else if (ratio < 0.0f) {
            ratio = 0.0f;
        }
        float iRatio = 1.0f - ratio;
        int aA = a >> 24 & 0xFF;
        int aR = (a & 0xFF0000) >> 16;
        int aG = (a & 0xFF00) >> 8;
        int aB = a & 0xFF;
        int bA = b >> 24 & 0xFF;
        int bR = (b & 0xFF0000) >> 16;
        int bG = (b & 0xFF00) >> 8;
        int bB = b & 0xFF;
        int A = (int)((float)aA * iRatio + (float)bA * ratio);
        int R = (int)((float)aR * iRatio + (float)bR * ratio);
        int G = (int)((float)aG * iRatio + (float)bG * ratio);
        int B = (int)((float)aB * iRatio + (float)bB * ratio);
        return A << 24 | R << 16 | G << 8 | B;
    }
}

