/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.helper;

import fiskfille.tf.common.fluid.FluidTankTF;
import fiskfille.tf.helper.RenderInfo;
import fiskfille.tf.helper.TFRenderHelper;
import java.util.HashMap;
import java.util.Map;
import javax.vecmath.Vector4d;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public final class TFFluidRenderHelper {
    private static Minecraft mc = Minecraft.func_71410_x();
    public static final int DISPLAY_STAGES = 100;
    private static Map<Fluid, int[]> flowingRenderCache = new HashMap<Fluid, int[]>();
    private static Map<Fluid, int[]> stillRenderCache = new HashMap<Fluid, int[]>();
    private static final RenderInfo liquidBlock = new RenderInfo();

    public static void onTextureStitch(TextureMap map) {
        for (int[] aint : flowingRenderCache.values()) {
            for (int i : aint) {
                GL11.glDeleteLists((int)i, (int)1);
            }
        }
        flowingRenderCache.clear();
        for (int[] aint : stillRenderCache.values()) {
            for (int i : aint) {
                GL11.glDeleteLists((int)i, (int)1);
            }
        }
        stillRenderCache.clear();
    }

    public static IIcon getFluidTexture(FluidStack fluidStack, boolean flowing) {
        if (fluidStack == null) {
            return null;
        }
        return TFFluidRenderHelper.getFluidTexture(fluidStack.getFluid(), flowing);
    }

    public static IIcon getFluidTexture(Fluid fluid, boolean flowing) {
        IIcon icon;
        if (fluid == null) {
            return null;
        }
        IIcon iIcon = icon = flowing ? fluid.getFlowingIcon() : fluid.getStillIcon();
        if (icon == null) {
            icon = ((TextureMap)mc.func_110434_K().func_110581_b(TextureMap.field_110575_b)).func_110572_b("missingno");
        }
        return icon;
    }

    public static void setColorForFluidStack(FluidStack fluidstack) {
        if (fluidstack == null) {
            return;
        }
        int color = fluidstack.getFluid().getColor(fluidstack);
        float[] afloat = TFRenderHelper.hexToRGB(color);
        GL11.glColor4f((float)afloat[0], (float)afloat[1], (float)afloat[2], (float)1.0f);
    }

    public static int[] getFluidDisplayLists(RenderBlocks renderBlocks, FluidStack fluidStack, World world, boolean flowing) {
        if (fluidStack == null) {
            return null;
        }
        Fluid fluid = fluidStack.getFluid();
        if (fluid == null) {
            return null;
        }
        Map<Fluid, int[]> cache = flowing ? flowingRenderCache : stillRenderCache;
        int[] diplayLists = cache.get(fluid);
        if (diplayLists != null) {
            return diplayLists;
        }
        diplayLists = new int[100];
        if (fluid.getBlock() != null) {
            TFFluidRenderHelper.liquidBlock.baseBlock = fluid.getBlock();
            TFFluidRenderHelper.liquidBlock.texture = TFFluidRenderHelper.getFluidTexture(fluidStack, flowing);
        } else {
            TFFluidRenderHelper.liquidBlock.baseBlock = Blocks.field_150355_j;
            TFFluidRenderHelper.liquidBlock.texture = TFFluidRenderHelper.getFluidTexture(fluidStack, flowing);
        }
        cache.put(fluid, diplayLists);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2884);
        for (int stage = 0; stage < 100; ++stage) {
            diplayLists[stage] = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)diplayLists[stage], (int)4864);
            TFFluidRenderHelper.liquidBlock.minX = 0.0;
            TFFluidRenderHelper.liquidBlock.minY = 0.0;
            TFFluidRenderHelper.liquidBlock.minZ = 0.0;
            TFFluidRenderHelper.liquidBlock.maxX = 1.0;
            TFFluidRenderHelper.liquidBlock.maxY = (float)stage / 99.0f;
            TFFluidRenderHelper.liquidBlock.maxZ = 1.0;
            liquidBlock.renderBlock(renderBlocks);
            GL11.glEndList();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glEnable((int)2896);
        return diplayLists;
    }

    public static void renderIntoGUI(FluidTankTF tank, int x, int y, int width, int height, float zLevel) {
        FluidStack stack = tank.getFluid();
        if (stack != null && stack.amount > 0) {
            Tessellator tessellator = Tessellator.field_78398_a;
            IIcon icon = stack.getFluid().getStillIcon();
            float f = (float)stack.amount / (float)tank.getCapacity();
            Vector4d pos = new Vector4d((double)x, (double)y, (double)width, (double)height);
            Vector4d tex = new Vector4d((double)icon.func_94209_e(), (double)icon.func_94207_b((double)(16.0f * (1.0f - f))), (double)icon.func_94214_a((double)(16.0f * (float)width / (float)height)), (double)icon.func_94210_h());
            pos.y += pos.w * (double)(1.0f - f);
            pos.w *= (double)f;
            pos.z += pos.x;
            pos.w += pos.y;
            mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
            TFFluidRenderHelper.setColorForFluidStack(stack);
            tessellator.func_78382_b();
            tessellator.func_78373_b(0.0, 0.0, (double)zLevel);
            tessellator.func_78374_a(pos.x, pos.w, 0.0, tex.x, tex.w);
            tessellator.func_78374_a(pos.z, pos.w, 0.0, tex.z, tex.w);
            tessellator.func_78374_a(pos.z, pos.y, 0.0, tex.z, tex.y);
            tessellator.func_78374_a(pos.x, pos.y, 0.0, tex.x, tex.y);
            tessellator.func_78373_b(0.0, 0.0, 0.0);
            GL11.glEnable((int)3042);
            tessellator.func_78381_a();
            GL11.glDisable((int)3042);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

