/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.helper;

import com.google.common.collect.Lists;
import fiskfille.tf.common.energon.power.EnergyStorage;
import fiskfille.tf.common.energon.power.IEnergyContainer;
import fiskfille.tf.common.energon.power.IEnergyReceiver;
import fiskfille.tf.common.energon.power.IEnergyTransmitter;
import fiskfille.tf.common.energon.power.NetworkEntry;
import fiskfille.tf.common.energon.power.ReceiverEntry;
import fiskfille.tf.common.energon.power.ReceiverHandler;
import fiskfille.tf.common.energon.power.TransmissionHandler;
import fiskfille.tf.common.item.ItemCSD;
import fiskfille.tf.common.tileentity.TileEntityMachine;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class TFEnergyHelper {
    public static boolean isInRange(TileEntity transmitterTile, TileEntity receiverTile) {
        Vec3 dst;
        IEnergyTransmitter transmitter = (IEnergyTransmitter)transmitterTile;
        IEnergyReceiver receiver = (IEnergyReceiver)receiverTile;
        Vec3 src = transmitter.getEnergyOutputOffset().func_72441_c((double)((float)transmitterTile.field_145851_c + 0.5f), (double)((float)transmitterTile.field_145848_d + 0.5f), (double)((float)transmitterTile.field_145849_e + 0.5f));
        return src.func_72438_d(dst = receiver.getEnergyInputOffset().func_72441_c((double)((float)receiverTile.field_145851_c + 0.5f), (double)((float)receiverTile.field_145848_d + 0.5f), (double)((float)receiverTile.field_145849_e + 0.5f))) <= (double)transmitter.getRange();
    }

    public static boolean isInRange(TileEntity transmitterTile, ChunkCoordinates dstCoords) {
        Vec3 dst;
        IEnergyTransmitter transmitter = (IEnergyTransmitter)transmitterTile;
        Vec3 src = transmitter.getEnergyOutputOffset().func_72441_c((double)((float)transmitterTile.field_145851_c + 0.5f), (double)((float)transmitterTile.field_145848_d + 0.5f), (double)((float)transmitterTile.field_145849_e + 0.5f));
        return src.func_72438_d(dst = Vec3.func_72443_a((double)((float)dstCoords.field_71574_a + 0.5f), (double)((float)dstCoords.field_71572_b + 0.5f), (double)((float)dstCoords.field_71573_c + 0.5f))) <= (double)transmitter.getRange();
    }

    public static TransmissionHandler getTransmissionHandler(TileEntity tile) {
        if (tile instanceof IEnergyTransmitter) {
            return ((IEnergyTransmitter)tile).getTransmissionHandler();
        }
        return null;
    }

    public static ReceiverHandler getReceiverHandler(TileEntity tile) {
        if (tile instanceof IEnergyReceiver) {
            return ((IEnergyReceiver)tile).getReceiverHandler();
        }
        return null;
    }

    public static List<ItemCSD.DimensionalCoords> getDescendants(IEnergyTransmitter transmitter) {
        return TFEnergyHelper.getDescendants(transmitter, new ArrayList<ItemCSD.DimensionalCoords>());
    }

    private static List<ItemCSD.DimensionalCoords> getDescendants(IEnergyTransmitter transmitter, List<ItemCSD.DimensionalCoords> list) {
        TransmissionHandler handler = transmitter.getTransmissionHandler();
        for (ReceiverEntry entry : handler.getReceivers()) {
            list.add(entry.getCoords());
            if (!(entry.getTile() instanceof IEnergyTransmitter)) continue;
            TFEnergyHelper.getDescendants(entry.getTransmitter(), list);
        }
        return list;
    }

    public static MovingObjectPosition rayTraceBlocks(World world, Vec3 src, Vec3 dst) {
        return TFEnergyHelper.rayTraceBlocks(world, src, dst, false, false, false);
    }

    public static MovingObjectPosition rayTraceBlocks(World world, Vec3 src, Vec3 dst, boolean flag) {
        return TFEnergyHelper.rayTraceBlocks(world, src, dst, flag, false, false);
    }

    public static MovingObjectPosition rayTraceBlocks(World world, Vec3 src, Vec3 dst, boolean flag, boolean flag1, boolean flag2) {
        if (!(Double.isNaN(src.field_72450_a) || Double.isNaN(src.field_72448_b) || Double.isNaN(src.field_72449_c))) {
            if (!(Double.isNaN(dst.field_72450_a) || Double.isNaN(dst.field_72448_b) || Double.isNaN(dst.field_72449_c))) {
                MovingObjectPosition mop;
                int x = MathHelper.func_76128_c((double)dst.field_72450_a);
                int y = MathHelper.func_76128_c((double)dst.field_72448_b);
                int z = MathHelper.func_76128_c((double)dst.field_72449_c);
                int x1 = MathHelper.func_76128_c((double)src.field_72450_a);
                int y1 = MathHelper.func_76128_c((double)src.field_72448_b);
                int z1 = MathHelper.func_76128_c((double)src.field_72449_c);
                Block block = world.func_147439_a(x1, y1, z1);
                int metadata = world.func_72805_g(x1, y1, z1);
                if (!(flag1 && block.func_149668_a(world, x1, y1, z1) == null || !block.func_149678_a(metadata, flag) || !block.func_149662_c() && world.func_147438_o(x1, y1, z1) instanceof IEnergyReceiver || (mop = block.func_149731_a(world, x1, y1, z1, src, dst)) == null)) {
                    return mop;
                }
                MovingObjectPosition movingobjectposition2 = null;
                metadata = 200;
                while (metadata-- >= 0) {
                    int b0;
                    if (Double.isNaN(src.field_72450_a) || Double.isNaN(src.field_72448_b) || Double.isNaN(src.field_72449_c)) {
                        return null;
                    }
                    if (x1 == x && y1 == y && z1 == z) {
                        return flag2 ? movingobjectposition2 : null;
                    }
                    boolean flag6 = true;
                    boolean flag3 = true;
                    boolean flag4 = true;
                    double d0 = 999.0;
                    double d1 = 999.0;
                    double d2 = 999.0;
                    if (x > x1) {
                        d0 = (double)x1 + 1.0;
                    } else if (x < x1) {
                        d0 = (double)x1 + 0.0;
                    } else {
                        flag6 = false;
                    }
                    if (y > y1) {
                        d1 = (double)y1 + 1.0;
                    } else if (y < y1) {
                        d1 = (double)y1 + 0.0;
                    } else {
                        flag3 = false;
                    }
                    if (z > z1) {
                        d2 = (double)z1 + 1.0;
                    } else if (z < z1) {
                        d2 = (double)z1 + 0.0;
                    } else {
                        flag4 = false;
                    }
                    double d3 = 999.0;
                    double d4 = 999.0;
                    double d5 = 999.0;
                    double d6 = dst.field_72450_a - src.field_72450_a;
                    double d7 = dst.field_72448_b - src.field_72448_b;
                    double d8 = dst.field_72449_c - src.field_72449_c;
                    if (flag6) {
                        d3 = (d0 - src.field_72450_a) / d6;
                    }
                    if (flag3) {
                        d4 = (d1 - src.field_72448_b) / d7;
                    }
                    if (flag4) {
                        d5 = (d2 - src.field_72449_c) / d8;
                    }
                    if (d3 < d4 && d3 < d5) {
                        b0 = x > x1 ? 4 : 5;
                        src.field_72450_a = d0;
                        src.field_72448_b += d7 * d3;
                        src.field_72449_c += d8 * d3;
                    } else if (d4 < d5) {
                        b0 = y > y1 ? 0 : 1;
                        src.field_72450_a += d6 * d4;
                        src.field_72448_b = d1;
                        src.field_72449_c += d8 * d4;
                    } else {
                        b0 = z > z1 ? 2 : 3;
                        src.field_72450_a += d6 * d5;
                        src.field_72448_b += d7 * d5;
                        src.field_72449_c = d2;
                    }
                    Vec3 vec32 = Vec3.func_72443_a((double)src.field_72450_a, (double)src.field_72448_b, (double)src.field_72449_c);
                    vec32.field_72450_a = MathHelper.func_76128_c((double)src.field_72450_a);
                    x1 = (int)vec32.field_72450_a;
                    if (b0 == 5) {
                        --x1;
                        vec32.field_72450_a += 1.0;
                    }
                    vec32.field_72448_b = MathHelper.func_76128_c((double)src.field_72448_b);
                    y1 = (int)vec32.field_72448_b;
                    if (b0 == 1) {
                        --y1;
                        vec32.field_72448_b += 1.0;
                    }
                    vec32.field_72449_c = MathHelper.func_76128_c((double)src.field_72449_c);
                    z1 = (int)vec32.field_72449_c;
                    if (b0 == 3) {
                        --z1;
                        vec32.field_72449_c += 1.0;
                    }
                    Block block1 = world.func_147439_a(x1, y1, z1);
                    int l1 = world.func_72805_g(x1, y1, z1);
                    if (flag1 && block1.func_149668_a(world, x1, y1, z1) == null) continue;
                    if (!(!block1.func_149678_a(l1, flag) || world.func_147438_o(x1, y1, z1) instanceof IEnergyReceiver && world.func_147438_o(x1, y1, z1) instanceof IEnergyTransmitter)) {
                        MovingObjectPosition movingobjectposition1 = block1.func_149731_a(world, x1, y1, z1, src, dst);
                        if (movingobjectposition1 == null) continue;
                        return movingobjectposition1;
                    }
                    movingobjectposition2 = new MovingObjectPosition(x1, y1, z1, b0, src, false);
                }
                return flag2 ? movingobjectposition2 : null;
            }
            return null;
        }
        return null;
    }

    public static List<ReceiverEntry> getReceiversToPower(IEnergyTransmitter transmitter) {
        TransmissionHandler transmissionHandler = transmitter.getTransmissionHandler();
        ArrayList tilesToPower = Lists.newArrayList();
        for (ReceiverEntry receiver : transmissionHandler.getReceivers()) {
            if (!receiver.canReach() || receiver.getTile() == null) continue;
            tilesToPower.add(receiver);
        }
        return tilesToPower;
    }

    public static List<ReceiverEntry> getReceiverChain(IEnergyTransmitter transmitter) {
        List<ReceiverEntry> tilesToPower = TFEnergyHelper.getReceiversToPower(transmitter);
        ArrayList list = Lists.newArrayList(tilesToPower);
        for (ReceiverEntry receiver : tilesToPower) {
            if (!(receiver.getTile() instanceof IEnergyTransmitter)) continue;
            list.addAll(TFEnergyHelper.getReceiverChain(receiver.getTransmitter()));
        }
        return list;
    }

    public static List<ReceiverEntry> getReceiverDescendants(IEnergyTransmitter transmitter) {
        List<ReceiverEntry> tiles = TFEnergyHelper.getReceiverChain(transmitter);
        ArrayList list = Lists.newArrayList();
        for (ReceiverEntry receiver : tiles) {
            if (list.contains(receiver) || receiver.getTile() instanceof IEnergyTransmitter && !TFEnergyHelper.getReceiversToPower(receiver.getTransmitter()).isEmpty()) continue;
            list.add(receiver);
        }
        return list;
    }

    public static boolean isPowering(IEnergyTransmitter transmitter, ReceiverEntry entry) {
        return TFEnergyHelper.getReceiversToPower(transmitter).contains(entry);
    }

    public static boolean isPowering(IEnergyTransmitter transmitter, ItemCSD.DimensionalCoords coords) {
        List<ReceiverEntry> receivers = TFEnergyHelper.getReceiversToPower(transmitter);
        for (ReceiverEntry receiver : receivers) {
            if (!receiver.getCoords().equals((Object)coords)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPowering(IEnergyTransmitter transmitter, TileEntity tile) {
        return TFEnergyHelper.isPowering(transmitter, new ItemCSD.DimensionalCoords(tile));
    }

    public static float transferEnergy(IEnergyContainer to, IEnergyContainer from, float amount, boolean simulate) {
        return to.receiveEnergy(from.extractEnergy(to.receiveEnergy(amount, true), simulate), simulate);
    }

    public static void applyEnergyUsage(EnergyStorage storage) {
        float usage = storage.getUsage();
        if (usage < 0.0f) {
            storage.remove(-usage, false);
        } else if (usage > 0.0f) {
            storage.add(usage, false);
        }
    }

    public static boolean canPowerChainReach(IEnergyReceiver receiver) {
        TileEntity tile = receiver.getReceiverHandler().getOwner().getTile();
        if (tile != null) {
            Set<NetworkEntry> transmitters = receiver.getReceiverHandler().getTransmitters();
            for (NetworkEntry ownerEntry : transmitters) {
                TileEntityMachine machine;
                if (ownerEntry.getTile() instanceof IEnergyReceiver) {
                    if (!TFEnergyHelper.isPowering(ownerEntry.getTransmitter(), tile) || !TFEnergyHelper.canPowerChainReach(ownerEntry.getReceiver())) continue;
                    return true;
                }
                if (!(ownerEntry.getTransmitter().getEnergy() > 0.0f) || !TFEnergyHelper.isPowering(ownerEntry.getTransmitter(), tile) || ownerEntry.getTile() instanceof TileEntityMachine && !(machine = (TileEntityMachine)ownerEntry.getTile()).canActivate()) continue;
                return true;
            }
        }
        return false;
    }
}

