/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.helper;

import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class RenderInfo {
    public double minX = 0.0;
    public double minY = 0.0;
    public double minZ = 0.0;
    public double maxX = 1.0;
    public double maxY = 1.0;
    public double maxZ = 1.0;
    public Block baseBlock = Blocks.field_150354_m;
    public IIcon texture = null;
    public IIcon[] textureArray = null;
    public boolean[] renderSide = new boolean[]{true, true, true, true, true, true};
    public int light = -1;
    public int brightness = -1;

    public RenderInfo() {
    }

    public RenderInfo(Block template, IIcon[] texture) {
        this();
        this.baseBlock = template;
        this.textureArray = texture;
    }

    public RenderInfo(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        this();
        this.setBounds(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public void setSkyBlockLight(World world, int x, int y, int z, int light) {
        this.brightness = world.func_72925_a(EnumSkyBlock.Sky, x, y, z) << 16 | light;
    }

    public float getBlockBrightness(IBlockAccess iblockaccess, int i, int j, int k) {
        return this.baseBlock.func_149677_c(iblockaccess, i, j, k);
    }

    public final void setBounds(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
    }

    public final void setRenderSingleSide(int side) {
        Arrays.fill(this.renderSide, false);
        this.renderSide[side] = true;
    }

    public final void setRenderAllSides() {
        Arrays.fill(this.renderSide, true);
    }

    public void rotate() {
        double temp = this.minX;
        this.minX = this.minZ;
        this.minZ = temp;
        temp = this.maxX;
        this.maxX = this.maxZ;
        this.maxZ = temp;
    }

    public void reverseX() {
        double temp = this.minX;
        this.minX = 1.0 - this.maxX;
        this.maxX = 1.0 - temp;
    }

    public void reverseZ() {
        double temp = this.minZ;
        this.minZ = 1.0 - this.maxZ;
        this.maxZ = 1.0 - temp;
    }

    public IIcon getBlockTextureFromSide(int i) {
        if (this.texture != null) {
            return this.texture;
        }
        int index = i;
        if (this.textureArray == null || this.textureArray.length == 0) {
            return this.baseBlock.func_149733_h(index);
        }
        if (index >= this.textureArray.length) {
            index = 0;
        }
        return this.textureArray[index];
    }

    public void renderBlock(RenderBlocks renderBlocks) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        renderBlocks.func_147782_a(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
        if (this.light != -1) {
            tessellator.func_78380_c(this.light << 20 | this.light << 4);
        } else if (this.brightness != -1) {
            tessellator.func_78380_c(this.brightness << 4);
        }
        if (this.renderSide[0]) {
            tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
            renderBlocks.func_147768_a(this.baseBlock, 0.0, 0.0, 0.0, this.getBlockTextureFromSide(0));
        }
        if (this.renderSide[1]) {
            tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
            renderBlocks.func_147806_b(this.baseBlock, 0.0, 0.0, 0.0, this.getBlockTextureFromSide(1));
        }
        if (this.renderSide[2]) {
            tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
            renderBlocks.func_147761_c(this.baseBlock, 0.0, 0.0, 0.0, this.getBlockTextureFromSide(2));
        }
        if (this.renderSide[3]) {
            tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
            renderBlocks.func_147734_d(this.baseBlock, 0.0, 0.0, 0.0, this.getBlockTextureFromSide(3));
        }
        if (this.renderSide[4]) {
            tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
            renderBlocks.func_147798_e(this.baseBlock, 0.0, 0.0, 0.0, this.getBlockTextureFromSide(4));
        }
        if (this.renderSide[5]) {
            tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
            renderBlocks.func_147764_f(this.baseBlock, 0.0, 0.0, 0.0, this.getBlockTextureFromSide(5));
        }
        tessellator.func_78381_a();
    }
}

