/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.common.transformer.base;

import fiskfille.tf.client.tutorial.EnumTutorialType;
import fiskfille.tf.common.entity.EntityMissile;
import fiskfille.tf.common.item.TFItems;
import fiskfille.tf.common.motion.TFMotionManager;
import fiskfille.tf.common.transformer.base.Transformer;
import fiskfille.tf.config.TFConfig;
import fiskfille.tf.helper.TFHelper;
import fiskfille.tf.helper.TFVectorHelper;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.Vec3;

public abstract class TransformerTruck
extends Transformer {
    public TransformerTruck(String name) {
        super(name);
    }

    @Override
    public float fall(EntityPlayer player, float distance, int altMode) {
        return TFHelper.isFullyTransformed(player) ? distance / 4.0f : super.fall(player, distance, altMode);
    }

    @Override
    public boolean hasStealthForce(EntityPlayer player, int altMode) {
        return true;
    }

    @Override
    public boolean canJumpAsVehicle(EntityPlayer player, int altMode) {
        return TFHelper.isInStealthMode(player);
    }

    @Override
    public float getHeightOffset(EntityPlayer player, int altMode) {
        return -1.0f;
    }

    @Override
    public boolean canUseNitro(EntityPlayer player, int altMode) {
        return !TFHelper.isInStealthMode(player);
    }

    @Override
    public void updateMovement(EntityPlayer player, int altMode) {
        TFMotionManager.motion(player, 40.0, 60.0, 20.0, 10.0, false, true, TFHelper.isInStealthMode(player));
    }

    @Override
    public boolean canShoot(EntityPlayer player, int altMode) {
        return TFHelper.isInStealthMode(player);
    }

    @Override
    public Item getShootItem(int altMode) {
        return TFItems.missile;
    }

    @Override
    public Entity getShootEntity(EntityPlayer player, int altMode) {
        EntityMissile entityMissile = new EntityMissile(player.field_70170_p, (EntityLivingBase)player, TFConfig.allowMissileExplosions, TFHelper.isInStealthMode(player));
        return entityMissile;
    }

    @Override
    public int getShots(int altMode) {
        return 8;
    }

    @Override
    public void doNitroParticles(EntityPlayer player, int altMode) {
        Vec3 side;
        int i;
        Random rand = new Random();
        for (i = 0; i < 4; ++i) {
            side = TFVectorHelper.getBackSideCoords(player, 0.15f, i < 2, -0.9, false);
            player.field_70170_p.func_72869_a("smoke", side.field_72450_a, side.field_72448_b, side.field_72449_c, (double)(rand.nextFloat() / 20.0f), (double)(rand.nextFloat() / 20.0f), (double)(rand.nextFloat() / 20.0f));
        }
        for (i = 0; i < 10; ++i) {
            side = TFVectorHelper.getBackSideCoords(player, 0.15f, i < 2, -0.9, false);
            player.field_70170_p.func_72869_a("smoke", side.field_72450_a, side.field_72448_b, side.field_72449_c, (double)(rand.nextFloat() / 10.0f), (double)(rand.nextFloat() / 10.0f + 0.05f), (double)(rand.nextFloat() / 10.0f));
        }
    }

    @Override
    public EnumTutorialType getTutorialType(int altMode) {
        return EnumTutorialType.TRUCK;
    }
}

