/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.common.transformer.base;

import fiskfille.tf.client.model.transformer.definition.TFModelRegistry;
import fiskfille.tf.client.model.transformer.definition.TransformerModel;
import fiskfille.tf.client.tutorial.EnumTutorialType;
import fiskfille.tf.config.TFConfig;
import fiskfille.tf.helper.TFHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;

public abstract class Transformer {
    private String name;

    public abstract Item getHelmet();

    public abstract Item getChestplate();

    public abstract Item getLeggings();

    public abstract Item getBoots();

    public boolean canUseNitro(EntityPlayer player, int altMode) {
        return true;
    }

    public TransformerModel getModel() {
        return TFModelRegistry.getModel(this);
    }

    public Transformer(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void tick(EntityPlayer player, float timer) {
    }

    public boolean canZoom(EntityPlayer player) {
        return false;
    }

    public float getZoomAmount(EntityPlayer player, int altMode) {
        return 0.1f;
    }

    public float getHeightOffset(EntityPlayer player, int altMode) {
        return 0.0f;
    }

    public float getVehicleHeightOffset(EntityPlayer player, int altMode) {
        return -1.25f;
    }

    public boolean canJumpAsVehicle(EntityPlayer player, int altMode) {
        return false;
    }

    public boolean canTransform(EntityPlayer player) {
        return TFConfig.canTransform(this);
    }

    public boolean hasStealthForce(EntityPlayer player, int altMode) {
        return false;
    }

    public abstract void updateMovement(EntityPlayer var1, int var2);

    public Item getShootItem(int altMode) {
        return null;
    }

    public Entity getShootEntity(EntityPlayer playe, int altModer) {
        return null;
    }

    public String getShootSound(int altMode) {
        return null;
    }

    public float getShootVolume(int altMode) {
        return 1.0f;
    }

    public int getShots(int altMode) {
        return 4;
    }

    public boolean canShoot(EntityPlayer player, int altMode) {
        return false;
    }

    public boolean onJump(EntityPlayer player) {
        return true;
    }

    public float getThirdPersonDistance(EntityPlayer player, int altMode) {
        return 4.0f - TFHelper.getTransformationTimer(player) * 2.0f;
    }

    public void doNitroParticles(EntityPlayer player, int altMode) {
    }

    public float fall(EntityPlayer player, float distance, int altMode) {
        return distance;
    }

    public boolean hasRapidFire(int altMode) {
        return false;
    }

    public boolean disableViewBobbing(EntityPlayer player, int altMode) {
        return true;
    }

    public boolean disableStepSounds(EntityPlayer player, int altMode) {
        return true;
    }

    public EnumTutorialType getTutorialType(int altMode) {
        return null;
    }

    public boolean overrideFirstPerson(EntityPlayer player, int altMode) {
        return true;
    }

    public boolean renderSpeedAndNitro(EntityPlayer player, int altMode) {
        return true;
    }

    public boolean canInteractInVehicleMode(EntityPlayer player, int altMode) {
        return true;
    }

    public int getAltModeCount() {
        return 1;
    }

    public String getTransformationSound(int altMode) {
        return "transformers:transform_" + (altMode == -1 ? "robot" : "vehicle");
    }
}

