/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.common.transformer;

import fiskfille.tf.client.keybinds.TFKeyBinds;
import fiskfille.tf.common.achievement.TFAchievements;
import fiskfille.tf.common.block.TFBlocks;
import fiskfille.tf.common.data.TFDataManager;
import fiskfille.tf.common.entity.EntityLaser;
import fiskfille.tf.common.item.ItemVurpsSniper;
import fiskfille.tf.common.item.TFItems;
import fiskfille.tf.common.transformer.base.TransformerCar;
import fiskfille.tf.helper.TFHelper;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;

public class TransformerVurp
extends TransformerCar {
    public TransformerVurp() {
        super("Vurp");
    }

    @Override
    public Item getHelmet() {
        return TFItems.vurpHelmet;
    }

    @Override
    public Item getChestplate() {
        return TFItems.vurpChestplate;
    }

    @Override
    public Item getLeggings() {
        return TFItems.vurpLeggings;
    }

    @Override
    public Item getBoots() {
        return TFItems.vurpBoots;
    }

    @Override
    public float getHeightOffset(EntityPlayer player, int altMode) {
        return -0.3f;
    }

    @Override
    public float getVehicleHeightOffset(EntityPlayer player, int altMode) {
        return -1.4f;
    }

    @Override
    public Item getShootItem(int altMode) {
        return Item.func_150898_a((Block)TFBlocks.energonCube);
    }

    @Override
    public Entity getShootEntity(EntityPlayer player, int altMode) {
        EntityLaser entityLaser = new EntityLaser(player.field_70170_p, (EntityLivingBase)player);
        return entityLaser;
    }

    @Override
    public String getShootSound(int altMode) {
        return "random.fizz";
    }

    @Override
    public float getShootVolume(int altMode) {
        return 0.3f;
    }

    @Override
    public int getShots(int altMode) {
        return 64;
    }

    @Override
    public boolean hasRapidFire(int altMode) {
        return true;
    }

    @Override
    public void tick(EntityPlayer player, float timer) {
        super.tick(player, timer);
        ItemStack heldItem = player.func_70694_bm();
        boolean holdingSniper = heldItem != null && heldItem.func_77973_b() instanceof ItemVurpsSniper;
        int zoomTimer = TFDataManager.getZoomTimer(player);
        PotionEffect activePotionEffect = player.func_70660_b(Potion.field_76439_r);
        if (activePotionEffect == null || activePotionEffect != null && activePotionEffect.func_76459_b() == 0) {
            if (holdingSniper && zoomTimer > 7) {
                player.func_70690_d(new PotionEffect(Potion.field_76439_r.field_76415_H, 1, 0));
            } else {
                player.func_82170_o(Potion.field_76439_r.field_76415_H);
            }
        }
        if (player.field_70170_p.field_72995_K) {
            if (holdingSniper && TFKeyBinds.keyBindingZoom.func_151470_d() && !TFHelper.isFullyTransformed(player)) {
                if (zoomTimer < 10) {
                    TFDataManager.setZoomTimer(player, zoomTimer + 1);
                }
            } else if (zoomTimer > 0) {
                TFDataManager.setZoomTimer(player, zoomTimer - 1);
            }
        }
        player.func_71064_a((StatBase)TFAchievements.vurp, 1);
    }
}

