/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.common.tileentity;

import fiskfille.tf.TransformersAPI;
import fiskfille.tf.TransformersMod;
import fiskfille.tf.common.chunk.ForcedChunk;
import fiskfille.tf.common.chunk.SubTicket;
import fiskfille.tf.common.chunk.TFChunkManager;
import fiskfille.tf.common.data.tile.TileData;
import fiskfille.tf.common.data.tile.TileDataTransmitter;
import fiskfille.tf.common.energon.Energon;
import fiskfille.tf.common.energon.power.IEnergyReceiver;
import fiskfille.tf.common.energon.power.IEnergyTransmitter;
import fiskfille.tf.common.energon.power.ITransmitterRender;
import fiskfille.tf.common.energon.power.ReceiverEntry;
import fiskfille.tf.common.energon.power.TransmissionHandler;
import fiskfille.tf.common.fluid.FluidEnergon;
import fiskfille.tf.common.fluid.FluidTankTF;
import fiskfille.tf.common.fluid.IFluidHandlerTF;
import fiskfille.tf.common.fluid.TFFluids;
import fiskfille.tf.common.item.ItemCSD;
import fiskfille.tf.common.item.ItemFuelCanister;
import fiskfille.tf.common.tileentity.IChunkLoaderTile;
import fiskfille.tf.common.tileentity.IMultiTile;
import fiskfille.tf.common.tileentity.TileEntityMachineContainer;
import fiskfille.tf.helper.TFEnergyHelper;
import fiskfille.tf.helper.TFTileHelper;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidContainerItem;

public class TileEntityTransmitter
extends TileEntityMachineContainer
implements IEnergyTransmitter,
IFluidHandlerTF,
ISidedInventory,
IChunkLoaderTile,
IMultiTile,
ITransmitterRender {
    public TileDataTransmitter data = new TileDataTransmitter(16000.0f, 6000);
    public int animationTimer;
    public ForgeChunkManager.Ticket chunkTicket;

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        ++this.animationTimer;
        if (!this.data.isInitialized()) {
            this.data.initialize(this);
        }
        if (this.func_145832_p() < 4) {
            TileData prevData;
            if (!this.field_145850_b.field_72995_K) {
                int amount;
                int n;
                IFluidContainerItem container;
                FluidStack fluid;
                ForgeChunkManager.Ticket ticket;
                if (this.chunkTicket == null && (ticket = TFChunkManager.getTicketForChunk(ForcedChunk.fromTile(this))) != null) {
                    SubTicket subTicket = SubTicket.fromTile(this);
                    this.forceChunks(subTicket.assign(ticket));
                }
                this.data.serverTickPre();
                if (this.getEnergy() > 0.0f && this.canActivate()) {
                    List<ReceiverEntry> receiversToPower = TFEnergyHelper.getReceiversToPower(this);
                    float f = Math.min(this.getEnergy(), this.getTransmissionRate()) / (float)receiversToPower.size();
                    for (ReceiverEntry entry : receiversToPower) {
                        IEnergyReceiver receiver = entry.getReceiver();
                        if (!receiver.canReceiveEnergy(this)) continue;
                        TFEnergyHelper.transferEnergy(receiver, this, f, false);
                    }
                }
                ItemStack fluidContainer = this.func_70301_a(0);
                FluidStack fluidStack = this.data.tank.getFluid();
                if (fluidStack != null && fluidStack.amount > 0) {
                    Map<String, Float> ratios = FluidEnergon.getRatios(fluidStack);
                    int max = Math.min(10, fluidStack.amount);
                    for (Map.Entry entry : ratios.entrySet()) {
                        Energon energon = TransformersAPI.getEnergonTypeByName((String)entry.getKey());
                        if (energon == null) continue;
                        float factor = energon.getEnergyValue();
                        float receivedEnergy = this.receiveEnergy(((Float)entry.getValue()).floatValue() * factor * (float)max, false);
                        this.drain(ForgeDirection.UNKNOWN, Math.round(receivedEnergy / factor), true);
                    }
                }
                if (fluidContainer != null && fluidContainer.func_77973_b() instanceof IFluidContainerItem && (fluid = (container = (IFluidContainerItem)fluidContainer.func_77973_b()).getFluid(fluidContainer)) != null && fluid.amount > 0 && fluid.getFluid() == TFFluids.energon && (n = this.fill(ForgeDirection.UNKNOWN, container.drain(fluidContainer, amount = Math.min(100, Math.min(ItemFuelCanister.getFluidAmount(fluidContainer), this.data.getCapacity() - this.data.getFluidAmount())), false), true)) > 0) {
                    container.drain(fluidContainer, n, true);
                }
                this.data.serverTick();
            }
            if ((prevData = TFTileHelper.getTileData(new ItemCSD.DimensionalCoords(this))) instanceof TileDataTransmitter) {
                this.data = new TileDataTransmitter((TileDataTransmitter)prevData);
            }
        }
    }

    public int func_70302_i_() {
        return 1;
    }

    public String func_145825_b() {
        return "gui.transmitter";
    }

    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB bounds = AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1)).func_72314_b(0.35, 0.0, 0.35).func_72321_a(0.0, 2.0, 0.0);
        if (this.func_145832_p() < 4) {
            Set<ReceiverEntry> receivers = this.data.transmissionHandler.getReceivers();
            for (ReceiverEntry entry : receivers) {
                TileEntity tile = entry.getTile();
                if (tile == null) continue;
                bounds = bounds.func_111270_a(tile.getRenderBoundingBox());
            }
        }
        return bounds;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt) {
        super.readCustomNBT(nbt);
        if (nbt.func_74767_n("Base") && nbt.func_150297_b("ConfigDataTF", 10)) {
            NBTTagCompound config = nbt.func_74775_l("ConfigDataTF");
            this.data.transmissionHandler.readFromNBT(config);
            this.data.storage.readFromNBT(config);
            this.data.tank.readFromNBT(config);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt) {
        super.writeCustomNBT(nbt);
        boolean base = this.func_145832_p() < 4;
        nbt.func_74757_a("Base", base);
        if (base && (this.data.getEnergy() > 0.0f || this.data.getFluidAmount() > 0 || !this.data.transmissionHandler.getReceivers().isEmpty())) {
            NBTTagCompound config = nbt.func_74775_l("ConfigDataTF");
            this.data.transmissionHandler.writeToNBT(config);
            this.data.storage.writeToNBT(config);
            this.data.tank.writeToNBT(config);
            nbt.func_74782_a("ConfigDataTF", (NBTBase)config);
        }
    }

    @Override
    public TransmissionHandler getTransmissionHandler() {
        return this.data.transmissionHandler;
    }

    @Override
    public float getTransmissionRate() {
        return 350.0f;
    }

    @Override
    public float getRange() {
        return 20.0f;
    }

    @Override
    public Vec3 getEnergyOutputOffset() {
        return Vec3.func_72443_a((double)0.0, (double)2.25, (double)0.0);
    }

    @Override
    public Vec3 getRenderOutputOffset() {
        float f = (float)this.animationTimer + TransformersMod.proxy.getRenderTick();
        return Vec3.func_72443_a((double)0.0, (double)(2.0 + (Math.cos(f / 10.0f) * 2.0 + 2.0) / 16.0), (double)0.0);
    }

    @Override
    public float receiveEnergy(float amount, boolean simulate) {
        return this.data.storage.add(amount, simulate);
    }

    @Override
    public float extractEnergy(float amount, boolean simulate) {
        return this.data.storage.remove(amount, simulate);
    }

    @Override
    public float getEnergy() {
        return this.data.storage.getEnergy();
    }

    @Override
    public float getMaxEnergy() {
        return this.data.storage.getMaxEnergy();
    }

    @Override
    public float getEnergyUsage() {
        return this.data.storage.getUsage();
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        FluidStack stack = this.data.tank.getFluid();
        if (stack == null || stack.amount <= 0 || FluidStack.areFluidStackTagsEqual((FluidStack)stack, (FluidStack)resource)) {
            return this.data.tank.fill(resource, doFill);
        }
        if (stack.getFluid() == TFFluids.energon) {
            NBTTagCompound prevNBT = resource.tag;
            resource.tag = stack.tag;
            int amount = this.data.tank.fill(resource, doFill);
            resource.tag = prevNBT;
            FluidEnergon.merge(stack, resource, amount);
            return amount;
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null || !resource.isFluidEqual(this.data.tank.getFluid())) {
            return null;
        }
        return this.data.tank.drain(resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.data.tank.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.func_145832_p() < 4 && fluid == TFFluids.energon;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.func_145832_p() < 4;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.data.tank.getInfo()};
    }

    public int[] func_94128_d(int side) {
        return new int[]{0};
    }

    public boolean func_102007_a(int slot, ItemStack itemstack, int side) {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return this.func_94041_b(slot, itemstack);
    }

    public boolean func_102008_b(int slot, ItemStack itemstack, int side) {
        return ItemFuelCanister.isEmpty(itemstack);
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return itemstack.func_77973_b() instanceof IFluidContainerItem && !ItemFuelCanister.isEmpty(itemstack) && ItemFuelCanister.getContainerFluid(itemstack).getFluid() == TFFluids.energon;
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K) {
            this.data.kill();
            this.releaseChunks();
        }
    }

    @Override
    public void forceChunks(SubTicket subTicket) {
        this.releaseChunks();
        this.chunkTicket = subTicket.owner;
        TFChunkManager.forceChunk(subTicket.owner, ForcedChunk.fromTile(this));
    }

    public void releaseChunks() {
        if (this.chunkTicket != null) {
            TFChunkManager.releaseChunk(SubTicket.fromTile(this.chunkTicket, this), ForcedChunk.fromTile(this));
            this.chunkTicket = null;
        }
    }

    @Override
    public FluidTankTF getTank() {
        return this.data.tank;
    }

    @Override
    public int[] getBaseOffsets(int metadata) {
        return new int[]{0, -metadata / 4, 0};
    }
}

