/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.common.tileentity;

import com.google.common.collect.Maps;
import fiskfille.tf.common.chunk.ForcedChunk;
import fiskfille.tf.common.chunk.SubTicket;
import fiskfille.tf.common.chunk.TFChunkManager;
import fiskfille.tf.common.data.tile.TileData;
import fiskfille.tf.common.data.tile.TileDataRelay;
import fiskfille.tf.common.energon.power.EnergyStorage;
import fiskfille.tf.common.energon.power.EnergyStorageRelay;
import fiskfille.tf.common.energon.power.IEnergyReceiver;
import fiskfille.tf.common.energon.power.IEnergyTransmitter;
import fiskfille.tf.common.energon.power.ReceiverEntry;
import fiskfille.tf.common.energon.power.ReceiverHandler;
import fiskfille.tf.common.energon.power.TransmissionHandler;
import fiskfille.tf.common.item.ItemCSD;
import fiskfille.tf.common.tileentity.IChunkLoaderTile;
import fiskfille.tf.common.tileentity.IMultiTile;
import fiskfille.tf.common.tileentity.TileEntityTF;
import fiskfille.tf.helper.TFEnergyHelper;
import fiskfille.tf.helper.TFTileHelper;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.ForgeChunkManager;

public class TileEntityRelayTower
extends TileEntityTF
implements IEnergyTransmitter,
IEnergyReceiver,
IChunkLoaderTile,
IMultiTile {
    public ReceiverHandler receiverHandler = new ReceiverHandler(this);
    public TileDataRelay data = new TileDataRelay();
    public EnergyStorage storage = new EnergyStorageRelay(this);
    public Map<ItemCSD.DimensionalCoords, Float> netEnergyTransfer = Maps.newHashMap();
    public float energyTransfer;
    public float energyReceived;
    public float energyExtracted;
    public ForgeChunkManager.Ticket chunkTicket;

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.data.isInitialized()) {
            this.data.initialize(this);
        }
        if (this.isValid(this.func_145832_p())) {
            TileData prevData;
            if (!this.field_145850_b.field_72995_K) {
                Object ticket;
                if (this.chunkTicket == null && (ticket = TFChunkManager.getTicketForChunk(ForcedChunk.fromTile(this))) != null) {
                    SubTicket subTicket = SubTicket.fromTile(this);
                    this.forceChunks(subTicket.assign((ForgeChunkManager.Ticket)ticket));
                }
                this.data.serverTickPre();
                this.data.isPowered = this.energyTransfer > 0.0f || TFEnergyHelper.canPowerChainReach(this);
                this.data.invertCurrent.clear();
                for (Map.Entry entry : this.netEnergyTransfer.entrySet()) {
                    if (!(((Float)entry.getValue()).floatValue() < 0.0f)) continue;
                    this.data.invertCurrent.add((ItemCSD.DimensionalCoords)((Object)entry.getKey()));
                }
                this.data.serverTick();
            }
            if ((prevData = TFTileHelper.getTileData(new ItemCSD.DimensionalCoords(this))) instanceof TileDataRelay) {
                this.data = new TileDataRelay((TileDataRelay)prevData);
            }
        }
        this.energyTransfer = 0.0f;
        this.energyReceived = 0.0f;
        this.energyTransfer = 0.0f;
        this.netEnergyTransfer.clear();
    }

    public float getNetTransfer(ItemCSD.DimensionalCoords coords) {
        return this.netEnergyTransfer.containsKey((Object)coords) ? this.netEnergyTransfer.get((Object)coords).floatValue() : 0.0f;
    }

    public boolean isValid(int metadata) {
        return metadata < 4;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB bounds = AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1)).func_72321_a(0.0, 1.25, 0.0);
        if (this.isValid(this.func_145832_p())) {
            Set<ReceiverEntry> receivers = this.data.transmissionHandler.getReceivers();
            for (ReceiverEntry entry : receivers) {
                TileEntity tile = entry.getTile();
                if (tile == null) continue;
                bounds = bounds.func_111270_a(tile.getRenderBoundingBox());
            }
        }
        return bounds;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt) {
        if (nbt.func_74767_n("Base") && nbt.func_150297_b("ConfigDataTF", 10)) {
            NBTTagCompound config = nbt.func_74775_l("ConfigDataTF");
            this.data.transmissionHandler.readFromNBT(config);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt) {
        boolean base = this.isValid(this.func_145832_p());
        nbt.func_74757_a("Base", base);
        if (base && !this.data.transmissionHandler.getReceivers().isEmpty()) {
            NBTTagCompound config = nbt.func_74775_l("ConfigDataTF");
            this.data.transmissionHandler.writeToNBT(config);
            nbt.func_74782_a("ConfigDataTF", (NBTBase)config);
        }
    }

    @Override
    public ReceiverHandler getReceiverHandler() {
        return this.receiverHandler;
    }

    @Override
    public TransmissionHandler getTransmissionHandler() {
        return this.data.transmissionHandler;
    }

    @Override
    public float getTransmissionRate() {
        return 50.0f;
    }

    @Override
    public float getRange() {
        return 15.0f;
    }

    @Override
    public boolean canReceiveEnergy(TileEntity from) {
        return this.isValid(this.func_145832_p());
    }

    @Override
    public Vec3 getEnergyOutputOffset() {
        return this.getEnergyInputOffset();
    }

    @Override
    public Vec3 getEnergyInputOffset() {
        return Vec3.func_72443_a((double)0.0, (double)1.5, (double)0.0);
    }

    @Override
    public int getMapColor() {
        return 30668;
    }

    @Override
    public float receiveEnergy(float amount, boolean simulate) {
        if ((amount = Math.min(amount, this.getTransmissionRate() - this.energyReceived)) <= 0.0f) {
            return 0.0f;
        }
        float f = this.storage.add(amount, simulate);
        if (!simulate) {
            this.energyTransfer += f;
            this.energyReceived += f;
        }
        return f;
    }

    @Override
    public float extractEnergy(float amount, boolean simulate) {
        if ((amount = Math.min(amount, this.getTransmissionRate() - this.energyExtracted)) <= 0.0f) {
            return 0.0f;
        }
        float f = this.storage.remove(amount, simulate);
        if (!simulate) {
            this.energyTransfer += f;
            this.energyExtracted += f;
        }
        return f;
    }

    @Override
    public float getEnergy() {
        return this.storage.getEnergy();
    }

    @Override
    public float getMaxEnergy() {
        return this.storage.getMaxEnergy();
    }

    @Override
    public float getEnergyUsage() {
        return this.storage.getUsage();
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K) {
            this.data.kill();
            this.releaseChunks();
        }
    }

    @Override
    public void forceChunks(SubTicket subTicket) {
        this.releaseChunks();
        this.chunkTicket = subTicket.owner;
        TFChunkManager.forceChunk(subTicket.owner, ForcedChunk.fromTile(this));
    }

    public void releaseChunks() {
        if (this.chunkTicket != null) {
            TFChunkManager.releaseChunk(SubTicket.fromTile(this.chunkTicket, this), ForcedChunk.fromTile(this));
            this.chunkTicket = null;
        }
    }

    @Override
    public int[] getBaseOffsets(int metadata) {
        return new int[]{0, -metadata / 4, 0};
    }
}

