/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.common.tileentity;

import com.google.common.collect.Lists;
import fiskfille.tf.common.block.BlockMachineBase;
import fiskfille.tf.common.container.ContainerEmpty;
import fiskfille.tf.common.energon.power.IEnergyContainer;
import fiskfille.tf.common.network.MessageTileTrigger;
import fiskfille.tf.common.tileentity.TileEntityTF;
import fiskfille.tf.helper.TFEnergyHelper;
import fiskfille.tf.helper.TFTileHelper;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntityMachine
extends TileEntityTF
implements MessageTileTrigger.ITileDataCallback {
    public final EnumIO[] io;
    public EnumRedstone redstoneMode = EnumRedstone.IGNORE;
    public EnumDistribution distribution = EnumDistribution.QUEUED;

    public TileEntityMachine() {
        this.io = new EnumIO[ForgeDirection.VALID_DIRECTIONS.length];
        for (int i = 0; i < this.io.length; ++i) {
            this.io[i] = EnumIO.NONE;
        }
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K && this instanceof IEnergyContainer && TFTileHelper.getTileBase(this) == this) {
            IEnergyContainer container = (IEnergyContainer)((Object)this);
            ArrayList list = Lists.newArrayList();
            for (int i = 0; i < this.io.length; ++i) {
                TileEntity tile;
                ForgeDirection dir = ForgeDirection.getOrientation((int)i);
                if (this.io[i].ordinal() <= 0 || !(container.getMaxEnergy() > 0.0f) || this.io[i] == EnumIO.PUSH && !(container.getEnergy() > 0.0f) || !this.canTransfer(dir) || !((tile = TFTileHelper.getTileBase(this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY + (dir.offsetY > 0 ? this.getBlockType().getBlockHeight() - 1 : 0), this.field_145849_e + dir.offsetZ))) instanceof IEnergyContainer)) continue;
                list.add(dir);
            }
            for (ForgeDirection dir : list) {
                IEnergyContainer receiver = (IEnergyContainer)TFTileHelper.getTileBase(this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY + (dir.offsetY > 0 ? this.getBlockType().getBlockHeight() - 1 : 0), this.field_145849_e + dir.offsetZ));
                float rate = this.getTransferRate(dir, this.io[dir.ordinal()]);
                if (this.distribution == EnumDistribution.SPREAD) {
                    rate /= (float)list.size();
                }
                switch (this.io[dir.ordinal()]) {
                    case PULL: {
                        TFEnergyHelper.transferEnergy(container, receiver, rate, false);
                        break;
                    }
                    case PUSH: {
                        TFEnergyHelper.transferEnergy(receiver, container, rate, false);
                        break;
                    }
                }
            }
        }
    }

    public BlockMachineBase getBlockType() {
        return (BlockMachineBase)super.func_145838_q();
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt) {
        if (nbt.func_150297_b("ConfigDataTF", 10)) {
            NBTTagCompound config = nbt.func_74775_l("ConfigDataTF");
            NBTTagList nbttaglist = config.func_150295_c("IO", 10);
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
                this.io[nbttagcompound.func_74771_c((String)"side") % this.io.length] = EnumIO.values()[nbttagcompound.func_74771_c("mode") % EnumIO.values().length];
            }
            this.redstoneMode = EnumRedstone.values()[config.func_74771_c("Redstone") % EnumRedstone.values().length];
            this.distribution = EnumDistribution.values()[config.func_74771_c("Distribution") % EnumDistribution.values().length];
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt) {
        if (this.isConfigured()) {
            NBTTagCompound config = nbt.func_74775_l("ConfigDataTF");
            NBTTagList nbttaglist = new NBTTagList();
            for (int i = 0; i < this.io.length; ++i) {
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                nbttagcompound.func_74774_a("side", (byte)i);
                nbttagcompound.func_74774_a("mode", (byte)this.io[i].ordinal());
                nbttaglist.func_74742_a((NBTBase)nbttagcompound);
            }
            config.func_74774_a("Redstone", (byte)this.redstoneMode.ordinal());
            config.func_74774_a("Distribution", (byte)this.distribution.ordinal());
            config.func_74782_a("IO", (NBTBase)nbttaglist);
            nbt.func_74782_a("ConfigDataTF", (NBTBase)config);
        }
    }

    public boolean isConfigured() {
        for (int i = 0; i < this.io.length; ++i) {
            if (this.io[i].ordinal() <= 0) continue;
            return true;
        }
        return this.redstoneMode.ordinal() > 0 || this.distribution.ordinal() > 0;
    }

    public EnumIO getInOutMode(ForgeDirection dir) {
        if (dir.ordinal() < this.io.length) {
            return this.io[dir.ordinal()];
        }
        return EnumIO.NONE;
    }

    public boolean canActivate() {
        boolean isPowered = this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        int y = 0;
        while (++y < this.getBlockType().getBlockHeight() && TFTileHelper.getTileBase(this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + y, this.field_145849_e)) == TFTileHelper.getTileBase(this)) {
            isPowered |= this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d + y, this.field_145849_e);
        }
        switch (this.redstoneMode) {
            case WITH: {
                return isPowered;
            }
            case WITHOUT: {
                return !isPowered;
            }
        }
        return true;
    }

    public float getTransferRate(ForgeDirection dir, EnumIO mode) {
        return 10.0f;
    }

    public boolean canTransfer(ForgeDirection dir) {
        int x = this.field_145851_c + dir.offsetX;
        int y = this.field_145848_d + dir.offsetY + (dir.offsetY > 0 ? this.getBlockType().getBlockHeight() - 1 : 0);
        int z = this.field_145849_e + dir.offsetZ;
        float f = 0.001f;
        Block block = this.field_145850_b.func_147439_a(x, y, z);
        AxisAlignedBB aabb = block.func_149668_a(this.field_145850_b, x, y, z);
        AxisAlignedBB aabb1 = this.getBlockType().func_149668_a(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (aabb == null || aabb1 == null) {
            return false;
        }
        return aabb1.func_72321_a((double)((float)dir.offsetX * f), (double)((float)dir.offsetY * f), (double)((float)dir.offsetZ * f)).func_72326_a(aabb);
    }

    @Override
    public void receive(EntityPlayer player, int action) {
        if (action < 0) {
            if (action >= -this.io.length) {
                int id = -action - 1;
                this.io[id] = EnumIO.values()[(this.io[id].ordinal() + 1) % EnumIO.values().length];
            } else if (action == -this.io.length - 1) {
                player.field_71070_bA = new ContainerEmpty(player.field_71071_by, 16);
            } else if (action == -this.io.length - 2) {
                this.redstoneMode = EnumRedstone.values()[(this.redstoneMode.ordinal() + 1) % EnumRedstone.values().length];
            } else if (action == -this.io.length - 3) {
                this.distribution = EnumDistribution.values()[(this.distribution.ordinal() + 1) % EnumDistribution.values().length];
            }
        }
    }

    public static enum EnumDistribution {
        QUEUED,
        SPREAD;

    }

    public static enum EnumRedstone {
        IGNORE,
        WITH,
        WITHOUT;

    }

    public static enum EnumIO {
        NONE,
        PULL,
        PUSH;

    }
}

