/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.common.tileentity;

import com.google.common.collect.Maps;
import fiskfille.tf.common.data.tile.TileData;
import fiskfille.tf.common.data.tile.TileDataEnergyContainer;
import fiskfille.tf.common.energon.IEnergon;
import fiskfille.tf.common.energon.power.IEnergyContainer;
import fiskfille.tf.common.item.ItemCSD;
import fiskfille.tf.common.tileentity.TileEntityMachine;
import fiskfille.tf.helper.TFTileHelper;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityIsoCondenser
extends TileEntityMachine
implements IEnergyContainer {
    public TileDataEnergyContainer data = new TileDataEnergyContainer(8000.0f);
    public Map<ForgeDirection, Block> providers = Maps.newHashMap();
    public Map<ForgeDirection, Float> animationTimer = Maps.newHashMap();
    public Map<ForgeDirection, Float> prevAnimationTimer = Maps.newHashMap();

    @Override
    public void func_145845_h() {
        TileData prevData;
        super.func_145845_h();
        for (Map.Entry<ForgeDirection, Float> entry : this.animationTimer.entrySet()) {
            this.prevAnimationTimer.put(entry.getKey(), entry.getValue());
        }
        if (!this.data.isInitialized()) {
            this.data.initialize(this);
        }
        this.providers.clear();
        for (ForgeDirection dir : new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.EAST, ForgeDirection.SOUTH, ForgeDirection.WEST}) {
            Block block = this.field_145850_b.func_147439_a(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
            float f = this.animationTimer.get(dir) == null ? 0.0f : this.animationTimer.get(dir).floatValue();
            boolean active = false;
            if (block instanceof IEnergon && ((IEnergon)block).getMass() > 0) {
                this.providers.put(dir, block);
                active = this.canActivate();
            }
            if (active) {
                this.animationTimer.put(dir, Float.valueOf(MathHelper.func_76131_a((float)(f + 0.1f), (float)0.0f, (float)1.0f)));
                continue;
            }
            this.animationTimer.put(dir, Float.valueOf(MathHelper.func_76131_a((float)(f - 0.1f), (float)0.0f, (float)1.0f)));
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.canActivate()) {
                for (Map.Entry entry : this.providers.entrySet()) {
                    IEnergon ienergon = (IEnergon)entry.getValue();
                    this.receiveEnergy(this.getGenerationRate(ienergon.getMass()), false);
                }
            }
            this.data.serverTick();
        }
        if ((prevData = TFTileHelper.getTileData(new ItemCSD.DimensionalCoords(this))) instanceof TileDataEnergyContainer) {
            this.data = new TileDataEnergyContainer((TileDataEnergyContainer)prevData);
        }
    }

    public float getGenerationRate(int mass) {
        if (!this.canActivate()) {
            return 0.0f;
        }
        return (float)mass / 1296.0f * 0.1f;
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K) {
            this.data.kill();
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return super.getRenderBoundingBox().func_72314_b(1.0, 1.0, 1.0);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt) {
        super.readCustomNBT(nbt);
        if (nbt.func_150297_b("ConfigDataTF", 10)) {
            NBTTagCompound config = nbt.func_74775_l("ConfigDataTF");
            this.data.storage.readFromNBT(config);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt) {
        super.writeCustomNBT(nbt);
        if (this.data.storage.getEnergy() > 0.0f) {
            NBTTagCompound config = nbt.func_74775_l("ConfigDataTF");
            this.data.storage.writeToNBT(config);
            nbt.func_74782_a("ConfigDataTF", (NBTBase)config);
        }
    }

    @Override
    public float receiveEnergy(float amount, boolean simulate) {
        return this.data.storage.add(amount, simulate);
    }

    @Override
    public float extractEnergy(float amount, boolean simulate) {
        return this.data.storage.remove(amount, simulate);
    }

    @Override
    public float getEnergy() {
        return this.data.getEnergy();
    }

    @Override
    public float getMaxEnergy() {
        return this.data.getMaxEnergy();
    }

    @Override
    public float getEnergyUsage() {
        return this.data.storage.getUsage();
    }
}

