/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.common.tileentity;

import fiskfille.tf.common.energon.power.IEnergyContainer;
import fiskfille.tf.common.energon.power.IEnergyReceiver;
import fiskfille.tf.common.energon.power.IReceiverRender;
import fiskfille.tf.common.energon.power.ReceiverHandler;
import fiskfille.tf.common.tileentity.TileEntityTF;
import fiskfille.tf.helper.TFTileHelper;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityEnergyPort
extends TileEntityTF
implements IEnergyReceiver,
IReceiverRender {
    public ReceiverHandler receiverHandler = new ReceiverHandler(this);

    public IEnergyContainer getReceiver() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)this.func_145832_p());
        TileEntity tile = TFTileHelper.getTileBase(this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ));
        if (tile instanceof IEnergyContainer && !(tile instanceof TileEntityEnergyPort)) {
            return (IEnergyContainer)tile;
        }
        return null;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1));
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt) {
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt) {
    }

    @Override
    public ReceiverHandler getReceiverHandler() {
        return this.receiverHandler;
    }

    @Override
    public boolean canReceiveEnergy(TileEntity from) {
        return true;
    }

    @Override
    public Vec3 getEnergyInputOffset() {
        return this.getInputVec(3.5f);
    }

    @Override
    public Vec3 getRenderInputOffset() {
        return this.getInputVec(1.5f);
    }

    public Vec3 getInputVec(float height) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)this.func_145832_p());
        float f = 0.0625f * height;
        if (dir == ForgeDirection.UP) {
            return Vec3.func_72443_a((double)0.0, (double)(0.5f - f), (double)0.0);
        }
        if (dir == ForgeDirection.DOWN) {
            return Vec3.func_72443_a((double)0.0, (double)(-0.5f + f), (double)0.0);
        }
        int[] rotations = new int[]{2, 0, 1, 3};
        float yaw = rotations[dir.ordinal() - 2] * 90;
        Vec3 vec3 = Vec3.func_72443_a((double)0.0, (double)0.0, (double)(0.5f - f));
        vec3.func_72442_b(-yaw * (float)Math.PI / 180.0f);
        return vec3;
    }

    @Override
    public int getMapColor() {
        return 1201274;
    }

    @Override
    public float receiveEnergy(float amount, boolean simulate) {
        IEnergyContainer container = this.getReceiver();
        if (container != null) {
            return container.receiveEnergy(amount, simulate);
        }
        return 0.0f;
    }

    @Override
    public float extractEnergy(float amount, boolean simulate) {
        IEnergyContainer container = this.getReceiver();
        if (container != null) {
            return container.extractEnergy(amount, simulate);
        }
        return 0.0f;
    }

    @Override
    public float getEnergy() {
        IEnergyContainer container = this.getReceiver();
        if (container != null) {
            return container.getEnergy();
        }
        return 0.0f;
    }

    @Override
    public float getMaxEnergy() {
        IEnergyContainer container = this.getReceiver();
        if (container != null) {
            return container.getMaxEnergy();
        }
        return 0.0f;
    }

    @Override
    public float getEnergyUsage() {
        IEnergyContainer container = this.getReceiver();
        if (container != null) {
            return container.getEnergyUsage();
        }
        return 0.0f;
    }
}

