/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.common.tileentity;

import com.google.common.collect.Lists;
import fiskfille.tf.common.data.tile.TileData;
import fiskfille.tf.common.data.tile.TileDataEnergonTank;
import fiskfille.tf.common.fluid.FluidEnergon;
import fiskfille.tf.common.fluid.FluidTankTF;
import fiskfille.tf.common.fluid.IFluidHandlerTF;
import fiskfille.tf.common.fluid.TFFluids;
import fiskfille.tf.common.item.ItemCSD;
import fiskfille.tf.common.item.ItemFuelCanister;
import fiskfille.tf.common.tileentity.IMultiTile;
import fiskfille.tf.common.tileentity.TileEntityMachineContainer;
import fiskfille.tf.helper.TFTileHelper;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityEnergonTank
extends TileEntityMachineContainer
implements IFluidHandlerTF,
ISidedInventory,
IMultiTile {
    private static final int[] slotsSides = new int[]{0, 1};
    public TileDataEnergonTank data = new TileDataEnergonTank(16000);
    public int fillTime;
    public int lastFluidUsage;

    @Override
    public void func_145845_h() {
        TileData prevData;
        ItemStack input = this.func_70301_a(0);
        ItemStack output = this.func_70301_a(1);
        if (!this.data.isInitialized()) {
            this.data.initialize(this);
        }
        if (this.data.getFluidAmount() > 0 && output != null && output.func_77973_b() instanceof IFluidContainerItem && (ItemFuelCanister.isEmpty(output) || ItemFuelCanister.getContainerFluid(output).getFluid() == TFFluids.energon && !ItemFuelCanister.isFull(output))) {
            if (this.fillTime < 100) {
                ++this.fillTime;
            } else {
                if (!this.field_145850_b.field_72995_K) {
                    this.fillCanister(output);
                }
                this.fillTime = 0;
            }
        } else if (this.fillTime > 0) {
            --this.fillTime;
        }
        if (this.data.getFluid() != null && this.data.getFluidAmount() == 0) {
            this.data.setFluid(null);
        }
        if (!this.field_145850_b.field_72995_K) {
            int success;
            IFluidContainerItem container;
            FluidStack fluid;
            TileEntityEnergonTank tileBase;
            if (this.data.getFluidAmount() > 0) {
                tileBase = TFTileHelper.getTileBase(this);
                if (tileBase != this) {
                    int amount;
                    FluidStack fluid2;
                    TileEntityEnergonTank tile1;
                    if (TFTileHelper.getTileBase(this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e)) == tileBase && (tile1 = (TileEntityEnergonTank)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e)).getTank().getFluidAmount() < tile1.getTank().getCapacity() && (fluid2 = this.data.tank.drain(this.data.getFluidAmount(), false)) != null && fluid2.amount > 0 && tile1.canFill(ForgeDirection.UP, fluid2.getFluid()) && (amount = tile1.fill(ForgeDirection.UP, fluid2, true)) > 0) {
                        this.data.tank.drain(amount, true);
                    }
                } else {
                    ForgeDirection dir = ForgeDirection.getOrientation((int)this.func_145832_p());
                    TileEntity tile = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
                    int maxTransfer = 100;
                    if (this.canActivate() && maxTransfer > 0 && tile instanceof IFluidHandler) {
                        int amount;
                        IFluidHandler fluidHandler = (IFluidHandler)tile;
                        FluidStack fluid3 = this.drain(dir, maxTransfer, false);
                        if (fluid3 != null && fluid3.amount > 0 && fluidHandler.canFill(dir.getOpposite(), fluid3.getFluid()) && (amount = fluidHandler.fill(dir.getOpposite(), fluid3, true)) > 0) {
                            this.drain(dir, amount, true);
                        }
                    }
                }
            }
            if (input != null && input.func_77973_b() instanceof IFluidContainerItem && (fluid = (container = (IFluidContainerItem)input.func_77973_b()).getFluid(input)) != null && fluid.amount > 0 && fluid.getFluid() == TFFluids.energon && (success = TFTileHelper.getTileBase(this).fill(ForgeDirection.UNKNOWN, container.drain(input, ItemFuelCanister.getFluidAmount(input), false), true)) > 0) {
                container.drain(input, success, true);
            }
            if ((tileBase = TFTileHelper.getTileBase(this)) == this) {
                FluidStack mix = new FluidStack(TFFluids.energon, 0);
                float f = 0.0f;
                Map<String, Float> ratios = FluidEnergon.getRatios(mix);
                ArrayList tiles = Lists.newArrayList();
                for (int y = tileBase.field_145848_d; y < this.field_145850_b.func_72800_K() && TFTileHelper.getTileBase(this.field_145850_b.func_147438_o(this.field_145851_c, y, this.field_145849_e)) == tileBase; ++y) {
                    TileEntityEnergonTank tile = (TileEntityEnergonTank)this.field_145850_b.func_147438_o(this.field_145851_c, y, this.field_145849_e);
                    tiles.add(tile);
                    if (tile.getTank().getFluid() == null) continue;
                    Map<String, Float> ratios1 = FluidEnergon.getRatios(tile.getTank().getFluid());
                    for (Map.Entry<String, Float> e : ratios1.entrySet()) {
                        ratios.put(e.getKey(), Float.valueOf(ratios.get(e.getKey()).floatValue() + e.getValue().floatValue() * (float)tile.getTank().getFluidAmount()));
                    }
                    f += (float)tile.getTank().getFluidAmount();
                }
                if (this.data.getFluid() != null) {
                    for (Map.Entry<String, Float> e : ratios.entrySet()) {
                        ratios.put(e.getKey(), Float.valueOf(ratios.get(e.getKey()).floatValue() / f));
                    }
                    for (int i = 0; i < tiles.size(); ++i) {
                        TileEntityEnergonTank tile = (TileEntityEnergonTank)tiles.get(i);
                        FluidStack fluid4 = tile.getTank().getFluid();
                        if (fluid4 == null) continue;
                        FluidEnergon.setRatios(fluid4, ratios);
                    }
                }
            }
            this.data.serverTick();
        }
        if ((prevData = TFTileHelper.getTileData(new ItemCSD.DimensionalCoords(this))) instanceof TileDataEnergonTank) {
            this.data = new TileDataEnergonTank((TileDataEnergonTank)prevData);
        }
    }

    public void fillCanister(ItemStack fluidContainer) {
        if (fluidContainer.func_77973_b() instanceof IFluidContainerItem) {
            IFluidContainerItem item = (IFluidContainerItem)fluidContainer.func_77973_b();
            int amount = Math.min(this.data.getFluidAmount(), item.getCapacity(fluidContainer) - ItemFuelCanister.getFluidAmount(fluidContainer));
            FluidStack stack = item.getFluid(fluidContainer);
            if (stack == null) {
                stack = new FluidStack(TFFluids.energon, 0);
            }
            FluidStack stack1 = new FluidStack(TFFluids.energon, amount);
            FluidEnergon.setRatios(stack1, FluidEnergon.getRatios(this.data.getFluid()));
            NBTTagCompound prevNBT = stack1.tag;
            stack1.tag = stack.tag;
            int i = item.fill(fluidContainer, stack1, true);
            this.drain(ForgeDirection.UNKNOWN, amount, true);
            stack.amount += i;
            stack1.tag = prevNBT;
            FluidEnergon.merge(stack, stack1, amount);
            if (!fluidContainer.func_77942_o()) {
                fluidContainer.func_77982_d(new NBTTagCompound());
            }
            fluidContainer.func_77978_p().func_74782_a("Fluid", (NBTBase)stack.writeToNBT(new NBTTagCompound()));
        }
        this.markBlockForUpdate();
        this.notifyNeighborBlocksOfChange();
    }

    public void notifyNeighborBlocksOfChange() {
        this.field_145850_b.func_147439_a(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e).func_149695_a(this.field_145850_b, this.field_145851_c + 1, this.field_145848_d, this.field_145849_e, this.field_145854_h);
        this.field_145850_b.func_147439_a(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e).func_149695_a(this.field_145850_b, this.field_145851_c - 1, this.field_145848_d, this.field_145849_e, this.field_145854_h);
        this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1).func_149695_a(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e + 1, this.field_145854_h);
        this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1).func_149695_a(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e - 1, this.field_145854_h);
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K) {
            this.data.kill();
        }
    }

    public int func_70302_i_() {
        return 2;
    }

    public String func_145825_b() {
        return "gui.energon_fluid_tank";
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        FluidStack stack = this.data.getFluid();
        int fill = resource.amount;
        if (stack == null || stack.amount <= 0 || FluidStack.areFluidStackTagsEqual((FluidStack)stack, (FluidStack)resource)) {
            resource.amount -= this.data.tank.fill(resource, doFill);
        } else if (stack.getFluid() == TFFluids.energon) {
            NBTTagCompound prevNBT = resource.tag;
            resource.tag = stack.tag;
            int amount = this.data.tank.fill(resource, doFill);
            resource.tag = prevNBT;
            FluidEnergon.merge(stack, resource, amount);
            resource.amount -= amount;
        }
        if (resource.amount > 0) {
            for (int y = this.field_145848_d + 1; y < this.field_145850_b.func_72800_K() && TFTileHelper.getTileBase(this.field_145850_b.func_147438_o(this.field_145851_c, y, this.field_145849_e)) == TFTileHelper.getTileBase(this); ++y) {
                TileEntityEnergonTank tile = (TileEntityEnergonTank)this.field_145850_b.func_147438_o(this.field_145851_c, y, this.field_145849_e);
                resource.amount -= tile.fill(ForgeDirection.UNKNOWN, resource, doFill);
                if (resource.amount <= 0) break;
            }
        }
        return fill - resource.amount;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null || !resource.isFluidEqual(this.data.getFluid())) {
            return null;
        }
        return this.drain(from, resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        int y;
        TileEntityEnergonTank tileBase = TFTileHelper.getTileBase(this);
        TileEntityEnergonTank topTile = null;
        for (y = tileBase.field_145848_d; y < this.field_145850_b.func_72800_K() && TFTileHelper.getTileBase(this.field_145850_b.func_147438_o(this.field_145851_c, y, this.field_145849_e)) == tileBase; ++y) {
            topTile = (TileEntityEnergonTank)this.field_145850_b.func_147438_o(this.field_145851_c, y, this.field_145849_e);
        }
        if (topTile != null) {
            FluidStack drained = new FluidStack(TFFluids.energon, 0);
            for (y = topTile.field_145848_d; y > 0 && TFTileHelper.getTileBase(this.field_145850_b.func_147438_o(this.field_145851_c, y, this.field_145849_e)) == tileBase; --y) {
                TileEntityEnergonTank tile = (TileEntityEnergonTank)this.field_145850_b.func_147438_o(this.field_145851_c, y, this.field_145849_e);
                FluidStack stack = tile.getTank().drain(maxDrain - drained.amount, doDrain);
                if (stack == null || stack.amount <= 0) continue;
                FluidEnergon.merge(drained, stack, stack.amount);
                drained.amount += stack.amount;
                if (drained.amount >= maxDrain) break;
            }
            return drained;
        }
        return this.data.tank.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid == TFFluids.energon;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.data.tank.getInfo()};
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt) {
        super.readCustomNBT(nbt);
        this.fillTime = nbt.func_74762_e("FillTime");
        if (nbt.func_150297_b("ConfigDataTF", 10)) {
            NBTTagCompound config = nbt.func_74775_l("ConfigDataTF");
            this.data.tank.readFromNBT(config);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt) {
        super.writeCustomNBT(nbt);
        nbt.func_74768_a("FillTime", this.fillTime);
        if (this.data.getFluid() != null && this.data.getFluidAmount() > 0) {
            NBTTagCompound config = nbt.func_74775_l("ConfigDataTF");
            this.data.tank.writeToNBT(config);
            nbt.func_74782_a("ConfigDataTF", (NBTBase)config);
        }
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return stack.func_77973_b() instanceof IFluidContainerItem && (slot == 0 ? !ItemFuelCanister.isEmpty(stack) && ItemFuelCanister.getContainerFluid(stack).getFluid() == TFFluids.energon : ItemFuelCanister.isEmpty(stack) || !ItemFuelCanister.isFull(stack) && ItemFuelCanister.getContainerFluid(stack).getFluid() == TFFluids.energon);
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return this.func_94041_b(slot, stack);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        if (stack.func_77973_b() instanceof IFluidContainerItem) {
            if (slot == 1) {
                return !ItemFuelCanister.isEmpty(stack);
            }
            return ItemFuelCanister.isEmpty(stack);
        }
        return false;
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    public int[] func_94128_d(int side) {
        return slotsSides;
    }

    @Override
    public FluidTankTF getTank() {
        return this.data.tank;
    }

    @Override
    public int[] getBaseOffsets(int metadata) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)metadata);
        int offset = 0;
        if (dir == ForgeDirection.DOWN || dir == ForgeDirection.UP) {
            int y = this.field_145848_d - 1;
            while (y > 0 && this.field_145850_b.func_147438_o(this.field_145851_c, y, this.field_145849_e) instanceof TileEntityEnergonTank && (this.field_145850_b.func_72805_g(this.field_145851_c, y, this.field_145849_e) == dir.ordinal() || this.field_145850_b.func_72805_g(this.field_145851_c, y, this.field_145849_e) == dir.getOpposite().ordinal())) {
                --y;
                --offset;
            }
        }
        return new int[]{0, offset, 0};
    }
}

