/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.common.tileentity;

import fiskfille.tf.common.data.tile.TileData;
import fiskfille.tf.common.data.tile.TileDataEnergonTank;
import fiskfille.tf.common.energon.IEnergon;
import fiskfille.tf.common.fluid.FluidEnergon;
import fiskfille.tf.common.fluid.FluidTankTF;
import fiskfille.tf.common.fluid.IFluidHandlerTF;
import fiskfille.tf.common.fluid.TFFluids;
import fiskfille.tf.common.item.ItemCSD;
import fiskfille.tf.common.item.ItemFuelCanister;
import fiskfille.tf.common.item.TFItems;
import fiskfille.tf.common.recipe.PowerManager;
import fiskfille.tf.common.tileentity.TileEntityMachineContainer;
import fiskfille.tf.helper.TFTileHelper;
import net.minecraft.block.Block;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidContainerItem;

public class TileEntityEnergonProcessor
extends TileEntityMachineContainer
implements IFluidHandlerTF,
ISidedInventory {
    private static final int[] slotsTop = new int[]{1};
    private static final int[] slotsBottom = new int[]{2};
    private static final int[] slotsSides = new int[]{0, 2};
    public TileDataEnergonTank data = new TileDataEnergonTank(2000);
    public int burnTime;
    public int powerTime;
    public int fillTime;
    public int currentMaxPowerTime;
    public float animationTimer;
    public float prevAnimationTimer;
    public int animationBurnTime;

    @Override
    public void func_145845_h() {
        TileData prevData;
        this.prevAnimationTimer = this.animationTimer;
        if (this.burnTime > 0) {
            ++this.animationBurnTime;
            this.animationTimer += 0.001f;
            this.animationTimer *= 1.05f;
        } else {
            this.animationBurnTime = 0;
            this.animationTimer *= 0.95f;
        }
        if (this.animationTimer > 1.0f) {
            this.animationTimer = 1.0f;
        }
        if (!this.data.isInitialized()) {
            this.data.initialize(this);
        }
        ItemStack power = this.func_70301_a(0);
        ItemStack crystal = this.func_70301_a(1);
        ItemStack canister = this.func_70301_a(2);
        if (this.powerTime > 0) {
            --this.powerTime;
        }
        if (this.powerTime <= 0 && power != null && this.func_94041_b(0, power) && this.canProcessCrystal(crystal)) {
            this.currentMaxPowerTime = this.powerTime = PowerManager.getPowerSourceAmount(power) + 2;
            this.func_70298_a(0, 1);
            this.func_70296_d();
        }
        if (this.powerTime > 0 && this.canProcessCrystal(crystal)) {
            if (this.burnTime < 200) {
                ++this.burnTime;
            } else if (this.addContents(crystal)) {
                this.func_70298_a(1, 1);
                this.burnTime = 0;
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.notifyNeighborBlocksOfChange();
            }
        } else {
            this.burnTime = 0;
        }
        if (this.data.getFluidAmount() > 0 && canister != null && canister.func_77973_b() instanceof IFluidContainerItem && (ItemFuelCanister.isEmpty(canister) || ItemFuelCanister.getContainerFluid(canister).getFluid() == TFFluids.energon && !ItemFuelCanister.isFull(canister))) {
            if (this.fillTime < 100) {
                ++this.fillTime;
            } else {
                if (!this.field_145850_b.field_72995_K) {
                    this.fillCanister(canister);
                }
                this.fillTime = 0;
            }
        } else {
            this.fillTime = 0;
        }
        if (this.data.getFluid() != null && this.data.getFluidAmount() == 0) {
            this.data.setFluid(null);
        }
        if (!this.field_145850_b.field_72995_K) {
            this.data.serverTick();
        }
        if ((prevData = TFTileHelper.getTileData(new ItemCSD.DimensionalCoords(this))) instanceof TileDataEnergonTank) {
            this.data = new TileDataEnergonTank((TileDataEnergonTank)prevData);
        }
    }

    public void fillCanister(ItemStack fluidContainer) {
        if (fluidContainer.func_77973_b() instanceof IFluidContainerItem) {
            IFluidContainerItem item = (IFluidContainerItem)fluidContainer.func_77973_b();
            int amount = Math.min(this.data.getFluidAmount(), item.getCapacity(fluidContainer) - ItemFuelCanister.getFluidAmount(fluidContainer));
            FluidStack stack = item.getFluid(fluidContainer);
            if (stack == null) {
                stack = new FluidStack(TFFluids.energon, 0);
            }
            FluidStack stack1 = new FluidStack(TFFluids.energon, amount);
            FluidEnergon.setRatios(stack1, FluidEnergon.getRatios(this.data.getFluid()));
            NBTTagCompound prevNBT = stack1.tag;
            stack1.tag = stack.tag;
            int i = item.fill(fluidContainer, stack1, true);
            this.drain(ForgeDirection.UNKNOWN, amount, true);
            stack.amount += i;
            stack1.tag = prevNBT;
            FluidEnergon.merge(stack, stack1, amount);
            if (!fluidContainer.func_77942_o()) {
                fluidContainer.func_77982_d(new NBTTagCompound());
            }
            fluidContainer.func_77978_p().func_74782_a("Fluid", (NBTBase)stack.writeToNBT(new NBTTagCompound()));
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.notifyNeighborBlocksOfChange();
    }

    public boolean addContents(ItemStack crystal) {
        if (!this.field_145850_b.field_72995_K) {
            FluidStack stack = this.data.getFluid();
            if (stack == null) {
                this.data.setFluid(new FluidStack(TFFluids.energon, 0));
                stack = this.data.getFluid();
            }
            if (stack.getFluid() == TFFluids.energon) {
                FluidStack stack1 = FluidEnergon.create(crystal);
                NBTTagCompound prevNBT = stack1.tag;
                stack1.tag = stack.tag;
                int amount = this.fill(ForgeDirection.UNKNOWN, stack1, true);
                stack1.tag = prevNBT;
                FluidEnergon.merge(stack, stack1, amount);
                return true;
            }
        }
        return false;
    }

    public void notifyNeighborBlocksOfChange() {
        this.field_145850_b.func_147439_a(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e).func_149695_a(this.field_145850_b, this.field_145851_c + 1, this.field_145848_d, this.field_145849_e, this.field_145854_h);
        this.field_145850_b.func_147439_a(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e).func_149695_a(this.field_145850_b, this.field_145851_c - 1, this.field_145848_d, this.field_145849_e, this.field_145854_h);
        this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1).func_149695_a(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e + 1, this.field_145854_h);
        this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1).func_149695_a(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e - 1, this.field_145854_h);
    }

    public boolean canProcessCrystal(ItemStack itemstack) {
        if (itemstack != null && this.func_94041_b(1, itemstack) && this.canActivate()) {
            IEnergon ienergon = (IEnergon)(itemstack.func_77973_b() instanceof ItemBlock ? Block.func_149634_a((Item)itemstack.func_77973_b()) : itemstack.func_77973_b());
            if (this.data.getFluidAmount() + ienergon.getMass() <= this.data.getCapacity()) {
                return true;
            }
        }
        return false;
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K) {
            this.data.kill();
        }
    }

    public int func_70302_i_() {
        return 3;
    }

    public String func_145825_b() {
        return "gui.energon_processor";
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        FluidStack stack = this.data.tank.getFluid();
        if (stack == null || stack.amount <= 0 || FluidStack.areFluidStackTagsEqual((FluidStack)stack, (FluidStack)resource)) {
            return this.data.tank.fill(resource, doFill);
        }
        if (stack.getFluid() == TFFluids.energon) {
            NBTTagCompound prevNBT = resource.tag;
            resource.tag = stack.tag;
            int amount = this.data.tank.fill(resource, doFill);
            resource.tag = prevNBT;
            FluidEnergon.merge(stack, resource, amount);
            return amount;
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null || !resource.isFluidEqual(this.data.getFluid())) {
            return null;
        }
        return this.data.tank.drain(resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.data.tank.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid == TFFluids.energon;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.data.tank.getInfo()};
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return super.getRenderBoundingBox().func_72321_a(0.0, 0.5, 0.0);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt) {
        super.readCustomNBT(nbt);
        this.burnTime = nbt.func_74762_e("BurnTime");
        this.powerTime = nbt.func_74762_e("PowerTime");
        this.fillTime = nbt.func_74762_e("FillTime");
        this.currentMaxPowerTime = nbt.func_74762_e("MaxPowerTime");
        if (nbt.func_150297_b("ConfigDataTF", 10)) {
            NBTTagCompound config = nbt.func_74775_l("ConfigDataTF");
            this.data.tank.readFromNBT(config);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt) {
        super.writeCustomNBT(nbt);
        nbt.func_74768_a("BurnTime", this.burnTime);
        nbt.func_74768_a("PowerTime", this.powerTime);
        nbt.func_74768_a("FillTime", this.fillTime);
        nbt.func_74768_a("MaxPowerTime", this.currentMaxPowerTime);
        if (this.data.getFluid() != null && this.data.getFluidAmount() > 0) {
            NBTTagCompound config = nbt.func_74775_l("ConfigDataTF");
            this.data.tank.writeToNBT(config);
            nbt.func_74782_a("ConfigDataTF", (NBTBase)config);
        }
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return slot == 0 ? PowerManager.isPowerSource(stack) : (slot == 1 ? stack.func_77973_b() instanceof IEnergon || Block.func_149634_a((Item)stack.func_77973_b()) instanceof IEnergon : slot == 2 && stack.func_77973_b() == TFItems.fuelCanister && ItemFuelCanister.isEmpty(stack) && stack.field_77994_a == 1 && this.inventory[slot] == null);
    }

    public int[] func_94128_d(int side) {
        return side == 0 ? slotsBottom : (side == 1 ? slotsTop : slotsSides);
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return this.func_94041_b(slot, stack);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return side != 0 || slot == 0 || slot == 2 && !ItemFuelCanister.isEmpty(stack);
    }

    @Override
    public FluidTankTF getTank() {
        return this.data.tank;
    }
}

