/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.common.tileentity;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fiskfille.tf.TransformersAPI;
import fiskfille.tf.common.item.ItemCSD;
import fiskfille.tf.common.item.ItemComponent;
import fiskfille.tf.common.item.ItemDisplayVehicle;
import fiskfille.tf.common.item.TFItems;
import fiskfille.tf.common.item.armor.ItemTransformerArmor;
import fiskfille.tf.common.network.MessageTileTrigger;
import fiskfille.tf.common.tileentity.IMultiTile;
import fiskfille.tf.common.tileentity.TileEntityContainer;
import fiskfille.tf.helper.TFArmorDyeHelper;
import fiskfille.tf.helper.TFHelper;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.stats.StatFileWriter;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovementInputFromOptions;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayerFactory;

public class TileEntityDisplayStation
extends TileEntityContainer
implements IMultiTile,
MessageTileTrigger.ITileDataCallback {
    public boolean isRedstonePowered = false;
    public final GameProfile username = new GameProfile(UUID.randomUUID(), String.format("[%s]", new Object[]{new ItemCSD.DimensionalCoords(this)}));
    public EntityPlayer fakePlayer;

    public void func_145845_h() {
        if (this.func_145832_p() < 4) {
            if (this.field_145850_b.field_72995_K) {
                this.clientTick();
            } else {
                this.fakePlayer = FakePlayerFactory.get((WorldServer)((WorldServer)this.field_145850_b), (GameProfile)this.username);
            }
            if (this.fakePlayer != null) {
                ++this.fakePlayer.field_70173_aa;
                this.fakePlayer.field_70181_x = 1.25E-85;
                for (int i = 0; i < 4; ++i) {
                    this.fakePlayer.func_70062_b(4 - i, this.func_70301_a(i));
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void clientTick() {
        Minecraft mc;
        if (this.fakePlayer == null && (mc = Minecraft.func_71410_x()) != null && mc.field_71442_b != null && this.func_145831_w() != null) {
            EntityClientPlayerMP player = new EntityClientPlayerMP(mc, this.func_145831_w(), mc.func_110432_I(), mc.func_147114_u(), new StatFileWriter()){

                public boolean func_98034_c(EntityPlayer player) {
                    return true;
                }
            };
            player.field_71158_b = new MovementInputFromOptions(mc.field_71474_y);
            this.fakePlayer = player;
        }
    }

    public boolean canTransform() {
        ItemStack vehicle = this.func_70301_a(6);
        if (this.func_70301_a(6) != null) {
            for (int i = 0; i < 4; ++i) {
                if (this.func_70301_a(i) == null) continue;
                return false;
            }
            return true;
        }
        return TFHelper.isTransformer(this.func_70301_a(0), this.func_70301_a(1), this.func_70301_a(2), this.func_70301_a(3));
    }

    public boolean setColor(int primaryColor, int secondaryColor) {
        ItemStack head = this.func_70301_a(0);
        ItemStack chest = this.func_70301_a(1);
        ItemStack legs = this.func_70301_a(2);
        ItemStack feet = this.func_70301_a(3);
        if (head != null && chest != null && legs != null && feet != null) {
            if (primaryColor == secondaryColor && primaryColor == Integer.MIN_VALUE) {
                TFArmorDyeHelper.removeColor(head);
                TFArmorDyeHelper.removeColor(chest);
                TFArmorDyeHelper.removeColor(legs);
                TFArmorDyeHelper.removeColor(feet);
            } else {
                TFArmorDyeHelper.setPrimaryColor(head, primaryColor);
                TFArmorDyeHelper.setPrimaryColor(chest, primaryColor);
                TFArmorDyeHelper.setPrimaryColor(legs, primaryColor);
                TFArmorDyeHelper.setPrimaryColor(feet, primaryColor);
                TFArmorDyeHelper.setSecondaryColor(head, secondaryColor);
                TFArmorDyeHelper.setSecondaryColor(chest, secondaryColor);
                TFArmorDyeHelper.setSecondaryColor(legs, secondaryColor);
                TFArmorDyeHelper.setSecondaryColor(feet, secondaryColor);
            }
            return true;
        }
        return false;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt) {
        super.readCustomNBT(nbt);
        this.isRedstonePowered = nbt.func_74767_n("Powered");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt) {
        super.writeCustomNBT(nbt);
        nbt.func_74757_a("Powered", this.isRedstonePowered);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return super.getRenderBoundingBox().func_72321_a(0.0, 1.0, 0.0).func_72314_b(0.5, 0.5, 0.5);
    }

    public int func_70302_i_() {
        return 7;
    }

    public String func_145825_b() {
        return "gui.display_station";
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return this.func_70301_a(slot) == null && (slot < 4 ? stack.func_77973_b() instanceof ItemTransformerArmor && stack.func_77973_b().isValidArmor(stack, slot, (Entity)this.fakePlayer) : (slot == 6 ? stack.func_77973_b() == TFItems.displayVehicle : stack.func_77973_b() instanceof ItemComponent));
    }

    @Override
    public int[] getBaseOffsets(int metadata) {
        return new int[]{0, -metadata / 4, 0};
    }

    @Override
    public void receive(EntityPlayer player, int action) {
        if (action == 0 && this.canTransform()) {
            ItemStack vehicle = this.func_70301_a(6);
            if (vehicle != null) {
                ItemStack[] armorFromNBT;
                if (!vehicle.func_77942_o()) {
                    vehicle.func_77982_d(new NBTTagCompound());
                }
                if ((armorFromNBT = ItemDisplayVehicle.getArmorFromNBT(vehicle)) == null) {
                    ItemDisplayVehicle.setNBTData(vehicle);
                    armorFromNBT = ItemDisplayVehicle.getArmorFromNBT(vehicle);
                }
                for (int i = 0; i < armorFromNBT.length; ++i) {
                    this.func_70299_a(i, armorFromNBT[i]);
                }
                this.func_70299_a(6, null);
            } else {
                int i;
                ItemStack itemstack = new ItemStack(TFItems.displayVehicle, 1, TransformersAPI.getTransformers().indexOf(TFHelper.getTransformer(this.func_70301_a(0))));
                ItemStack[] itemstacks = new ItemStack[]{this.func_70301_a(0), this.func_70301_a(1), this.func_70301_a(2), this.func_70301_a(3)};
                NBTTagList itemsList = new NBTTagList();
                for (i = 0; i < itemstacks.length; ++i) {
                    if (itemstacks[i] == null) continue;
                    NBTTagCompound itemTag = new NBTTagCompound();
                    itemTag.func_74774_a("Slot", (byte)i);
                    itemstacks[i].func_77955_b(itemTag);
                    itemsList.func_74742_a((NBTBase)itemTag);
                }
                itemstack.func_77982_d(new NBTTagCompound());
                itemstack.func_77978_p().func_74782_a("Items", (NBTBase)itemsList);
                for (i = 0; i < 4; ++i) {
                    this.func_70299_a(i, null);
                }
                this.func_70299_a(6, itemstack);
            }
        }
        this.func_70296_d();
    }
}

