/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.common.tileentity;

import com.google.common.collect.Lists;
import fiskfille.tf.common.block.BlockControlPanel;
import fiskfille.tf.common.block.BlockGroundBridgeFrame;
import fiskfille.tf.common.block.BlockGroundBridgeTeleporter;
import fiskfille.tf.common.block.TFBlocks;
import fiskfille.tf.common.chunk.ForcedChunk;
import fiskfille.tf.common.chunk.SubTicket;
import fiskfille.tf.common.chunk.TFChunkManager;
import fiskfille.tf.common.data.tile.TileData;
import fiskfille.tf.common.data.tile.TileDataControlPanel;
import fiskfille.tf.common.energon.power.IEnergyReceiver;
import fiskfille.tf.common.energon.power.ReceiverHandler;
import fiskfille.tf.common.groundbridge.DataCore;
import fiskfille.tf.common.groundbridge.GroundBridgeError;
import fiskfille.tf.common.item.ItemCSD;
import fiskfille.tf.common.item.TFItems;
import fiskfille.tf.common.network.MessageTileTrigger;
import fiskfille.tf.common.tileentity.IChunkLoaderTile;
import fiskfille.tf.common.tileentity.IMultiTile;
import fiskfille.tf.common.tileentity.TileEntityGroundBridgeFrame;
import fiskfille.tf.common.tileentity.TileEntityMachineContainer;
import fiskfille.tf.config.TFConfig;
import fiskfille.tf.helper.TFDimensionHelper;
import fiskfille.tf.helper.TFMathHelper;
import fiskfille.tf.helper.TFTileHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityControlPanel
extends TileEntityMachineContainer
implements IEnergyReceiver,
MessageTileTrigger.ITileDataCallback,
IChunkLoaderTile,
IMultiTile {
    public static final int[][] directions = new int[][]{{-1, 0}, {0, -1}, {1, 0}, {0, 1}};
    public ReceiverHandler receiverHandler = new ReceiverHandler(this);
    public Integer[][] switches = new Integer[][]{{0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}};
    public TileDataControlPanel data = new TileDataControlPanel();
    public float animPortalDirection;
    public float prevAnimPortalDirection;
    public boolean activationLeverCoverState = false;
    public float activationLeverTimer;
    public float prevActivationLeverTimer;
    public float activationLeverCoverTimer;
    public float prevActivationLeverCoverTimer;
    public boolean hasSpace;
    public float lastUsage;
    public int destDimIndex = 1;
    public int prevYCoord;
    public LinkedList<ForgeChunkManager.Ticket> chunkTickets = Lists.newLinkedList(Arrays.asList(null, null));
    public LinkedList<ForcedChunk> forcedChunks = Lists.newLinkedList(Arrays.asList(null, null));

    @Override
    public void func_145845_h() {
        if (BlockControlPanel.isBlockLeftSideOfPanel(this.func_145832_p())) {
            if (!this.data.isInitialized()) {
                this.data.initialize(this);
            }
            if (!this.data.activationLeverState) {
                ArrayList list = new ArrayList(this.field_145850_b.field_147482_g);
                Collections.sort(list, new Comparator<TileEntity>(){

                    @Override
                    public int compare(TileEntity tile1, TileEntity tile2) {
                        return Double.valueOf(Math.sqrt(TileEntityControlPanel.this.func_145835_a(tile1.field_145851_c, tile1.field_145849_e, tile1.field_145848_d))).compareTo(Math.sqrt(TileEntityControlPanel.this.func_145835_a(tile2.field_145851_c, tile2.field_145849_e, tile2.field_145848_d)));
                    }
                });
                for (TileEntity tile : list) {
                    ForgeDirection direction;
                    if (!(Math.sqrt(this.func_145835_a(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e)) <= (double)TFConfig.controlPanelMaxRange) || !(tile instanceof TileEntityGroundBridgeFrame) || (direction = BlockGroundBridgeFrame.getFrameDirection((IBlockAccess)this.field_145850_b, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e)) == null) continue;
                    this.data.framePos = new ItemCSD.DimensionalCoords(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, this.field_145850_b.field_73011_w.field_76574_g);
                    break;
                }
            }
            if (this.data.framePos != null) {
                int x = this.data.framePos.field_71574_a;
                int y = this.data.framePos.field_71572_b;
                int z = this.data.framePos.field_71573_c;
                if (BlockGroundBridgeFrame.getFrameDirection((IBlockAccess)this.field_145850_b, x, y, z) == null) {
                    this.data.framePos = null;
                } else if (!this.data.activationLeverState) {
                    int dir = this.field_145850_b.func_72805_g(x, y, z) * 2;
                    if (BlockGroundBridgeFrame.getFrameDirection((IBlockAccess)this.field_145850_b, x, y, z) == ForgeDirection.EAST) {
                        ++dir;
                    }
                    this.data.frameDirection = dir;
                }
            }
            if (!this.field_145850_b.field_72995_K) {
                this.data.errors.clear();
                this.data.upgrades.clear();
                ArrayList upgrades = Lists.newArrayList();
                for (int i = 0; i < this.func_70302_i_(); ++i) {
                    ItemStack itemstack = this.func_70301_a(i);
                    if (itemstack == null || itemstack.func_77973_b() != TFItems.dataCore) continue;
                    upgrades.add(DataCore.get(itemstack.func_77960_j()));
                }
                this.data.upgrades.addAll(upgrades);
                this.calculateCoords();
                this.loadChunks();
                if (this.data.framePos != null) {
                    int x = this.data.framePos.field_71574_a;
                    int y = this.data.framePos.field_71572_b;
                    int z = this.data.framePos.field_71573_c;
                    ForgeDirection direction = BlockGroundBridgeFrame.getFrameDirection((IBlockAccess)this.field_145850_b, x, y, z);
                    if (direction == null || this.isPortalObstructed(x, y, z, direction)) {
                        this.data.errors.add(new GroundBridgeError.ErrorContainer(GroundBridgeError.PORTAL_OBSTRUCTED, new Integer[0]));
                    }
                } else {
                    this.data.errors.add(new GroundBridgeError.ErrorContainer(GroundBridgeError.NO_PORTAL_LINKED, new Integer[0]));
                }
                int destX = this.data.destination.field_71574_a;
                int destY = this.data.modifiedDestY;
                int destZ = this.data.destination.field_71573_c;
                if (TFConfig.groundBridgeMinRange && Math.sqrt(this.func_145835_a(destX, destY, destZ)) <= 64.0 && this.getDestDimensionID() == this.field_145850_b.field_73011_w.field_76574_g) {
                    this.data.errors.add(new GroundBridgeError.ErrorContainer(GroundBridgeError.INVALID_COORDS, 64));
                }
                if (destY < 0 || destY + 5 >= this.getDestWorld().func_72800_K()) {
                    this.data.errors.add(new GroundBridgeError.ErrorContainer(GroundBridgeError.OUT_OF_BOUNDS, this.getDestWorld().func_72800_K()));
                }
                if (!(this.hasSpace = this.checkForSpace((World)this.getDestWorld(), destX, destY, destZ))) {
                    this.data.errors.add(new GroundBridgeError.ErrorContainer(GroundBridgeError.NOT_ENOUGH_SPACE, new Integer[0]));
                }
                if (this.extractEnergy(this.getConsumptionRate(), true) < this.getConsumptionRate()) {
                    this.data.errors.add(new GroundBridgeError.ErrorContainer(GroundBridgeError.NOT_ENOUGH_ENERGY, new Integer[0]));
                }
                if (this.data.errors.isEmpty() && this.data.activationLeverState && this.data.framePos != null) {
                    try {
                        int x = this.data.framePos.field_71574_a;
                        int y = this.data.framePos.field_71572_b;
                        int z = this.data.framePos.field_71573_c;
                        BlockGroundBridgeTeleporter.spawnTeleporter(this.field_145850_b, x, y, z, this);
                        if (this.data.direction % 2 == 0) {
                            BlockGroundBridgeTeleporter.fillNorthFacingFrame((World)this.getDestWorld(), destX, destY - 1, destZ, TFBlocks.groundBridgeTeleporter, this, true);
                        } else {
                            BlockGroundBridgeTeleporter.fillEastFacingFrame((World)this.getDestWorld(), destX, destY - 1, destZ, TFBlocks.groundBridgeTeleporter, this, true);
                        }
                        this.extractEnergy(this.getConsumptionRate(), false);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                this.data.serverTick();
            } else {
                this.prevActivationLeverTimer = this.activationLeverTimer;
                this.prevActivationLeverCoverTimer = this.activationLeverCoverTimer;
                this.prevAnimPortalDirection = this.animPortalDirection;
                boolean bl = this.activationLeverCoverState = this.data.activationLeverState || this.data.errors.isEmpty();
                if (this.data.activationLeverState) {
                    if (this.activationLeverTimer < 1.0f) {
                        this.activationLeverTimer += 0.125f;
                    }
                } else if (this.activationLeverTimer > 0.0f) {
                    this.activationLeverTimer -= 0.125f;
                }
                if (this.activationLeverCoverState) {
                    if (this.activationLeverCoverTimer < 1.0f) {
                        this.activationLeverCoverTimer += 0.1f;
                    }
                } else if (this.activationLeverCoverTimer > 0.0f) {
                    this.activationLeverCoverTimer -= 0.1f;
                }
                this.activationLeverTimer = MathHelper.func_76131_a((float)this.activationLeverTimer, (float)0.0f, (float)1.0f);
                this.activationLeverCoverTimer = MathHelper.func_76131_a((float)this.activationLeverCoverTimer, (float)0.0f, (float)1.0f);
                int dir = this.data.direction == 0 && this.animPortalDirection > (float)this.data.direction ? (this.animPortalDirection == 0.0f ? 0 : 4) : this.data.direction;
                float incr = 0.2f;
                if (this.animPortalDirection < (float)dir) {
                    this.animPortalDirection += incr;
                } else if (this.animPortalDirection > (float)dir) {
                    this.animPortalDirection -= incr;
                }
                this.animPortalDirection = (float)Math.round(this.animPortalDirection * 1000.0f) / 1000.0f;
                if (this.animPortalDirection > 3.0f) {
                    this.animPortalDirection -= 4.0f;
                    this.prevAnimPortalDirection -= 4.0f;
                }
            }
            TileData prevData = TFTileHelper.getTileData(new ItemCSD.DimensionalCoords(this));
            if (prevData instanceof TileDataControlPanel) {
                this.data = new TileDataControlPanel((TileDataControlPanel)prevData);
            }
        }
    }

    private void calculateCoords() {
        WorldServer world;
        this.data.destination.set(this);
        int[] increments = this.getCoordinateIncrements();
        int[] coordArray = this.data.destination.toArray();
        for (int i = 0; i < this.switches.length; ++i) {
            for (int j = 0; j < this.switches[i].length; ++j) {
                int n = i;
                coordArray[n] = coordArray[n] + this.switches[i][j] * increments[j];
            }
        }
        this.data.destination.set(coordArray);
        this.data.destination.dimension = this.getDestDimensionID();
        if (!this.field_145850_b.field_72995_K && (world = this.getDestWorld()) != null) {
            int y;
            int x = this.data.destination.field_71574_a;
            int z = this.data.destination.field_71573_c;
            if (this.hasUpgrade(DataCore.leveler)) {
                if (!this.data.activationLeverState) {
                    for (y = this.data.destination.field_71572_b; y > 0 && this.checkForSpace((World)world, x, y - 1, z); --y) {
                    }
                    this.prevYCoord = y;
                } else {
                    y = this.prevYCoord;
                }
            }
            this.data.modifiedDestY = y;
        }
    }

    private int[] getCoordinateIncrements() {
        int[] increments = new int[]{1, 10, 100, 1000};
        if (this.hasUpgrade(DataCore.range)) {
            for (int i = 0; i < this.data.upgrades.size(); ++i) {
                DataCore dataCore = this.data.upgrades.get(i);
                if (dataCore != DataCore.range) continue;
                int j = 0;
                while (j < increments.length) {
                    int n = j++;
                    increments[n] = increments[n] * 2;
                }
            }
        }
        return increments;
    }

    private boolean isPortalObstructed(int x, int y, int z, ForgeDirection direction) {
        if (direction == ForgeDirection.NORTH) {
            for (int i = 0; i < 5; ++i) {
                for (int j = 0; j < 3; ++j) {
                    if ((this.field_145850_b.func_147439_a(x - 1 + j, y + 1 + i, z) == Blocks.field_150350_a || this.field_145850_b.func_147439_a(x - 1 + j, y + 1 + i, z) == TFBlocks.groundBridgeTeleporter) && (this.field_145850_b.func_147439_a(x - 2 + i, y + 2 + j, z) == Blocks.field_150350_a || this.field_145850_b.func_147439_a(x - 2 + i, y + 2 + j, z) == TFBlocks.groundBridgeTeleporter)) continue;
                    return true;
                }
            }
        } else {
            for (int i = 0; i < 5; ++i) {
                for (int j = 0; j < 3; ++j) {
                    if ((this.field_145850_b.func_147439_a(x, y + 1 + i, z - 1 + j) == Blocks.field_150350_a || this.field_145850_b.func_147439_a(x, y + 1 + i, z - 1 + j) == TFBlocks.groundBridgeTeleporter) && (this.field_145850_b.func_147439_a(x, y + 2 + j, z - 2 + i) == Blocks.field_150350_a || this.field_145850_b.func_147439_a(x, y + 2 + j, z - 2 + i) == TFBlocks.groundBridgeTeleporter)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean checkForSpace(World world, int x, int y, int z) {
        Block b = Blocks.field_150350_a;
        Block b1 = TFBlocks.groundBridgeTeleporter;
        if (this.data.direction % 2 == 0) {
            for (int i = 0; i < 5; ++i) {
                for (int j = 0; j < 3; ++j) {
                    if ((world.func_147439_a(x - 1 + j, y + i, z) == b || world.func_147439_a(x - 1 + j, y + i, z) == b1) && (world.func_147439_a(x - 2 + i, y + 1 + j, z) == b || world.func_147439_a(x - 2 + i, y + 1 + j, z) == b1)) continue;
                    return false;
                }
            }
        } else {
            for (int i = 0; i < 5; ++i) {
                for (int j = 0; j < 3; ++j) {
                    if ((world.func_147439_a(x, y + i, z - 1 + j) == b || world.func_147439_a(x, y + i, z - 1 + j) == b1) && (world.func_147439_a(x, y + 1 + j, z - 2 + i) == b || world.func_147439_a(x, y + 1 + j, z - 2 + i) == b1)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private WorldServer getDestWorld() {
        MinecraftServer server = MinecraftServer.func_71276_C();
        return server.func_71218_a(this.getDestDimensionID());
    }

    public void changeSwitch(int group, int id, int amount) {
        if (!this.data.activationLeverState) {
            if (this.switches[group][id] + amount <= 10 && this.switches[group][id] + amount >= -10) {
                Integer[] integerArray = this.switches[group];
                int n = id;
                Integer.valueOf(integerArray[n] + amount);
            }
            this.calculateCoords();
            this.markBlockForUpdate();
        }
    }

    public void setSwitchesTo(ItemCSD.DimensionalCoords coords) {
        if (!this.data.activationLeverState) {
            int coordinateScale = 1;
            for (int i = 0; i < this.data.upgrades.size(); ++i) {
                DataCore dataCore = this.data.upgrades.get(i);
                if (dataCore != DataCore.range) continue;
                coordinateScale *= 2;
            }
            int[] increments = new int[]{1, 10, 100, 1000};
            int[] target = new int[]{coords.field_71574_a, coords.field_71572_b, coords.field_71573_c};
            int[] current = new int[]{this.field_145851_c, this.field_145848_d, this.field_145849_e};
            this.switches = new Integer[][]{{0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}};
            for (int axisIndex = 0; axisIndex < target.length; ++axisIndex) {
                int delta = (target[axisIndex] - current[axisIndex]) / coordinateScale;
                int[] split = TFMathHelper.split(delta, increments.length, 10);
                for (int i = 0; i < split.length; ++i) {
                    this.switches[axisIndex][i] = MathHelper.func_76125_a((int)(split[i] / increments[i]), (int)-10, (int)10);
                }
            }
            for (int i = 0; i < TFDimensionHelper.dimensionIDs.length; ++i) {
                int id = TFDimensionHelper.dimensionIDs[i];
                if (coords.dimension != id) continue;
                this.destDimIndex = i;
                break;
            }
            this.calculateCoords();
        }
    }

    public void cycleDimensionID(int amount) {
        if (!this.data.activationLeverState) {
            this.destDimIndex += amount;
            if (this.destDimIndex < 0) {
                this.destDimIndex = TFDimensionHelper.dimensionIDs.length - 1;
            } else if (this.destDimIndex >= TFDimensionHelper.dimensionIDs.length) {
                this.destDimIndex = 0;
            }
            this.calculateCoords();
            this.markBlockForUpdate();
        }
    }

    public List<DataCore> getUpgrades() {
        return this.data.upgrades;
    }

    public boolean hasUpgrade(DataCore dataCore) {
        return this.data.hasUpgrade(dataCore);
    }

    private int getDestDimensionID() {
        if (!this.hasUpgrade(DataCore.spaceBridge) || TFDimensionHelper.dimensionIDs.length < 2) {
            return this.field_145850_b.field_73011_w.field_76574_g;
        }
        return TFDimensionHelper.dimensionIDs[MathHelper.func_76125_a((int)this.destDimIndex, (int)0, (int)(TFDimensionHelper.dimensionIDs.length - 1))];
    }

    public float getConsumptionRate() {
        float base = 10.0f;
        for (int i = 0; i < this.data.upgrades.size(); ++i) {
            DataCore dataCore = this.data.upgrades.get(i);
            if (dataCore != DataCore.range) continue;
            base *= 1.25f;
        }
        if (this.getDestDimensionID() != this.field_145850_b.field_73011_w.field_76574_g) {
            base *= 2.0f;
        }
        return base;
    }

    @Override
    public void markBlockForUpdate() {
        SubTicket subTicket;
        ForgeChunkManager.Ticket ticket;
        if (!this.field_145850_b.field_72995_K && (ticket = this.chunkTickets.get(1)) != null && (subTicket = this.getSubTicket(ticket, 1)) != null) {
            NBTTagCompound nbt = subTicket.getTag();
            boolean updateTicket = true;
            if (this.data.destination.field_71574_a == nbt.func_74762_e("destX") && this.data.destination.field_71573_c == nbt.func_74762_e("destZ") && this.getDestWorld() == subTicket.owner.world) {
                updateTicket = false;
            }
            if (updateTicket) {
                this.releaseChunk(1);
                this.loadChunks();
            }
        }
    }

    public int func_70302_i_() {
        return 3;
    }

    public String func_145825_b() {
        return "gui.control_panel";
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return super.getRenderBoundingBox().func_72321_a(0.0, 0.5, 0.0).func_72314_b(1.0, 0.0, 1.0);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt) {
        super.readCustomNBT(nbt);
        this.data.direction = nbt.func_74762_e("PortalDirection");
        this.data.frameDirection = nbt.func_74762_e("SrcPortalDirection");
        this.data.activationLeverState = nbt.func_74767_n("Lever");
        this.activationLeverCoverState = nbt.func_74767_n("LeverCover");
        this.prevActivationLeverTimer = this.data.activationLeverState ? 1.0f : 0.0f;
        this.activationLeverTimer = this.prevActivationLeverTimer;
        this.hasSpace = nbt.func_74767_n("HasSpace");
        this.destDimIndex = nbt.func_74762_e("DestDimIndex");
        this.prevYCoord = nbt.func_74762_e("PrevY");
        if (nbt.func_74767_n("ReadFramePos")) {
            this.data.framePos = new ItemCSD.DimensionalCoords(nbt.func_74762_e("FrameX"), nbt.func_74762_e("FrameY"), nbt.func_74762_e("FrameZ"), nbt.func_74762_e("FrameDim"));
        }
        if (nbt.func_150297_b("ConfigDataTF", 10)) {
            NBTTagCompound config = nbt.func_74775_l("ConfigDataTF");
            this.data.storage.readFromNBT(config);
        }
        if (nbt.func_74764_b("Switches")) {
            NBTTagList nbttaglist = nbt.func_150295_c("Switches", 10);
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
                for (int j = 0; j < 4; ++j) {
                    this.switches[i][j] = nbttagcompound.func_74762_e("Switch" + (j + 1));
                }
            }
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt) {
        super.writeCustomNBT(nbt);
        nbt.func_74768_a("PortalDirection", this.data.direction);
        nbt.func_74768_a("SrcPortalDirection", this.data.frameDirection);
        nbt.func_74757_a("Lever", this.data.activationLeverState);
        nbt.func_74757_a("LeverCover", this.activationLeverCoverState);
        nbt.func_74757_a("HasSpace", this.hasSpace);
        nbt.func_74757_a("ReadFramePos", this.data.framePos != null);
        nbt.func_74768_a("DestDimIndex", this.destDimIndex);
        nbt.func_74768_a("PrevY", this.prevYCoord);
        if (this.data.framePos != null) {
            nbt.func_74768_a("FrameX", this.data.framePos.field_71574_a);
            nbt.func_74768_a("FrameY", this.data.framePos.field_71572_b);
            nbt.func_74768_a("FrameZ", this.data.framePos.field_71573_c);
            nbt.func_74768_a("FrameDim", this.data.framePos.dimension);
        }
        if (this.data.storage.getEnergy() > 0.0f) {
            NBTTagCompound config = nbt.func_74775_l("ConfigDataTF");
            this.data.storage.writeToNBT(config);
            nbt.func_74782_a("ConfigDataTF", (NBTBase)config);
        }
        NBTTagList nbttaglist = new NBTTagList();
        for (Integer[] aint : this.switches) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            for (int j = 0; j < aint.length; ++j) {
                int value = aint[j];
                nbttagcompound.func_74768_a("Switch" + (j + 1), value);
            }
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        nbt.func_74782_a("Switches", (NBTBase)nbttaglist);
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return stack.func_77973_b() == TFItems.dataCore;
    }

    @Override
    public boolean func_70300_a(EntityPlayer player) {
        return super.func_70300_a(player) || player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() == TFItems.groundBridgeRemote;
    }

    @Override
    public float receiveEnergy(float amount, boolean simulate) {
        return this.data.storage.add(amount, simulate);
    }

    @Override
    public float extractEnergy(float amount, boolean simulate) {
        return this.data.storage.remove(amount, simulate);
    }

    @Override
    public float getEnergy() {
        return this.data.storage.getEnergy();
    }

    @Override
    public float getMaxEnergy() {
        return this.data.storage.getMaxEnergy();
    }

    @Override
    public float getEnergyUsage() {
        return this.data.storage.getUsage();
    }

    @Override
    public ReceiverHandler getReceiverHandler() {
        return this.receiverHandler;
    }

    @Override
    public boolean canReceiveEnergy(TileEntity from) {
        return BlockControlPanel.isBlockLeftSideOfPanel(this.func_145832_p());
    }

    @Override
    public Vec3 getEnergyInputOffset() {
        float yaw = (this.func_145832_p() + 2) * 90;
        Vec3 vec3 = Vec3.func_72443_a((double)-0.055f, (double)0.175f, (double)-0.5);
        vec3.func_72442_b(-yaw * (float)Math.PI / 180.0f);
        return vec3;
    }

    @Override
    public int getMapColor() {
        return 2555787;
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K) {
            this.data.kill();
            this.releaseChunk(0);
            this.releaseChunk(1);
        }
    }

    @Override
    public void forceChunks(SubTicket subTicket) {
        if (subTicket.getTag().func_74764_b("destX") && subTicket.getTag().func_74764_b("destZ")) {
            this.forceChunk(subTicket, 1, new ForcedChunk((World)this.getDestWorld(), this.data.destination.field_71574_a >> 4, this.data.destination.field_71573_c >> 4));
        } else {
            this.forceChunk(subTicket, 0, ForcedChunk.fromTile(this));
        }
    }

    public void forceChunk(SubTicket subTicket, int index, ForcedChunk chunk) {
        this.releaseChunk(index);
        this.chunkTickets.set(index, subTicket.owner);
        this.forcedChunks.set(index, chunk);
        TFChunkManager.forceChunk(subTicket.owner, chunk);
    }

    public void loadChunks() {
        if (this.chunkTickets.get(0) == null || this.chunkTickets.get(1) == null) {
            SubTicket subTicket = SubTicket.fromTile(this);
            subTicket.getTag().func_74768_a("destX", this.data.destination.field_71574_a);
            subTicket.getTag().func_74768_a("destZ", this.data.destination.field_71573_c);
            this.loadChunk(SubTicket.fromTile(this), 0, ForcedChunk.fromTile(this));
            this.loadChunk(subTicket, 1, new ForcedChunk((World)this.getDestWorld(), this.data.destination.field_71574_a >> 4, this.data.destination.field_71573_c >> 4));
        }
    }

    public void loadChunk(SubTicket subTicket, int index, ForcedChunk chunk) {
        ForgeChunkManager.Ticket ticket;
        if (this.chunkTickets.get(index) == null && (ticket = TFChunkManager.getTicketForChunk(chunk)) != null) {
            this.forceChunk(subTicket.assign(ticket), index, chunk);
        }
    }

    public void releaseChunk(int index) {
        SubTicket subTicket;
        if (this.chunkTickets.get(index) != null && (subTicket = this.getSubTicket(this.chunkTickets.get(index), index)) != null) {
            TFChunkManager.releaseChunk(subTicket, this.forcedChunks.get(index));
            this.chunkTickets.set(index, null);
            this.forcedChunks.set(index, null);
        }
    }

    public SubTicket getSubTicket(ForgeChunkManager.Ticket ticket, int index) {
        List<SubTicket> list = SubTicket.getChildren(this.chunkTickets.get(index));
        for (SubTicket subTicket : list) {
            if (subTicket.xCoord != this.field_145851_c || subTicket.yCoord != this.field_145848_d || subTicket.zCoord != this.field_145849_e) continue;
            if (index == 1 && subTicket.getTag().func_74764_b("destX") && subTicket.getTag().func_74764_b("destZ")) {
                return subTicket;
            }
            if (index != 0) continue;
            return subTicket;
        }
        return null;
    }

    @Override
    public int[] getBaseOffsets(int metadata) {
        int direction = BlockControlPanel.getDirection(metadata);
        boolean isSide = !BlockControlPanel.isBlockLeftSideOfPanel(metadata);
        return new int[]{-(isSide ? directions[direction][0] : 0), -(BlockControlPanel.isBlockTopOfPanel(metadata) ? 1 : 0), -(isSide ? directions[direction][1] : 0)};
    }

    @Override
    public void receive(EntityPlayer player, int action) {
        super.receive(player, action);
        if (player != null && (this.func_70300_a(player) || player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() == TFItems.groundBridgeRemote)) {
            int increment;
            int n = increment = player.func_70093_af() ? -1 : 1;
            if (action >= 1 && action <= 4) {
                this.changeSwitch(0, action - 1, increment);
            } else if (action >= 5 && action <= 8) {
                this.changeSwitch(1, action - 5, increment);
            } else if (action >= 9 && action <= 12) {
                this.changeSwitch(2, action - 9, increment);
            } else if (action == 13) {
                if (!player.field_70170_p.field_72995_K) {
                    this.data.direction = (this.data.direction + 1) % 4;
                }
            } else if (action == 14) {
                if (!player.field_70170_p.field_72995_K) {
                    this.data.activationLeverState = !this.data.activationLeverState;
                }
            } else if (action >= 15 && action <= 17) {
                if (!this.data.activationLeverState) {
                    int slot = action - 15;
                    if (this.func_70301_a(slot) == null && player.func_70694_bm() != null && this.func_94041_b(slot, player.func_70694_bm())) {
                        this.func_70299_a(slot, player.func_70694_bm());
                        player.func_70062_b(0, null);
                    } else if (this.func_70301_a(slot) != null && (player.func_70694_bm() == null || this.func_94041_b(slot, player.func_70694_bm()))) {
                        ItemStack itemstack = this.func_70301_a(slot).func_77946_l();
                        this.func_70299_a(slot, player.func_70694_bm());
                        player.func_70062_b(0, itemstack);
                    }
                    this.markBlockForUpdate();
                }
            } else if ((action == 18 || action == 19) && this.hasUpgrade(DataCore.spaceBridge)) {
                this.cycleDimensionID(action == 18 ? -1 : 1);
            }
        }
    }
}

