/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.common.tileentity;

import com.google.common.collect.Lists;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fiskfille.tf.common.block.BlockAlloyCrucible;
import fiskfille.tf.common.data.tile.TileData;
import fiskfille.tf.common.data.tile.TileDataEnergyContainer;
import fiskfille.tf.common.energon.power.IEnergyReceiver;
import fiskfille.tf.common.energon.power.ReceiverHandler;
import fiskfille.tf.common.item.ItemCSD;
import fiskfille.tf.common.network.MessageTileTrigger;
import fiskfille.tf.common.recipe.AlloyRecipes;
import fiskfille.tf.common.tileentity.TileEntityMachineContainer;
import fiskfille.tf.helper.TFTileHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;

public class TileEntityAlloyCrucible
extends TileEntityMachineContainer
implements IEnergyReceiver,
ISidedInventory,
MessageTileTrigger.ITileDataCallback {
    private static final int[] slotsBottom = new int[]{3};
    private static final int[] slotsSides = new int[]{0, 1, 2};
    public ReceiverHandler receiverHandler = new ReceiverHandler(this);
    public TileDataEnergyContainer data = new TileDataEnergyContainer(32000.0f);
    public EnumSmeltingMode smeltingMode = EnumSmeltingMode.ALLOY;
    public ItemStack smeltingResult;
    public boolean alloyResult;
    public int smeltTime;
    public int alloyResults;
    public int furnaceResults;
    private int metadataFlags;

    @Override
    public void func_145845_h() {
        int i;
        TileData prevData;
        super.func_145845_h();
        if (!this.data.isInitialized()) {
            this.data.initialize(this);
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.canSmelt()) {
                if (this.extractEnergy(this.getConsumptionRate(), false) >= this.getConsumptionRate() && ++this.smeltTime == this.getSmeltTimeMax()) {
                    this.smeltTime = 0;
                    this.smeltItem();
                    this.func_70296_d();
                }
            } else {
                this.smeltTime = 0;
            }
            this.data.serverTick();
        }
        if ((prevData = TFTileHelper.getTileData(new ItemCSD.DimensionalCoords(this))) instanceof TileDataEnergyContainer) {
            this.data = new TileDataEnergyContainer((TileDataEnergyContainer)prevData);
        }
        if ((i = this.getMetadataFlags()) != this.metadataFlags) {
            this.metadataFlags = i;
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, i, 2);
        }
    }

    public int getMetadataFlags() {
        int metadata = BlockAlloyCrucible.getRotation(this.func_145832_p());
        if (this.getEnergy() > 0.0f) {
            metadata |= 4;
        }
        if (this.canSmelt()) {
            metadata |= 8;
        }
        return metadata;
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K) {
            this.data.kill();
        }
    }

    public int func_70302_i_() {
        return 4;
    }

    public String func_145825_b() {
        return "gui.alloy_crucible";
    }

    public boolean canSmelt() {
        return this.canActivate() && this.getEnergy() >= this.getConsumptionRate() && this.getStacksToSmelt().length > 0;
    }

    public float getConsumptionRate() {
        return 2.0f;
    }

    public int getSmeltTimeMax() {
        return this.alloyResult && this.smeltingResult != null ? AlloyRecipes.getInstance().getSmeltTime(this.smeltingResult) : 150;
    }

    @SideOnly(value=Side.CLIENT)
    public int getSmeltProgressScaled(int i) {
        return this.smeltTime * i / this.getSmeltTimeMax();
    }

    public ItemStack[] getStacksToSmelt() {
        int amount;
        ItemStack result;
        int i;
        LinkedList list = Lists.newLinkedList();
        if (this.smeltingMode != EnumSmeltingMode.FURNACE) {
            for (i = 0; i < 3; ++i) {
                if (this.inventory[i] == null) continue;
                list.add(this.inventory[i]);
                result = AlloyRecipes.getInstance().getSmeltingResult(new AlloyRecipes.AlloyIngredients(list.toArray()));
                if (result == null) continue;
                if (this.inventory[3] == null) {
                    this.smeltingResult = result;
                    this.alloyResult = true;
                    return list.toArray(new ItemStack[3]);
                }
                if (!this.inventory[3].func_77969_a(result) || (amount = this.inventory[3].field_77994_a + result.field_77994_a) > this.func_70297_j_() || amount > this.inventory[3].func_77976_d()) continue;
                this.smeltingResult = result;
                this.alloyResult = true;
                return list.toArray(new ItemStack[3]);
            }
            list.clear();
        }
        if (this.smeltingMode != EnumSmeltingMode.ALLOY) {
            for (i = 0; i < 3; ++i) {
                if (this.inventory[i] == null || (result = FurnaceRecipes.func_77602_a().func_151395_a(this.inventory[i])) == null) continue;
                if (this.inventory[3] == null) {
                    list.add(this.inventory[i]);
                    continue;
                }
                if (!this.inventory[3].func_77969_a(result) || (amount = this.inventory[3].field_77994_a + result.field_77994_a) > this.func_70297_j_() || amount > this.inventory[3].func_77976_d()) continue;
                list.add(this.inventory[i]);
            }
        }
        if (!list.isEmpty()) {
            this.smeltingResult = (ItemStack)list.getFirst();
            this.alloyResult = false;
        }
        return list.toArray(new ItemStack[list.size()]);
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack result;
            if (this.smeltingMode != EnumSmeltingMode.FURNACE && (result = AlloyRecipes.getInstance().getSmeltingResult(new AlloyRecipes.AlloyIngredients(Arrays.asList(this.getStacksToSmelt()).toArray()))) != null) {
                if (this.inventory[3] == null) {
                    this.inventory[3] = result.func_77946_l();
                } else if (this.inventory[3].func_77973_b() == result.func_77973_b()) {
                    this.inventory[3].field_77994_a += result.field_77994_a;
                }
                ArrayList list = Lists.newArrayList((Object[])this.getStacksToSmelt());
                for (int i = 0; i < 3; ++i) {
                    if (this.inventory[i] == null || !list.contains(this.inventory[i])) continue;
                    list.remove(this.inventory[i]);
                    --this.inventory[i].field_77994_a;
                    if (this.inventory[i].field_77994_a > 0) continue;
                    this.inventory[i] = null;
                }
                this.smeltingResult = null;
                ++this.alloyResults;
                return;
            }
            if (this.smeltingMode != EnumSmeltingMode.ALLOY && (result = FurnaceRecipes.func_77602_a().func_151395_a(this.getStacksToSmelt()[0])) != null) {
                for (int i = 0; i < 3; ++i) {
                    if (this.inventory[i] != this.getStacksToSmelt()[0]) continue;
                    if (this.inventory[3] == null) {
                        this.inventory[3] = result.func_77946_l();
                    } else if (this.inventory[3].func_77973_b() == result.func_77973_b()) {
                        this.inventory[3].field_77994_a += result.field_77994_a;
                    }
                    --this.inventory[i].field_77994_a;
                    if (this.inventory[i].field_77994_a <= 0) {
                        this.inventory[i] = null;
                    }
                    this.smeltingResult = null;
                    ++this.furnaceResults;
                    return;
                }
            }
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt) {
        super.readCustomNBT(nbt);
        this.smeltingMode = EnumSmeltingMode.values()[nbt.func_74771_c("Mode") % EnumSmeltingMode.values().length];
        this.smeltTime = nbt.func_74765_d("SmeltTime");
        this.alloyResults = nbt.func_74771_c("AlloySmelts");
        this.furnaceResults = nbt.func_74771_c("FurnaceSmelts");
        if (nbt.func_150297_b("ConfigDataTF", 10)) {
            NBTTagCompound config = nbt.func_74775_l("ConfigDataTF");
            this.data.storage.readFromNBT(config);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt) {
        super.writeCustomNBT(nbt);
        nbt.func_74774_a("Mode", (byte)this.smeltingMode.ordinal());
        nbt.func_74777_a("SmeltTime", (short)this.smeltTime);
        nbt.func_74774_a("AlloySmelts", (byte)this.alloyResults);
        nbt.func_74774_a("FurnaceSmelts", (byte)this.furnaceResults);
        if (this.data.storage.getEnergy() > 0.0f) {
            NBTTagCompound config = nbt.func_74775_l("ConfigDataTF");
            this.data.storage.writeToNBT(config);
            nbt.func_74782_a("ConfigDataTF", (NBTBase)config);
        }
    }

    @Override
    public float receiveEnergy(float amount, boolean simulate) {
        return this.data.storage.add(amount, simulate);
    }

    @Override
    public float extractEnergy(float amount, boolean simulate) {
        return this.data.storage.remove(amount, simulate);
    }

    @Override
    public float getEnergy() {
        return this.data.storage.getEnergy();
    }

    @Override
    public float getMaxEnergy() {
        return this.data.storage.getMaxEnergy();
    }

    @Override
    public float getEnergyUsage() {
        return this.data.storage.getUsage();
    }

    @Override
    public ReceiverHandler getReceiverHandler() {
        return this.receiverHandler;
    }

    @Override
    public boolean canReceiveEnergy(TileEntity from) {
        return true;
    }

    @Override
    public Vec3 getEnergyInputOffset() {
        return Vec3.func_72443_a((double)0.0, (double)0.5, (double)0.0);
    }

    @Override
    public int getMapColor() {
        return 0xFF0000;
    }

    @Override
    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack itemstack;
        if (slot == 3 && (itemstack = this.func_70301_a(slot)) != null) {
            int toRemove = Math.min(itemstack.field_77994_a, amount);
            int i = Math.min(this.alloyResults, toRemove);
            this.alloyResults -= i;
            this.furnaceResults -= Math.min(this.furnaceResults, toRemove -= i);
        }
        return super.func_70298_a(slot, amount);
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return slot != 3;
    }

    public int[] func_94128_d(int side) {
        return side == 0 ? slotsBottom : slotsSides;
    }

    public boolean func_102007_a(int slot, ItemStack itemstack, int side) {
        return this.func_94041_b(slot, itemstack);
    }

    public boolean func_102008_b(int slot, ItemStack itemstack, int side) {
        return slot == 3;
    }

    @Override
    public void receive(EntityPlayer player, int action) {
        super.receive(player, action);
        if (action == 0) {
            this.smeltingMode = EnumSmeltingMode.values()[(this.smeltingMode.ordinal() + 1) % EnumSmeltingMode.values().length];
        }
        this.func_70296_d();
    }

    public static enum EnumSmeltingMode {
        ALLOY,
        FURNACE,
        BOTH;

    }
}

