/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.common.tick;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import fiskfille.tf.TFReflection;
import fiskfille.tf.client.keybinds.TFKeyBinds;
import fiskfille.tf.client.render.entity.EntityRendererTF;
import fiskfille.tf.client.tutorial.TutorialHandler;
import fiskfille.tf.common.data.TFData;
import fiskfille.tf.common.data.tile.TileData;
import fiskfille.tf.common.proxy.ClientProxy;
import fiskfille.tf.common.transformer.base.Transformer;
import fiskfille.tf.config.TFConfig;
import fiskfille.tf.helper.TFHelper;
import fiskfille.tf.helper.TFRenderHelper;
import fiskfille.tf.helper.TFTileHelper;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.stats.StatFileWriter;
import net.minecraft.util.MovementInputFromOptions;
import net.minecraft.world.World;

public class ClientTickHandler {
    private Minecraft mc = Minecraft.func_71410_x();
    private EntityRenderer renderer;
    private EntityRenderer prevRenderer;
    public static float renderTick;

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        Transformer transformer = TFHelper.getTransformer((EntityLivingBase)player);
        int altMode = TFData.ALT_MODE.get(player);
        float transformationTimer = TFHelper.getTransformationTimer(player);
        TFHelper.getStealthModeTimer(player);
        if (event.phase == TickEvent.Phase.END) {
            TutorialHandler.tick(player);
            if (transformer != null) {
                if (transformationTimer >= 0.5f) {
                    transformer.updateMovement(player, altMode);
                    if (TFData.BOOSTING.get(player).booleanValue() && TFData.NITRO.get(player).floatValue() > 0.0f && TFHelper.isFullyTransformed(player)) {
                        transformer.doNitroParticles(player, altMode);
                    }
                }
                if (player == this.mc.field_71439_g && transformer.overrideFirstPerson(player, altMode)) {
                    GameSettings gameSettings = this.mc.field_71474_y;
                    if (transformationTimer >= 0.5f) {
                        gameSettings.field_74320_O = TFKeyBinds.keyBindingViewFront.func_151470_d() && this.mc.field_71462_r == null ? 2 : (TFKeyBinds.keyBindingVehicleFirstPerson.func_151470_d() ? 0 : 1);
                    }
                    boolean useNitro = false;
                    if (transformationTimer >= 0.5f && transformer.canUseNitro(player, altMode)) {
                        useNitro = gameSettings.field_74351_w.func_151470_d() && gameSettings.field_151444_V.func_151470_d();
                    }
                    TFData.BOOSTING.set(player, useNitro);
                    if (TFData.TRANSFORM_PROGRESS.get(player).floatValue() == 0.0f && TFData.PREV_TRANSFORM_PROGRESS.get(player).floatValue() > 0.0f && TFConfig.firstPersonAfterTransformation) {
                        gameSettings.field_74320_O = 0;
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START && this.mc.field_71441_e != null) {
            for (EntityPlayer entityPlayer : this.mc.field_71441_e.field_73010_i) {
                TFRenderHelper.updateMotionY(entityPlayer);
            }
            if (this.mc.field_71441_e.field_72995_K && !this.mc.func_147113_T()) {
                for (Map.Entry entry : TFTileHelper.getTileData().entrySet()) {
                    ((TileData)entry.getValue()).clientTick();
                }
            }
            if (ClientProxy.fakePlayer == null || ClientProxy.fakePlayer.field_70170_p != this.mc.field_71441_e) {
                if (this.mc.field_71442_b != null) {
                    ClientProxy.fakePlayer = this.mc.field_71442_b.func_147493_a((World)this.mc.field_71441_e, new StatFileWriter());
                    ClientProxy.fakePlayer.field_71158_b = new MovementInputFromOptions(this.mc.field_71474_y);
                }
            } else {
                ++ClientProxy.fakePlayer.field_70173_aa;
            }
        }
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        WorldClient world = this.mc.field_71441_e;
        renderTick = event.renderTickTime;
        if (world != null) {
            EntityClientPlayerMP player;
            if (event.phase == TickEvent.Phase.START) {
                player = this.mc.field_71439_g;
                if (TFRenderHelper.shouldOverrideView((EntityPlayer)player)) {
                    if (this.renderer == null) {
                        this.renderer = new EntityRendererTF(this.mc);
                    }
                    if (this.mc.field_71460_t != this.renderer) {
                        this.prevRenderer = this.mc.field_71460_t;
                        this.mc.field_71460_t = this.renderer;
                    }
                } else if (this.prevRenderer != null && this.mc.field_71460_t == this.renderer) {
                    this.mc.field_71460_t = this.prevRenderer;
                }
            }
            if (this.mc.field_71439_g != null) {
                player = this.mc.field_71439_g;
                Transformer transformer = TFHelper.getTransformer((EntityLivingBase)player);
                if (TFRenderHelper.shouldOverrideThirdPersonDistance((EntityPlayer)player) && transformer != null) {
                    float thirdPersonDistance = 4.0f - TFHelper.getTransformationTimer((EntityPlayer)player) * 2.0f;
                    int altMode = TFData.ALT_MODE.get((EntityPlayer)player);
                    if (transformer != null && transformer.canZoom((EntityPlayer)player) && TFHelper.isFullyTransformed((EntityPlayer)player) && TFKeyBinds.keyBindingZoom.func_151470_d() && !TFKeyBinds.keyBindingViewFront.func_151470_d()) {
                        thirdPersonDistance = transformer.getZoomAmount((EntityPlayer)player, altMode);
                    } else if (transformer != null) {
                        thirdPersonDistance = transformer.getThirdPersonDistance((EntityPlayer)player, altMode);
                    }
                    TFReflection.setField(TFReflection.thirdPersonDistanceField, this.mc.field_71460_t, Float.valueOf(thirdPersonDistance));
                }
            }
        }
    }
}

