/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.common.recipe;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cpw.mods.fml.common.registry.GameRegistry;
import fiskfille.tf.TransformersAPI;
import fiskfille.tf.common.block.BlockDisplayPedestal;
import fiskfille.tf.common.block.TFBlocks;
import fiskfille.tf.common.groundbridge.DataCore;
import fiskfille.tf.common.item.TFItems;
import fiskfille.tf.common.item.TFSubItems;
import fiskfille.tf.common.recipe.AlloyRecipes;
import fiskfille.tf.common.recipe.AssemblyTable;
import fiskfille.tf.common.recipe.AssemblyTableCraftingManager;
import fiskfille.tf.common.recipe.Dyes;
import fiskfille.tf.common.recipe.PowerManager;
import fiskfille.tf.common.recipe.RecipeClearConfig;
import fiskfille.tf.common.recipe.RecipeDisplayItems;
import fiskfille.tf.common.transformer.base.Transformer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class TFRecipes {
    public static List<IRecipe> prevRecipes = Lists.newArrayList();
    public static List<ItemStack> prevFurnaceRecipes = Lists.newArrayList();
    public static List<IRecipe> tempRecipes = Lists.newArrayList();
    public static List<ItemStack> tempFurnaceRecipes = Lists.newArrayList();

    public static void register() {
        AssemblyTableCraftingManager.getInstance().getRecipeList().clear();
        TFRecipes.restore();
        PowerManager.register();
        AlloyRecipes.register();
        TFRecipes.addSmelting();
        TFRecipes.addDisplayRecipes();
        TFRecipes.addDyeRecipes();
        TFRecipes.addWeaponRecipes();
        TFRecipes.addCraftingComponentRecipes();
        TFRecipes.addProjectileRecipes();
        TFRecipes.addArmorRecipes();
        GameRegistry.addRecipe((IRecipe)new RecipeClearConfig());
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(TFBlocks.transformiumSeed, 1), new Object[]{"TET", "TNT", "DND", Character.valueOf('T'), "blockTransformium", Character.valueOf('E'), "blockEnergonBlue", Character.valueOf('N'), Items.field_151156_bN, Character.valueOf('D'), "blockDiamond"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(TFBlocks.assemblyTable, 1), new Object[]{"EEE", "WCW", "IBI", Character.valueOf('E'), "dustEnergon", Character.valueOf('W'), TFSubItems.crude_alloy_wire[1], Character.valueOf('C'), Blocks.field_150462_ai, Character.valueOf('I'), "ingotIron", Character.valueOf('B'), "blockIron"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(TFBlocks.alloyCrucible, 1), new Object[]{"IFI", "IUI", "IRI", Character.valueOf('I'), "ingotIron", Character.valueOf('F'), Blocks.field_150460_al, Character.valueOf('U'), Items.field_151066_bu, Character.valueOf('R'), "dustRedstone"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(TFBlocks.energonProcessor, 1), new Object[]{" I ", "2W2", "BFB", Character.valueOf('I'), "ingotIron", Character.valueOf('2'), TFSubItems.improved_circuit[1], Character.valueOf('W'), TFSubItems.refined_alloy_wire[1], Character.valueOf('B'), "blockIron", Character.valueOf('F'), TFItems.fuelCanister}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(TFBlocks.energonFluidTank, 1), new Object[]{"IGI", "GFG", "IGI", Character.valueOf('I'), "ingotIron", Character.valueOf('G'), "paneGlass", Character.valueOf('F'), TFItems.fuelCanister}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(TFBlocks.transmitter, 1), new Object[]{"EOE", "PRP", "S2S", Character.valueOf('E'), "dustEnergon", Character.valueOf('O'), TFSubItems.transmission_orb[1], Character.valueOf('P'), TFSubItems.iron_pole[1], Character.valueOf('R'), TFBlocks.relayTower, Character.valueOf('S'), TFSubItems.superconductor[1], Character.valueOf('2'), TFSubItems.improved_circuit[1]}));
        GameRegistry.addRecipe((ItemStack)new ItemStack(TFBlocks.relayTower, 1), (Object[])new Object[]{" R ", " W ", "PSP", Character.valueOf('R'), TFBlocks.relayTorch, Character.valueOf('W'), TFSubItems.crude_alloy_wire[1], Character.valueOf('P'), TFSubItems.iron_pole[1], Character.valueOf('S'), TFSubItems.iron_support[1]});
        GameRegistry.addRecipe((ItemStack)new ItemStack(TFBlocks.relayTorch, 2), (Object[])new Object[]{"O", "1", "W", Character.valueOf('O'), TFSubItems.transmission_orb[1], Character.valueOf('1'), TFSubItems.basic_circuit[1], Character.valueOf('W'), TFSubItems.refined_alloy_wire[1]});
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(TFBlocks.energyColumn, 1), new Object[]{"LCL", "EPE", "IBI", Character.valueOf('L'), TFSubItems.canister_lid[1], Character.valueOf('C'), TFSubItems.energy_converter[1], Character.valueOf('E'), "ingotEnergonAlloy", Character.valueOf('P'), TFSubItems.lcd_panel[1], Character.valueOf('I'), "ingotIron", Character.valueOf('B'), "blockIron"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(TFBlocks.energyPort, 1), new Object[]{"IEI", "ECE", "IEI", Character.valueOf('I'), "ingotIron", Character.valueOf('E'), "ingotEnergonAlloy", Character.valueOf('C'), TFSubItems.energon_coil[1]}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(TFBlocks.isoCondenser, 1), new Object[]{"III", "RER", "ISI", Character.valueOf('I'), "ingotIron", Character.valueOf('R'), "dustRedstone", Character.valueOf('E'), "blockEnergonBlue", Character.valueOf('S'), TFSubItems.iron_support[1]}));
        AssemblyTable.addRecipe(new ItemStack(TFBlocks.groundBridgeFrame, 1), new Dyes(new int[0]), "     ", " SES ", " E1E ", " SES ", "     ", Character.valueOf('S'), TFSubItems.iron_support, Character.valueOf('E'), TFItems.energonDust, Character.valueOf('1'), TFSubItems.basic_circuit);
        AssemblyTable.addRecipe(new ItemStack(TFBlocks.groundBridgeControlPanel, 1), new Dyes(new int[0]), " PPP ", "IW3WI", "SCOCS", "FF3FF", "     ", Character.valueOf('P'), TFSubItems.lcd_panel, Character.valueOf('I'), Items.field_151042_j, Character.valueOf('W'), TFSubItems.refined_alloy_wire, Character.valueOf('3'), TFSubItems.advanced_circuit, Character.valueOf('S'), TFSubItems.iron_support, Character.valueOf('C'), TFSubItems.energy_converter, Character.valueOf('O'), TFSubItems.singularity, Character.valueOf('F'), TFBlocks.groundBridgeFrame);
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(TFItems.transformiumDetector, 1), new Object[]{"IEI", "TRT", "rrr", Character.valueOf('I'), "ingotIron", Character.valueOf('E'), TFBlocks.energonCrystal, Character.valueOf('T'), "transformium", Character.valueOf('R'), "blockRedstone", Character.valueOf('r'), "dustRedstone"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(TFItems.csd, 1), new Object[]{"I", "1", "I", Character.valueOf('I'), "ingotIron", Character.valueOf('1'), TFSubItems.basic_circuit[1]}));
        GameRegistry.addRecipe((ItemStack)new ItemStack(TFItems.fuelCanister, 1), (Object[])new Object[]{"L", "B", "L", Character.valueOf('L'), TFSubItems.canister_lid[1], Character.valueOf('B'), Items.field_151133_ar});
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(TFItems.powerCanister, 1), new Object[]{"L", "G", "L", Character.valueOf('L'), TFSubItems.canister_lid[1], Character.valueOf('G'), "blockGlass"}));
        AssemblyTable.addRecipe(new ItemStack(TFItems.dataCore, 1, DataCore.spaceBridge.index), new Dyes(new int[0]), "     ", " F3F ", " EOE ", " F3F ", "     ", Character.valueOf('F'), new ItemStack(TFItems.dataCore, 1, DataCore.range.index), Character.valueOf('3'), TFSubItems.advanced_circuit, Character.valueOf('E'), TFItems.energonDust, Character.valueOf('O'), TFSubItems.singularity);
        AssemblyTable.addRecipe(new ItemStack(TFItems.dataCore, 1, DataCore.leveler.index), new Dyes(new int[0]), "     ", " F2F ", " EOE ", " F2F ", "     ", Character.valueOf('F'), TFBlocks.groundBridgeFrame, Character.valueOf('2'), TFSubItems.improved_circuit, Character.valueOf('E'), TFItems.energonDust, Character.valueOf('O'), Items.field_151132_bS);
        AssemblyTable.addRecipe(new ItemStack(TFItems.dataCore, 1, DataCore.range.index), new Dyes(new int[0]), "     ", " F2F ", " EOE ", " F2F ", "     ", Character.valueOf('F'), TFBlocks.groundBridgeFrame, Character.valueOf('2'), TFSubItems.improved_circuit, Character.valueOf('E'), TFItems.energonDust, Character.valueOf('O'), Items.field_151079_bi);
        AssemblyTable.addRecipe(new ItemStack(TFItems.groundBridgeRemote, 1), new Dyes(new int[0]), " PPP ", " QRQ ", " 3W3 ", " III ", "     ", Character.valueOf('P'), TFSubItems.lcd_panel, Character.valueOf('Q'), Items.field_151128_bU, Character.valueOf('R'), Items.field_151137_ax, Character.valueOf('3'), TFSubItems.advanced_circuit, Character.valueOf('W'), TFSubItems.refined_alloy_wire, Character.valueOf('I'), Items.field_151042_j);
        String[] materials = new String[]{"ingotGold", "gemDiamond", "gemEmerald"};
        for (int i = 0; i < materials.length; ++i) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(TFItems.powerCanister, 1, i + 1), new Object[]{"**", "##", "**", Character.valueOf('*'), materials[i], Character.valueOf('#'), new ItemStack(TFItems.powerCanister, 1, i)}));
        }
        TFRecipes.addMaterialCompression(TFItems.energonCrystalShard, "blockEnergonBlue");
        TFRecipes.addMaterialCompression(TFItems.redEnergonCrystalShard, "blockEnergonRed");
        TFRecipes.addMaterialCompression("transformium", "blockTransformium");
        TFRecipes.addMaterialCompression("nuggetTransformiumAlloy", "ingotTransformiumAlloy", "blockTransformiumAlloy");
        TFRecipes.addMaterialCompression("nuggetFluxAlloyCrude", "ingotFluxAlloyCrude", "blockFluxAlloyCrude");
        TFRecipes.addMaterialCompression("nuggetFluxAlloyRefined", "ingotFluxAlloyRefined", "blockFluxAlloyRefined");
        TFRecipes.addMaterialCompression("nuggetEnergonAlloy", "ingotEnergonAlloy", "blockEnergonAlloy");
        TFRecipes.save();
    }

    public static void save() {
        List recipes = CraftingManager.func_77594_a().func_77592_b();
        for (int i = 0; i < recipes.size(); ++i) {
            IRecipe recipe = (IRecipe)recipes.get(i);
            if (prevRecipes.contains(recipe)) continue;
            tempRecipes.add(recipe);
        }
        for (ItemStack itemstack : FurnaceRecipes.func_77602_a().func_77599_b().keySet()) {
            if (prevFurnaceRecipes.contains(itemstack)) continue;
            tempFurnaceRecipes.add(itemstack);
        }
    }

    public static void restore() {
        HashMap map = Maps.newHashMap();
        for (Map.Entry e : FurnaceRecipes.func_77602_a().func_77599_b().entrySet()) {
            if (tempFurnaceRecipes.contains(e.getKey())) continue;
            map.put(e.getKey(), e.getValue());
        }
        CraftingManager.func_77594_a().func_77592_b().removeAll(tempRecipes);
        FurnaceRecipes.func_77602_a().func_77599_b().clear();
        FurnaceRecipes.func_77602_a().func_77599_b().putAll(map);
        tempRecipes.clear();
        tempFurnaceRecipes.clear();
        prevRecipes = Lists.newArrayList((Iterable)CraftingManager.func_77594_a().func_77592_b());
        prevFurnaceRecipes = Lists.newArrayList(FurnaceRecipes.func_77602_a().func_77599_b().keySet());
    }

    private static void addSmelting() {
        GameRegistry.addSmelting((Block)TFBlocks.transformiumOre, (ItemStack)new ItemStack(TFItems.transformiumFragment, 1), (float)1.0f);
        GameRegistry.addSmelting((Block)TFBlocks.energonOre, (ItemStack)new ItemStack(TFItems.energonDust, 1), (float)0.7f);
    }

    private static void addWeaponRecipes() {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(TFItems.skystrikesCrossbow, 1), new Object[]{"EII", "ITC", "ICT", Character.valueOf('E'), TFBlocks.energonCrystal, Character.valueOf('I'), "ingotIron", Character.valueOf('T'), "transformium", Character.valueOf('C'), TFItems.energonCrystalShard}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(TFItems.purgesKatana, 1), new Object[]{"CtC", "TET", "CIC", Character.valueOf('E'), TFBlocks.energonCrystal, Character.valueOf('I'), "ingotIron", Character.valueOf('T'), "transformium", Character.valueOf('C'), TFItems.energonCrystalShard, Character.valueOf('t'), TFSubItems.tank_track[1]}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(TFItems.vurpsSniper, 1), new Object[]{"EI ", "CTG", "CIT", Character.valueOf('E'), TFBlocks.energonCrystal, Character.valueOf('I'), "ingotIron", Character.valueOf('T'), "transformium", Character.valueOf('C'), TFItems.energonCrystalShard, Character.valueOf('G'), new ItemStack((Block)Blocks.field_150399_cn, 1, 5)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(TFItems.subwoofersBassBlaster, 1), new Object[]{"TIC", " EB", "TIC", Character.valueOf('E'), TFBlocks.energonCrystal, Character.valueOf('I'), "ingotIron", Character.valueOf('T'), "transformium", Character.valueOf('C'), TFItems.energonCrystalShard, Character.valueOf('B'), "blockIron"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(TFItems.cloudtrapsFlamethrower, 1), new Object[]{"CT ", "BET", " IC", Character.valueOf('E'), TFBlocks.energonCrystal, Character.valueOf('I'), "ingotIron", Character.valueOf('T'), "transformium", Character.valueOf('C'), TFItems.energonCrystalShard, Character.valueOf('B'), "blockIron"}));
    }

    private static void addCraftingComponentRecipes() {
        GameRegistry.addRecipe((ItemStack)TFSubItems.iron_pole[1], (Object[])new Object[]{"#", "#", Character.valueOf('#'), Blocks.field_150411_aY});
        GameRegistry.addRecipe((ItemStack)TFSubItems.iron_support[1], (Object[])new Object[]{"P P", " P ", "P P", Character.valueOf('P'), TFSubItems.iron_pole[1]});
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(TFSubItems.canister_lid[2], new Object[]{" I ", "I#I", Character.valueOf('I'), "ingotIron", Character.valueOf('#'), Blocks.field_150411_aY}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(TFSubItems.lcd_panel[3], new Object[]{"G1G", "P#P", "RWR", Character.valueOf('G'), "dustGlowstone", Character.valueOf('1'), TFSubItems.basic_circuit[1], Character.valueOf('P'), TFSubItems.iron_pole[1], Character.valueOf('#'), "paneGlass", Character.valueOf('R'), "dustRedstone", Character.valueOf('W'), TFSubItems.crude_alloy_wire[1]}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(TFSubItems.crude_alloy_wire[3], new Object[]{" C ", " W ", "C C", Character.valueOf('C'), "ingotFluxAlloyCrude", Character.valueOf('W'), "plankWood"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(TFSubItems.refined_alloy_wire[3], new Object[]{" R ", " W ", "R R", Character.valueOf('R'), "ingotFluxAlloyRefined", Character.valueOf('W'), "plankWood"}));
        GameRegistry.addRecipe((ItemStack)TFSubItems.energon_coil[3], (Object[])new Object[]{" W ", "W W", " W ", Character.valueOf('W'), TFSubItems.crude_alloy_wire[1]});
        GameRegistry.addRecipe((ItemStack)TFSubItems.transmission_orb[5], (Object[])new Object[]{"C", "F", "C", Character.valueOf('C'), TFSubItems.energon_coil[1], Character.valueOf('F'), TFSubItems.focusing_crystal[1]});
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(TFSubItems.energy_converter[1], new Object[]{"RTR", "E2E", "RTR", Character.valueOf('R'), "dustRedstone", Character.valueOf('T'), "ingotTransformiumAlloy", Character.valueOf('E'), "dustEnergon", Character.valueOf('2'), TFSubItems.improved_circuit[1]}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(TFSubItems.superconductor[1], new Object[]{"WPW", "RPR", "WPW", Character.valueOf('W'), TFSubItems.refined_alloy_wire[1], Character.valueOf('P'), TFSubItems.iron_pole[1], Character.valueOf('R'), "dustRedstone"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(TFSubItems.singularity[1], new Object[]{"DED", "SNS", "DED", Character.valueOf('D'), "gemDiamond", Character.valueOf('E'), Items.field_151079_bi, Character.valueOf('S'), TFSubItems.superconductor[1], Character.valueOf('N'), Items.field_151156_bN}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(TFSubItems.basic_circuit[1], new Object[]{"RRR", "CCR", "RWI", Character.valueOf('R'), "dustRedstone", Character.valueOf('C'), "ingotFluxAlloyCrude", Character.valueOf('W'), TFSubItems.crude_alloy_wire[1], Character.valueOf('I'), "ingotIron"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(TFSubItems.improved_circuit[1], new Object[]{"EEE", "1F1", "EWG", Character.valueOf('E'), "ingotEnergonAlloy", Character.valueOf('1'), TFSubItems.basic_circuit[1], Character.valueOf('F'), TFSubItems.focusing_crystal[1], Character.valueOf('W'), TFSubItems.refined_alloy_wire[1], Character.valueOf('G'), "ingotGold"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(TFSubItems.advanced_circuit[1], new Object[]{"EEE", "2R2", "EWT", Character.valueOf('E'), "ingotEnergonAlloy", Character.valueOf('2'), TFSubItems.improved_circuit[1], Character.valueOf('R'), "ingotFluxAlloyRefined", Character.valueOf('W'), TFSubItems.refined_alloy_wire[1], Character.valueOf('T'), "ingotTransformiumAlloy"}));
        AssemblyTable.addRecipe(TFSubItems.optic_sensor, new Dyes(new int[0]), "     ", " DT  ", " TT  ", "   R ", "     ", Character.valueOf('D'), Items.field_151045_i, Character.valueOf('T'), TFItems.transformiumAlloyNugget, Character.valueOf('R'), Items.field_151137_ax);
        AssemblyTable.addRecipe(TFSubItems.protoform_head, new Dyes(8, 3), "     ", " TTT ", " OTO ", " TRT ", "  T  ", Character.valueOf('T'), TFItems.transformiumAlloy, Character.valueOf('O'), TFSubItems.optic_sensor, Character.valueOf('R'), Items.field_151137_ax);
        AssemblyTable.addRecipe(TFSubItems.wheel, new Dyes(0, 3), "     ", " LLL ", " LIL ", " LLL ", "     ", Character.valueOf('L'), Items.field_151116_aA, Character.valueOf('I'), Items.field_151042_j);
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(TFSubItems.transformium_alloy_rod[1], new Object[]{"T", "T", "T", Character.valueOf('T'), "ingotTransformiumAlloy"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(TFSubItems.standard_engine[1], new Object[]{"PRP", "BIB", Character.valueOf('P'), Blocks.field_150331_J, Character.valueOf('R'), "dustRedstone", Character.valueOf('I'), "ingotIron", Character.valueOf('B'), "blockIron"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(TFSubItems.jet_thruster[1], new Object[]{"IIB", "xRJ", "IIB", Character.valueOf('I'), "ingotIron", Character.valueOf('B'), "blockIron", Character.valueOf('J'), Blocks.field_150411_aY, Character.valueOf('R'), "dustRedstone", Character.valueOf('x'), "blockRedstone"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(TFSubItems.small_thruster[1], new Object[]{"III", " JR", "III", Character.valueOf('I'), "ingotIron", Character.valueOf('J'), Blocks.field_150411_aY, Character.valueOf('R'), "dustRedstone"}));
        AssemblyTable.addRecipe(TFSubItems.skystrikes_wing, new Dyes(8, 5, 18, 1), "     ", " TTT ", " TTT ", "  TT ", "     ", Character.valueOf('T'), TFItems.transformiumAlloy);
        AssemblyTable.addRecipe(TFSubItems.skystrikes_shoulder_pad, new Dyes(8, 3), "     ", " TTT ", "    T", "     ", "     ", Character.valueOf('T'), TFItems.transformiumAlloy);
        AssemblyTable.addRecipe(TFSubItems.skystrikes_gauntlet, new Dyes(8, 2, 15, 2, 1, 1), "   T ", "  TT ", "  TT ", "  T  ", "     ", Character.valueOf('T'), TFItems.transformiumAlloy);
        AssemblyTable.addRecipe(TFSubItems.skystrike_torso_base, new Dyes(15, 7, 1, 6, 8, 1), "     ", "TTTTT", " TTT ", "  T  ", " TTT ", Character.valueOf('T'), TFItems.transformiumAlloy);
        AssemblyTable.addRecipe(TFSubItems.skystrikes_greave, new Dyes(8, 3, 15, 2, 18, 1), "  T  ", "  TT ", "  TT ", "  TT ", "     ", Character.valueOf('T'), TFItems.transformiumAlloy);
        AssemblyTable.addRecipe(TFSubItems.tank_turret_base, new Dyes(17, 2), "     ", "     ", " IBI ", "     ", "     ", Character.valueOf('I'), Items.field_151042_j, Character.valueOf('B'), Blocks.field_150339_S);
        AssemblyTable.addRecipe(TFSubItems.tank_barrel, new Dyes(17, 1), "     ", "     ", " III ", "     ", "     ", Character.valueOf('I'), Items.field_151042_j);
        AssemblyTable.addRecipe(TFSubItems.tank_turret, new Dyes(new int[0]), "     ", "     ", " BT  ", "     ", "     ", Character.valueOf('B'), TFSubItems.tank_barrel, Character.valueOf('T'), TFSubItems.tank_turret_base);
        AssemblyTable.addRecipe(TFSubItems.tank_track, new Dyes(8, 5, 17, 2, 16, 1), "     ", "LLLLL", "LIIIL", " LLL ", "     ", Character.valueOf('L'), Items.field_151116_aA, Character.valueOf('I'), Items.field_151042_j);
        AssemblyTable.addRecipe(TFSubItems.purges_pauldron, new Dyes(17, 3, 5, 1), "     ", " TTT ", "   T ", "   T ", "     ", Character.valueOf('T'), TFItems.transformiumAlloy);
        AssemblyTable.addRecipe(TFSubItems.purges_gauntlet, new Dyes(17, 2, 16, 1), "   T ", "  TT ", "  TT ", "  T  ", "     ", Character.valueOf('T'), TFItems.transformiumAlloy);
        AssemblyTable.addRecipe(TFSubItems.purge_torso_base, new Dyes(17, 9, 16, 4, 18, 1), "     ", "TTTTT", " TTT ", "  T  ", " TTT ", Character.valueOf('T'), TFItems.transformiumAlloy);
        AssemblyTable.addRecipe(TFSubItems.purges_greave, new Dyes(17, 4, 16, 2), "  T  ", "  TT ", "  TT ", "  TT ", "     ", Character.valueOf('T'), TFItems.transformiumAlloy);
        AssemblyTable.addRecipe(TFSubItems.vurps_shoulder_pad, new Dyes(7, 2, 5, 1), "     ", "  TT ", "  TT ", "     ", "     ", Character.valueOf('T'), TFItems.transformiumAlloy);
        AssemblyTable.addRecipe(TFSubItems.vurps_gauntlet, new Dyes(7, 2, 8, 1), "   T ", "  TG ", "  TG ", "  T  ", "     ", Character.valueOf('T'), TFItems.transformiumAlloy, Character.valueOf('G'), Dyes.dye(Blocks.field_150397_co, 0));
        AssemblyTable.addRecipe(TFSubItems.vurp_torso_base, new Dyes(7, 12, 0, 1, 19, 1), "     ", "TTTTT", " TTT ", "  T  ", " TTT ", Character.valueOf('T'), TFItems.transformiumAlloy);
        AssemblyTable.addRecipe(TFSubItems.vurps_greave, new Dyes(7, 4, 18, 1), "  T  ", "  TTW", "  TT ", "  TT ", "     ", Character.valueOf('T'), TFItems.transformiumAlloy, Character.valueOf('W'), TFSubItems.wheel);
        AssemblyTable.addRecipe(TFSubItems.vurps_facemask, new Dyes(new int[0]), "     ", " GGG ", " GGG ", " GGG ", "     ", Character.valueOf('G'), Dyes.dye(Blocks.field_150397_co, 10));
        AssemblyTable.addRecipe(TFSubItems.subwoofers_shoulder_pad, new Dyes(4, 2, 18, 1), "     ", "  TT ", "  TT ", "     ", "     ", Character.valueOf('T'), TFItems.transformiumAlloy);
        AssemblyTable.addRecipe(TFSubItems.subwoofers_gauntlet, new Dyes(4, 2, 11, 1, 8, 1), "   T ", "  TT ", "  TT ", "  T  ", "     ", Character.valueOf('T'), TFItems.transformiumAlloy);
        AssemblyTable.addRecipe(TFSubItems.subwoofer_torso_base, new Dyes(4, 11, 11, 1, 7, 1), "     ", "TTGTT", " WTW ", "  T  ", " TTT ", Character.valueOf('T'), TFItems.transformiumAlloy, Character.valueOf('W'), TFSubItems.wheel, Character.valueOf('G'), Dyes.dye(Blocks.field_150399_cn, 12));
        AssemblyTable.addRecipe(TFSubItems.subwoofers_greave, new Dyes(4, 4, 11, 1), "  T  ", "  TT ", "  TT ", "  TT ", "     ", Character.valueOf('T'), TFItems.transformiumAlloy);
        AssemblyTable.addRecipe(TFSubItems.subwoofers_visor, new Dyes(new int[0]), "     ", "     ", " GGG ", "     ", "     ", Character.valueOf('G'), Dyes.dye(Blocks.field_150397_co, 12));
        AssemblyTable.addRecipe(TFSubItems.cloudtraps_wing, new Dyes(8, 4, 20, 2), " TTT ", "   TT", "  T T", " T  T", "     ", Character.valueOf('T'), TFItems.transformiumAlloy);
        AssemblyTable.addRecipe(TFSubItems.cloudtraps_pauldron, new Dyes(8, 2, 18, 1), "     ", " TTT ", "  TT ", "     ", "     ", Character.valueOf('T'), TFItems.transformiumAlloy);
        AssemblyTable.addRecipe(TFSubItems.cloudtraps_gauntlet, new Dyes(8, 2, 20, 1, 18, 1), "   T ", "  TT ", "  TT ", "  T  ", "     ", Character.valueOf('T'), TFItems.transformiumAlloy);
        AssemblyTable.addRecipe(TFSubItems.cloudtrap_torso_base, new Dyes(8, 9, 20, 3, 5, 1), "     ", "TTTTT", " TGT ", "  T  ", " TTT ", Character.valueOf('T'), TFItems.transformiumAlloy, Character.valueOf('G'), Dyes.dye(Blocks.field_150399_cn, 10));
        AssemblyTable.addRecipe(TFSubItems.cloudtraps_greave, new Dyes(8, 4, 18, 1), "  T  ", "  TTT", "  TTE", "  TT ", "     ", Character.valueOf('T'), TFItems.transformiumAlloy, Character.valueOf('E'), TFSubItems.jet_thruster);
        AssemblyTable.addRecipe(TFSubItems.cloudtraps_visor, new Dyes(new int[0]), "     ", " G G ", " GGG ", "     ", "     ", Character.valueOf('G'), Dyes.dye(Blocks.field_150397_co, 10));
    }

    private static void addDisplayRecipes() {
        int i;
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(TFBlocks.displayStation, 1), new Object[]{" L ", " I ", "-I-", Character.valueOf('-'), "slabStone", Character.valueOf('I'), "ingotIron", Character.valueOf('L'), Blocks.field_150379_bu}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(TFItems.componentBase), new Object[]{"III", "ITI", "III", Character.valueOf('I'), "ingotIron", Character.valueOf('T'), "transformium"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(TFItems.colorComponent, new Object[]{"DDD", "DCD", "DDD", Character.valueOf('D'), "dye", Character.valueOf('C'), TFItems.componentBase}));
        GameRegistry.addRecipe((ItemStack)new ItemStack(TFItems.armorComponent), (Object[])new Object[]{" I ", "ICI", " I ", Character.valueOf('C'), TFItems.componentBase, Character.valueOf('I'), Items.field_151030_Z});
        GameRegistry.addRecipe((IRecipe)new RecipeDisplayItems());
        for (i = 0; i < BlockDisplayPedestal.getTextures().size(); ++i) {
            BlockDisplayPedestal.BlockIcon[] icons = BlockDisplayPedestal.getTexture(i);
            GameRegistry.addRecipe((ItemStack)new ItemStack(TFBlocks.displayPedestal, 2, i), (Object[])new Object[]{" T ", "BPB", Character.valueOf('T'), new ItemStack(icons[2].block, 1, icons[2].metadata), Character.valueOf('P'), new ItemStack(icons[1].block, 1, icons[1].metadata), Character.valueOf('B'), new ItemStack(icons[0].block, 1, icons[0].metadata)});
        }
        i = 0;
        for (Transformer transformer : TransformersAPI.getTransformers()) {
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(TFItems.displayVehicle, 1, i), (Object[])new Object[]{transformer.getHelmet(), transformer.getChestplate(), transformer.getLeggings(), transformer.getBoots()});
            ++i;
        }
    }

    private static void addDyeRecipes() {
        int id;
        int index;
        for (index = 16; index < Dyes.dyes.size(); ++index) {
            id = Dyes.dyes.get(index);
            GameRegistry.addShapelessRecipe((ItemStack)Dyes.dye(TFBlocks.wool, id), (Object[])new Object[]{Dyes.get(id, 1), Dyes.dye(Blocks.field_150325_L, 15)});
            GameRegistry.addRecipe((ItemStack)new ItemStack(TFBlocks.stainedHardenedClay, 8, id - 16), (Object[])new Object[]{"###", "#X#", "###", Character.valueOf('#'), Blocks.field_150405_ch, Character.valueOf('X'), Dyes.get(id)});
            GameRegistry.addRecipe((ItemStack)new ItemStack(TFBlocks.stainedGlass, 8, id - 16), (Object[])new Object[]{"###", "#X#", "###", Character.valueOf('#'), Blocks.field_150359_w, Character.valueOf('X'), Dyes.get(id)});
            GameRegistry.addRecipe((ItemStack)new ItemStack(TFBlocks.stainedGlassPane, 16, id - 16), (Object[])new Object[]{"###", "###", Character.valueOf('#'), Dyes.dye(TFBlocks.stainedGlass, id)});
        }
        GameRegistry.addShapelessRecipe((ItemStack)Dyes.get(16, 2), (Object[])new Object[]{Dyes.get(1), Dyes.get(0)});
        GameRegistry.addShapelessRecipe((ItemStack)Dyes.get(17, 2), (Object[])new Object[]{Dyes.get(3), Dyes.get(15)});
        GameRegistry.addShapelessRecipe((ItemStack)Dyes.get(18, 2), (Object[])new Object[]{Dyes.get(8), Dyes.get(0)});
        GameRegistry.addShapelessRecipe((ItemStack)Dyes.get(18, 3), (Object[])new Object[]{Dyes.get(15), Dyes.get(0), Dyes.get(0)});
        GameRegistry.addShapelessRecipe((ItemStack)Dyes.get(19, 2), (Object[])new Object[]{Dyes.get(10), Dyes.get(15)});
        GameRegistry.addShapelessRecipe((ItemStack)Dyes.get(20, 2), (Object[])new Object[]{Dyes.get(17), Dyes.get(8)});
        GameRegistry.addShapelessRecipe((ItemStack)Dyes.get(20, 3), (Object[])new Object[]{Dyes.get(3), Dyes.get(15), Dyes.get(8)});
        for (index = 16; index < Dyes.dyes.size(); ++index) {
            id = Dyes.dyes.get(index);
            GameRegistry.addRecipe((ItemStack)new ItemStack(TFBlocks.carpet, 3, id - 16), (Object[])new Object[]{"##", Character.valueOf('#'), Dyes.dye(TFBlocks.wool, id)});
        }
    }

    private static void addProjectileRecipes() {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(TFItems.missile, 4), new Object[]{"T  ", " I ", "  E", Character.valueOf('I'), "ingotIron", Character.valueOf('T'), Blocks.field_150335_W, Character.valueOf('E'), TFSubItems.small_thruster[1]}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(TFItems.tankShell, 4), new Object[]{"IIT", Character.valueOf('I'), "ingotIron", Character.valueOf('T'), Items.field_151016_H}));
    }

    private static void addArmorRecipes() {
        AssemblyTable.addRecipe(new ItemStack((Item)TFItems.skystrikeHelmet), new Dyes(8, 3, 15, 2, 1, 1), "     ", " TTT ", " THT ", "  T  ", "     ", Character.valueOf('T'), TFItems.transformiumAlloy, Character.valueOf('H'), TFSubItems.protoform_head);
        AssemblyTable.addRecipe(new ItemStack((Item)TFItems.skystrikeChestplate), new Dyes(new int[0]), "     ", " W W ", " SBS ", " G G ", "     ", Character.valueOf('W'), TFSubItems.skystrikes_wing, Character.valueOf('S'), TFSubItems.skystrikes_shoulder_pad, Character.valueOf('B'), TFSubItems.skystrike_torso_base, Character.valueOf('G'), TFSubItems.skystrikes_gauntlet);
        AssemblyTable.addRecipe(new ItemStack((Item)TFItems.skystrikeLeggings), new Dyes(15, 2, 8, 2), "     ", "     ", " R R ", " G G ", "     ", Character.valueOf('R'), TFSubItems.transformium_alloy_rod, Character.valueOf('G'), TFSubItems.skystrikes_greave);
        AssemblyTable.addRecipe(new ItemStack((Item)TFItems.skystrikeBoots), new Dyes(8, 2, 15, 2, 1, 2), "     ", "     ", "     ", " TTE ", "     ", Character.valueOf('T'), new ItemStack(TFItems.transformiumAlloy, 2), Character.valueOf('E'), TFSubItems.jet_thruster[2]);
        AssemblyTable.addRecipe(new ItemStack((Item)TFItems.purgeHelmet), new Dyes(18, 4), " GNG ", " TGT ", " THT ", " T T ", "     ", Character.valueOf('G'), Items.field_151043_k, Character.valueOf('N'), Items.field_151074_bl, Character.valueOf('T'), TFItems.transformiumAlloy, Character.valueOf('H'), TFSubItems.protoform_head);
        AssemblyTable.addRecipe(new ItemStack((Item)TFItems.purgeChestplate), new Dyes(new int[0]), "     ", " WOW ", " PBP ", " G G ", "     ", Character.valueOf('W'), TFSubItems.tank_track, Character.valueOf('O'), TFSubItems.tank_turret, Character.valueOf('P'), TFSubItems.purges_pauldron, Character.valueOf('B'), TFSubItems.purge_torso_base, Character.valueOf('G'), TFSubItems.purges_gauntlet);
        AssemblyTable.addRecipe(new ItemStack((Item)TFItems.purgeLeggings), new Dyes(18, 4), "     ", "     ", " R R ", " G G ", "     ", Character.valueOf('R'), TFSubItems.transformium_alloy_rod, Character.valueOf('G'), TFSubItems.purges_greave);
        AssemblyTable.addRecipe(new ItemStack((Item)TFItems.purgeBoots), new Dyes(0, 4, 7, 3), "     ", "     ", "     ", " TTT ", "     ", Character.valueOf('T'), new ItemStack(TFItems.transformiumAlloy, 2));
        AssemblyTable.addRecipe(new ItemStack((Item)TFItems.vurpHelmet), new Dyes(7, 4, 0, 1), "     ", " TTT ", " THT ", "  F  ", "     ", Character.valueOf('T'), TFItems.transformiumAlloy, Character.valueOf('H'), TFSubItems.protoform_head, Character.valueOf('F'), TFSubItems.vurps_facemask);
        AssemblyTable.addRecipe(new ItemStack((Item)TFItems.vurpChestplate), new Dyes(new int[0]), "     ", " W W ", " SBS ", " G G ", "     ", Character.valueOf('W'), TFSubItems.wheel, Character.valueOf('S'), TFSubItems.vurps_shoulder_pad, Character.valueOf('B'), TFSubItems.vurp_torso_base, Character.valueOf('G'), TFSubItems.vurps_gauntlet);
        AssemblyTable.addRecipe(new ItemStack((Item)TFItems.vurpLeggings), new Dyes(19, 4), "     ", "     ", " R R ", " G G ", "     ", Character.valueOf('R'), TFSubItems.transformium_alloy_rod, Character.valueOf('G'), TFSubItems.vurps_greave);
        AssemblyTable.addRecipe(new ItemStack((Item)TFItems.vurpBoots), new Dyes(0, 5), "     ", "     ", "     ", " TTT ", "     ", Character.valueOf('T'), new ItemStack(TFItems.transformiumAlloy, 2));
        AssemblyTable.addRecipe(new ItemStack((Item)TFItems.subwooferHelmet), new Dyes(4, 4, 11, 1, 7, 1), "     ", " TTT ", " THT ", "  V  ", "     ", Character.valueOf('T'), TFItems.transformiumAlloy, Character.valueOf('H'), TFSubItems.protoform_head, Character.valueOf('V'), TFSubItems.subwoofers_visor);
        AssemblyTable.addRecipe(new ItemStack((Item)TFItems.subwooferChestplate), new Dyes(new int[0]), "     ", "     ", " SBS ", " G G ", "     ", Character.valueOf('S'), TFSubItems.subwoofers_shoulder_pad, Character.valueOf('B'), TFSubItems.subwoofer_torso_base, Character.valueOf('G'), TFSubItems.subwoofers_gauntlet);
        AssemblyTable.addRecipe(new ItemStack((Item)TFItems.subwooferLeggings), new Dyes(7, 4), "     ", "     ", " R R ", " G G ", "     ", Character.valueOf('R'), TFSubItems.transformium_alloy_rod, Character.valueOf('G'), TFSubItems.subwoofers_greave);
        AssemblyTable.addRecipe(new ItemStack((Item)TFItems.subwooferBoots), new Dyes(7, 5), "     ", "     ", "     ", " TTW ", "     ", Character.valueOf('T'), new ItemStack(TFItems.transformiumAlloy, 2), Character.valueOf('W'), TFSubItems.wheel[2]);
        AssemblyTable.addRecipe(new ItemStack((Item)TFItems.cloudtrapHelmet), new Dyes(0, 3, 18, 2, 8, 1), "     ", " TTT ", " THT ", " BVB ", "     ", Character.valueOf('T'), TFItems.transformiumAlloy, Character.valueOf('H'), TFSubItems.protoform_head, Character.valueOf('V'), TFSubItems.cloudtraps_visor, Character.valueOf('B'), Blocks.field_150339_S);
        AssemblyTable.addRecipe(new ItemStack((Item)TFItems.cloudtrapChestplate), new Dyes(new int[0]), "     ", " W W ", " PBP ", " G G ", "     ", Character.valueOf('W'), TFSubItems.cloudtraps_wing, Character.valueOf('P'), TFSubItems.cloudtraps_pauldron, Character.valueOf('B'), TFSubItems.cloudtrap_torso_base, Character.valueOf('G'), TFSubItems.cloudtraps_gauntlet);
        AssemblyTable.addRecipe(new ItemStack((Item)TFItems.cloudtrapLeggings), new Dyes(8, 3, 20, 1), "     ", "     ", " R R ", " G G ", "     ", Character.valueOf('R'), TFSubItems.transformium_alloy_rod, Character.valueOf('G'), TFSubItems.cloudtraps_greave);
        AssemblyTable.addRecipe(new ItemStack((Item)TFItems.cloudtrapBoots), new Dyes(8, 3, 20, 2), "     ", "     ", "     ", " TTT ", "     ", Character.valueOf('T'), new ItemStack(TFItems.transformiumAlloy, 2));
    }

    private static void addMaterialCompression(Object ... args) {
        for (int i = 0; i < args.length; ++i) {
            Object nugget = null;
            Object ingot = args[i];
            Object block = null;
            if (i > 0) {
                nugget = args[i - 1];
            }
            if (i + 1 < args.length) {
                block = args[i + 1];
            }
            ItemStack result = null;
            if (ingot instanceof String) {
                if (!OreDictionary.doesOreNameExist((String)((String)ingot))) continue;
                result = (ItemStack)OreDictionary.getOres((String)((String)ingot)).get(0);
                if (result.func_77960_j() == Short.MAX_VALUE) {
                    result.func_77964_b(0);
                }
            } else {
                result = new ItemStack(ingot instanceof Item ? (Item)ingot : Item.func_150898_a((Block)((Block)ingot)));
            }
            if (nugget != null) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(result, new Object[]{"###", "###", "###", Character.valueOf('#'), nugget}));
            }
            if (block == null) continue;
            result = result.func_77946_l();
            result.field_77994_a = 9;
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(result, new Object[]{block}));
        }
    }
}

