/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.common.recipe;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class PowerManager {
    public static Map<ItemStack, Integer> powerSources = Maps.newHashMap();

    public static void register() {
        powerSources.clear();
        PowerManager.addPowerSource(Items.field_151137_ax, 0, 400);
        PowerManager.addPowerSource(Blocks.field_150451_bX, 0, 3600);
    }

    public static void addPowerSource(Item item, int metadata, int amount) {
        powerSources.put(new ItemStack(item, 1, metadata), amount);
    }

    public static void addPowerSource(Block block, int metadata, int amount) {
        powerSources.put(new ItemStack(block, 1, metadata), amount);
    }

    public static boolean isPowerSource(Item item, int metadata) {
        return PowerManager.getPowerSourceAmount(item, metadata) > 0;
    }

    public static boolean isPowerSource(ItemStack itemstack) {
        return itemstack != null && PowerManager.isPowerSource(itemstack.func_77973_b(), itemstack.func_77960_j());
    }

    public static int getPowerSourceAmount(Item item, int metadata) {
        for (Map.Entry<ItemStack, Integer> e : powerSources.entrySet()) {
            new ItemStack(item, 1, metadata);
            if (e.getKey().func_77973_b() != item || e.getKey().func_77960_j() != metadata) continue;
            return e.getValue();
        }
        return 0;
    }

    public static int getPowerSourceAmount(ItemStack itemstack) {
        return PowerManager.getPowerSourceAmount(itemstack.func_77973_b(), itemstack.func_77960_j());
    }
}

