/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.common.recipe;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cpw.mods.fml.common.Loader;
import fiskfille.tf.TFLog;
import fiskfille.tf.common.block.TFBlocks;
import fiskfille.tf.common.item.TFItems;
import fiskfille.tf.common.item.TFSubItems;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class AlloyRecipes {
    private static final AlloyRecipes instance = new AlloyRecipes();
    private Map<AlloyIngredients, ItemStack> smeltingMap = Maps.newHashMap();
    private Map<ItemStack, Integer> durationMap = Maps.newHashMap();
    private Map<ItemStack, Float> experienceMap = Maps.newHashMap();

    public static AlloyRecipes getInstance() {
        return instance;
    }

    public static void register() {
        AlloyRecipes.getInstance().smeltingMap.clear();
        AlloyRecipes.getInstance().durationMap.clear();
        AlloyRecipes.getInstance().experienceMap.clear();
        AlloyRecipes.getInstance().registerRecipes();
    }

    private void registerRecipes() {
        this.addRecipe(new AlloyIngredients("transformium", "ingotIron", "ingotIron"), new ItemStack(TFItems.transformiumAlloy, 2), 400, 1.0f);
        this.addRecipe(new AlloyIngredients(TFBlocks.transformiumStone, Blocks.field_150435_aG, "gemQuartz"), new ItemStack(TFItems.transformiumFragment), 600, 0.35f);
        this.addRecipe(new AlloyIngredients("ingotIron", "ingotGold", "dustRedstone"), new ItemStack(TFItems.crudeFluxAlloy), 0.4f);
        this.addRecipe(new AlloyIngredients("ingotFluxAlloyCrude", "ingotFluxAlloyCrude", "dustRedstone"), new ItemStack(TFItems.refinedFluxAlloy), 300, 0.6f);
        this.addRecipe(new AlloyIngredients("ingotIron", "dustEnergon"), new ItemStack(TFItems.energonAlloy), 800, 0.4f);
        this.addRecipe(new AlloyIngredients("dustEnergon", "transformium", "dustEnergon"), TFSubItems.focusing_crystal[1], 0.1f);
        this.addRecipe(new AlloyIngredients("dustEnergon", "dustEnergon", "dustEnergon"), new ItemStack(TFItems.energonCrystalShard), 100, 0.0f);
        this.addRecipe(new AlloyIngredients("stone", Items.field_151079_bi), new ItemStack(Blocks.field_150377_bs), 0.2f);
        this.addRecipe(new AlloyIngredients("blockGlass"), new ItemStack(Blocks.field_150359_w), 0.0f);
        this.addRecipe(new AlloyIngredients("paneGlass"), new ItemStack(Blocks.field_150410_aZ), 0.0f);
        this.addRecipe(new AlloyIngredients("blockClayHardened"), new ItemStack(Blocks.field_150405_ch), 0.0f);
    }

    public void addRecipe(AlloyIngredients alloy, ItemStack result, float xp) {
        this.addRecipe(alloy, result, 200, xp);
    }

    public void addRecipe(AlloyIngredients alloy, ItemStack result, int duration, float xp) {
        if (alloy == null || alloy.getIngredients()[0] == null) {
            TFLog.warn("Mod '%s' attempted to register unknown or empty AlloyIngredients for item %s!", Loader.instance().activeModContainer().getModId(), Item.field_150901_e.func_148750_c((Object)result.func_77973_b()));
            return;
        }
        this.smeltingMap.put(alloy, result);
        this.durationMap.put(result, duration);
        this.experienceMap.put(result, Float.valueOf(xp));
    }

    public ItemStack getSmeltingResult(AlloyIngredients ingredients) {
        ItemStack[] itemstacks = ingredients.getIngredients();
        return this.getSmeltingResult(itemstacks[0], itemstacks[1], itemstacks[2]);
    }

    public ItemStack getSmeltingResult(ItemStack input1, ItemStack input2, ItemStack input3) {
        Map.Entry<AlloyIngredients, ItemStack> entry;
        Iterator<Map.Entry<AlloyIngredients, ItemStack>> iterator = this.smeltingMap.entrySet().iterator();
        do {
            if (iterator.hasNext()) continue;
            return null;
        } while (!(entry = iterator.next()).getKey().matches(input1, input2, input3));
        return entry.getValue();
    }

    public static boolean matches(ItemStack itemstack, String oreDict) {
        ArrayList aliases = OreDictionary.getOres((String)oreDict);
        for (int i = 0; i < aliases.size(); ++i) {
            ItemStack itemstack1 = (ItemStack)aliases.get(i);
            if (!AlloyRecipes.matches(itemstack, itemstack1)) continue;
            return true;
        }
        return false;
    }

    public static boolean matches(ItemStack itemstack, ItemStack itemstack1) {
        return itemstack1.func_77973_b() == itemstack.func_77973_b() && (itemstack.func_77960_j() == Short.MAX_VALUE || itemstack1.func_77960_j() == Short.MAX_VALUE || itemstack1.func_77960_j() == itemstack.func_77960_j());
    }

    public Map getSmeltingList() {
        return this.smeltingMap;
    }

    public int getSmeltTime(ItemStack itemstack) {
        Map.Entry<ItemStack, Integer> entry;
        Iterator<Map.Entry<ItemStack, Integer>> iterator = this.durationMap.entrySet().iterator();
        do {
            if (iterator.hasNext()) continue;
            return 200;
        } while (!AlloyRecipes.matches(itemstack, (entry = iterator.next()).getKey()));
        return entry.getValue();
    }

    public float getXpYield(ItemStack itemstack) {
        Map.Entry<ItemStack, Float> entry;
        float xp = itemstack.func_77973_b().getSmeltingExperience(itemstack);
        if (xp != -1.0f) {
            return xp;
        }
        Iterator<Map.Entry<ItemStack, Float>> iterator = this.experienceMap.entrySet().iterator();
        do {
            if (iterator.hasNext()) continue;
            return 0.0f;
        } while (!AlloyRecipes.matches(itemstack, (entry = iterator.next()).getKey()));
        return entry.getValue().floatValue();
    }

    public static class AlloyIngredients {
        private final Map<Integer, List<String>> oreDictNames = Maps.newHashMap();
        private final ItemStack[] ingredients;

        public AlloyIngredients(Object ... objects) {
            LinkedList list = Lists.newLinkedList();
            for (int i = 0; i < objects.length; ++i) {
                List list1;
                Object obj = objects[i];
                if (obj instanceof List) {
                    list1 = (List)obj;
                    for (int j = 0; j < list1.size(); ++j) {
                        ArrayList list2 = OreDictionary.getOres((String)((String)list1.get(j)));
                        if (list2.isEmpty()) continue;
                        list.add(list2.get(0));
                        break;
                    }
                    this.oreDictNames.put(i, list1);
                    continue;
                }
                if (obj instanceof String) {
                    list1 = OreDictionary.getOres((String)((String)obj));
                    if (!list1.isEmpty()) {
                        list.add(list1.get(0));
                    }
                    this.oreDictNames.put(i, Arrays.asList((String)obj));
                    continue;
                }
                ItemStack itemstack = this.getItemStack(obj);
                if (itemstack == null) continue;
                list.add(itemstack);
            }
            this.ingredients = list.toArray(new ItemStack[3]);
        }

        public boolean matches(ItemStack input1, ItemStack input2, ItemStack input3) {
            ItemStack[] ingredients = new ItemStack[]{input1, input2, input3};
            for (int i = 0; i < this.getIngredients().length; ++i) {
                ItemStack itemstack = this.getIngredients()[i];
                if (itemstack == null && ingredients[i] == null) continue;
                if (itemstack == null || ingredients[i] == null) {
                    return false;
                }
                List<String> list = this.getOreDictNames(i);
                boolean oreDictMatch = false;
                for (int j = 0; j < list.size(); ++j) {
                    String oreDict = list.get(j);
                    if (!AlloyRecipes.matches(ingredients[i], oreDict)) continue;
                    oreDictMatch = true;
                    break;
                }
                if (oreDictMatch || AlloyRecipes.matches(itemstack, ingredients[i])) continue;
                return false;
            }
            return true;
        }

        private ItemStack getItemStack(Object obj) {
            if (obj instanceof ItemStack) {
                return (ItemStack)obj;
            }
            if (obj instanceof Item) {
                return new ItemStack((Item)obj, 1, Short.MAX_VALUE);
            }
            if (obj instanceof Block) {
                return new ItemStack((Block)obj, 1, Short.MAX_VALUE);
            }
            return null;
        }

        public ItemStack[] getIngredients() {
            return this.ingredients;
        }

        public List<String> getOreDictNames(int index) {
            return this.oreDictNames.get(index) != null ? this.oreDictNames.get(index) : new ArrayList<String>();
        }

        public String toString() {
            return String.format("Alloy{%s}", Arrays.asList(this.ingredients));
        }

        public boolean equals(Object obj) {
            if (obj instanceof AlloyIngredients) {
                AlloyIngredients alloy = (AlloyIngredients)obj;
                if (this.getIngredients().length == alloy.getIngredients().length) {
                    for (int i = 0; i < this.getIngredients().length; ++i) {
                        ItemStack itemstack = this.getIngredients()[i];
                        ItemStack itemstack1 = alloy.getIngredients()[i];
                        if (itemstack == null && itemstack1 == null) continue;
                        if (itemstack == null || itemstack1 == null) {
                            return false;
                        }
                        if (AlloyRecipes.matches(itemstack, itemstack1)) continue;
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }
    }
}

