/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.common.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import fiskfille.tf.TransformersMod;
import fiskfille.tf.common.item.ItemCSD;
import fiskfille.tf.common.network.base.TFNetworkManager;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;

public class MessageTileTrigger
implements IMessage {
    private ItemCSD.DimensionalCoords coordinates;
    private int id;
    private int action;
    private int playerDimension;

    public MessageTileTrigger() {
    }

    public MessageTileTrigger(ItemCSD.DimensionalCoords coords, EntityPlayer player, int action) {
        this.coordinates = coords;
        this.action = action;
        if (player != null) {
            this.id = player.func_145782_y();
            this.playerDimension = player.field_70170_p.field_73011_w.field_76574_g;
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.id = buf.readInt();
        this.action = buf.readInt();
        this.playerDimension = buf.readInt();
        this.coordinates = new ItemCSD.DimensionalCoords().fromBytes(buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeInt(this.action);
        buf.writeInt(this.playerDimension);
        this.coordinates.toBytes(buf);
    }

    public static interface ITileDataCallback {
        public void receive(EntityPlayer var1, int var2);
    }

    public static class Handler
    implements IMessageHandler<MessageTileTrigger, IMessage> {
        public IMessage onMessage(MessageTileTrigger message, MessageContext ctx) {
            EntityPlayer clientPlayer = ctx.side.isClient() ? TransformersMod.proxy.getPlayer() : ctx.getServerHandler().field_147369_b;
            EntityPlayer player = null;
            World world = clientPlayer.field_70170_p;
            if (world.field_73011_w.field_76574_g != message.playerDimension) {
                if (!ctx.side.isServer()) {
                    return null;
                }
                world = MinecraftServer.func_71276_C().func_71218_a(message.playerDimension);
            }
            if (world.func_73045_a(message.id) instanceof EntityPlayer) {
                player = (EntityPlayer)world.func_73045_a(message.id);
            }
            ItemCSD.DimensionalCoords coords = message.coordinates;
            world = clientPlayer.field_70170_p;
            if (world.field_73011_w.field_76574_g != coords.dimension) {
                if (!ctx.side.isServer()) {
                    return null;
                }
                world = MinecraftServer.func_71276_C().func_71218_a(coords.dimension);
            }
            if (world.func_147438_o(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c) instanceof ITileDataCallback) {
                ITileDataCallback callback = (ITileDataCallback)world.func_147438_o(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c);
                callback.receive(player, message.action);
                if (ctx.side.isServer()) {
                    TFNetworkManager.networkWrapper.sendToAll((IMessage)new MessageTileTrigger(coords, player, message.action));
                }
            }
            return null;
        }
    }
}

