/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.common.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import fiskfille.tf.common.data.tile.TileData;
import fiskfille.tf.common.item.ItemCSD;
import fiskfille.tf.common.network.base.TFNetworkManager;
import fiskfille.tf.helper.TFTileHelper;
import io.netty.buffer.ByteBuf;

public class MessageSetTileData
implements IMessage {
    private TileData tileData;
    private ItemCSD.DimensionalCoords tileCoords;

    public MessageSetTileData() {
    }

    public MessageSetTileData(ItemCSD.DimensionalCoords coords, TileData data) {
        this.tileData = data;
        this.tileCoords = coords;
    }

    public MessageSetTileData(TileData data) {
        this(data.getCoords(), data);
    }

    public void fromBytes(ByteBuf buf) {
        if (buf.readBoolean()) {
            try {
                this.tileData = (TileData)Class.forName(ByteBufUtils.readUTF8String((ByteBuf)buf)).newInstance();
                this.tileData.fromBytes(buf);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.tileCoords = new ItemCSD.DimensionalCoords().fromBytes(buf);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.tileData != null);
        if (this.tileData == null) {
            this.tileCoords.toBytes(buf);
        } else {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.tileData.getClass().getCanonicalName());
            this.tileData.toBytes(buf);
        }
    }

    public static class Handler
    implements IMessageHandler<MessageSetTileData, IMessage> {
        public IMessage onMessage(MessageSetTileData message, MessageContext ctx) {
            TileData data = message.tileData;
            ItemCSD.DimensionalCoords coords = data != null ? data.getCoords() : message.tileCoords;
            TFTileHelper.putServerData(coords, data);
            if (ctx.side.isServer()) {
                TFNetworkManager.networkWrapper.sendToAll((IMessage)new MessageSetTileData(coords, data));
            }
            return null;
        }
    }
}

