/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.common.network;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import fiskfille.tf.TransformersAPI;
import fiskfille.tf.TransformersMod;
import fiskfille.tf.common.data.TFData;
import fiskfille.tf.common.network.MessageSyncBase;
import fiskfille.tf.common.transformer.base.Transformer;
import fiskfille.tf.config.TFConfig;
import fiskfille.tf.helper.TFDimensionHelper;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class MessagePlayerJoin
extends MessageSyncBase {
    private Map<Transformer, Boolean> canTransform;
    private Map<Integer, String> dimensionNames = Maps.newHashMap();
    private Integer[] dimensionIDs;

    public MessagePlayerJoin() {
    }

    public MessagePlayerJoin(EntityPlayer player) {
        super(player);
        this.canTransform = TFConfig.canTransform;
        if (this.canTransform.isEmpty() || !this.canTransform.keySet().containsAll(TransformersAPI.getTransformers())) {
            for (Transformer transformer : TransformersAPI.getTransformers()) {
                if (this.canTransform.containsKey(transformer)) continue;
                this.canTransform.put(transformer, true);
            }
        }
        Integer[] ids = DimensionManager.getIDs();
        this.dimensionNames = TFDimensionHelper.dimensionNames;
        for (int i = 0; i < ids.length; ++i) {
            int id = ids[i];
            WorldServer world = MinecraftServer.func_71276_C().func_71218_a(id);
            if (world == null || world.field_73011_w == null) continue;
            this.dimensionNames.put(id, world.field_73011_w.func_80007_l());
        }
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < ids.length; ++i) {
            int id = ids[i];
            if (!DimensionManager.shouldLoadSpawn((int)id)) continue;
            list.add(id);
        }
        Collections.sort(list, new Comparator<Integer>(){

            @Override
            public int compare(Integer arg0, Integer arg1) {
                return Double.valueOf(arg0.intValue()).compareTo((double)arg1);
            }
        });
        this.dimensionIDs = list.toArray(new Integer[list.size()]);
        TFDimensionHelper.dimensionIDs = this.dimensionIDs;
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        int i;
        super.fromBytes(buf);
        this.canTransform = Maps.newHashMap();
        for (Transformer transformer : TransformersAPI.getTransformers()) {
            this.canTransform.put(transformer, buf.readBoolean());
        }
        int length = buf.readInt();
        for (i = 0; i < length; ++i) {
            this.dimensionNames.put(buf.readInt(), ByteBufUtils.readUTF8String((ByteBuf)buf));
        }
        this.dimensionIDs = new Integer[buf.readInt()];
        for (i = 0; i < this.dimensionIDs.length; ++i) {
            this.dimensionIDs[i] = buf.readInt();
        }
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        for (Map.Entry<Transformer, Boolean> entry : this.canTransform.entrySet()) {
            buf.writeBoolean(entry.getValue().booleanValue());
        }
        buf.writeInt(this.dimensionNames.size());
        for (Map.Entry<Object, Object> entry : this.dimensionNames.entrySet()) {
            buf.writeInt(((Integer)entry.getKey()).intValue());
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)((String)entry.getValue()));
        }
        buf.writeInt(this.dimensionIDs.length);
        for (int i = 0; i < this.dimensionIDs.length; ++i) {
            buf.writeInt(this.dimensionIDs[i].intValue());
        }
    }

    public static class Handler
    implements IMessageHandler<MessagePlayerJoin, IMessage> {
        public IMessage onMessage(MessagePlayerJoin message, MessageContext ctx) {
            if (ctx.side.isClient()) {
                EntityPlayer player = TransformersMod.proxy.getPlayer();
                for (Map.Entry e : message.playerData.entrySet()) {
                    ((TFData)e.getKey()).setWithoutNotify(player, e.getValue());
                }
                if (message.canTransform != null) {
                    TFConfig.canTransform = message.canTransform;
                }
                TFDimensionHelper.dimensionNames = message.dimensionNames;
                TFDimensionHelper.dimensionIDs = message.dimensionIDs;
            }
            return null;
        }
    }
}

