/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.common.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import fiskfille.tf.TransformersMod;
import fiskfille.tf.common.data.TFData;
import fiskfille.tf.common.transformer.base.Transformer;
import fiskfille.tf.helper.TFHelper;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;

public class MessagePlayerData
implements IMessage {
    public int id;
    private TFData<?> type;
    private Object value;

    public MessagePlayerData() {
    }

    public MessagePlayerData(EntityPlayer player, TFData<?> data, Object obj) {
        this.id = player.func_145782_y();
        this.type = data;
        this.value = obj;
    }

    public void fromBytes(ByteBuf buf) {
        this.id = buf.readInt();
        String id = ByteBufUtils.readUTF8String((ByteBuf)buf);
        for (TFData<?> data : TFData.VALUES) {
            if (!data.id.equals(id)) continue;
            this.type = data;
            break;
        }
        this.value = this.type.readDataFromNBT(ByteBufUtils.readTag((ByteBuf)buf));
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.id);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.type.id);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.type.writeDataToNBT(new NBTTagCompound(), this.value));
    }

    public static class Handler
    implements IMessageHandler<MessagePlayerData, IMessage> {
        public IMessage onMessage(MessagePlayerData message, MessageContext ctx) {
            TFData type = message.type;
            Object value = message.value;
            if (ctx.side.isClient()) {
                EntityPlayer player = TransformersMod.proxy.getPlayer();
                Entity entity = player.field_70170_p.func_73045_a(message.id);
                if (entity instanceof EntityPlayer) {
                    type.setWithoutNotify((EntityPlayer)entity, value);
                    if (type == TFData.ALT_MODE) {
                        Transformer transformer = TFHelper.getTransformer((EntityLivingBase)((EntityPlayer)entity));
                        if (transformer != null) {
                            entity.field_70170_p.func_72980_b(entity.field_70165_t, entity.field_70163_u - (double)entity.field_70129_M, entity.field_70161_v, transformer.getTransformationSound((Integer)value), 1.0f, 1.0f, false);
                        }
                    } else if (type == TFData.STEALTH_FORCE) {
                        entity.field_70170_p.func_72980_b(entity.field_70165_t, entity.field_70163_u - (double)entity.field_70129_M, entity.field_70161_v, "transformers:transform_stealth" + ((Boolean)value != false ? "" : "_in"), 1.0f, 1.25f, false);
                    }
                }
            } else {
                Entity entity;
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                if (player != null && (entity = player.field_70170_p.func_73045_a(message.id)) instanceof EntityPlayer) {
                    type.set((EntityPlayer)entity, value);
                }
            }
            return null;
        }
    }
}

