/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.common.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import fiskfille.tf.common.energon.power.IEnergyReceiver;
import fiskfille.tf.common.energon.power.IEnergyTransmitter;
import fiskfille.tf.common.energon.power.ReceiverEntry;
import fiskfille.tf.common.energon.power.TransmissionHandler;
import fiskfille.tf.common.item.ItemCSD;
import io.netty.buffer.ByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;

public class MessageConnectReceiver
implements IMessage {
    private ItemCSD.DimensionalCoords transmitterCoords;
    private ItemCSD.DimensionalCoords receiverCoords;

    public MessageConnectReceiver() {
    }

    public MessageConnectReceiver(ItemCSD.DimensionalCoords coords, ItemCSD.DimensionalCoords coords1) {
        this.transmitterCoords = coords;
        this.receiverCoords = coords1;
    }

    public void fromBytes(ByteBuf buf) {
        this.transmitterCoords = new ItemCSD.DimensionalCoords().fromBytes(buf);
        this.receiverCoords = new ItemCSD.DimensionalCoords().fromBytes(buf);
    }

    public void toBytes(ByteBuf buf) {
        this.transmitterCoords.toBytes(buf);
        this.receiverCoords.toBytes(buf);
    }

    public static class Handler
    implements IMessageHandler<MessageConnectReceiver, IMessage> {
        public IMessage onMessage(MessageConnectReceiver message, MessageContext ctx) {
            if (ctx.side.isServer()) {
                ItemCSD.DimensionalCoords coords = message.transmitterCoords;
                ItemCSD.DimensionalCoords coords1 = message.receiverCoords;
                WorldServer world = MinecraftServer.func_71276_C().func_71218_a(coords.dimension);
                if (world != null) {
                    TileEntity transmitterTile = world.func_147438_o(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c);
                    TileEntity receiverTile = world.func_147438_o(coords1.field_71574_a, coords1.field_71572_b, coords1.field_71573_c);
                    if (transmitterTile instanceof IEnergyTransmitter && receiverTile instanceof IEnergyReceiver) {
                        IEnergyTransmitter transmitter = (IEnergyTransmitter)transmitterTile;
                        TransmissionHandler handler = transmitter.getTransmissionHandler();
                        if (handler.getReceiver(coords1) != null) {
                            handler.remove(new ReceiverEntry(receiverTile));
                        } else {
                            handler.add(new ReceiverEntry(receiverTile));
                        }
                    }
                }
            }
            return null;
        }
    }
}

