/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.common.motion;

import fiskfille.tf.client.keybinds.TFKeyBinds;
import fiskfille.tf.common.data.TFData;
import fiskfille.tf.helper.TFHelper;
import fiskfille.tf.helper.TFVectorHelper;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.Vec3;

public class TFMotionManager {
    public static void motion(EntityPlayer player, double speedLimit, double nitroSpeedLimit, double sidewaysSpeedLimit, double reversingSpeedLimit, boolean canDrift, boolean canDriveOffroad, boolean canMoveSideways) {
        double currentSpeedLimit;
        Minecraft mc = Minecraft.func_71410_x();
        Random rand = new Random();
        boolean moveForward = mc.field_71474_y.field_74351_w.func_151470_d();
        boolean moveBack = mc.field_71474_y.field_74368_y.func_151470_d();
        boolean moveRight = mc.field_71474_y.field_74366_z.func_151470_d();
        boolean moveLeft = mc.field_71474_y.field_74370_x.func_151470_d();
        boolean inStealthMode = TFHelper.isInStealthMode(player);
        boolean nitroPressed = mc.field_71474_y.field_151444_V.func_151470_d();
        boolean driftPressed = TFKeyBinds.keyBindingBrake.func_151470_d();
        double forwardVelocity = TFData.FORWARD_VELOCITY.get(player);
        double horizontalVelocity = TFData.HORIZONTAL_VELOCITY.get(player);
        double d = canMoveSideways ? sidewaysSpeedLimit : (currentSpeedLimit = nitroPressed && TFData.NITRO.get(player).floatValue() > 0.0f ? nitroSpeedLimit : speedLimit);
        if (moveForward) {
            if (forwardVelocity < currentSpeedLimit) {
                forwardVelocity += inStealthMode ? 1.0 : (currentSpeedLimit - forwardVelocity) / 20.0;
            }
        } else if (!moveBack && forwardVelocity > 0.0) {
            forwardVelocity -= 1.0;
        }
        if (moveBack) {
            if (forwardVelocity > -reversingSpeedLimit) {
                forwardVelocity -= 2.0;
            }
        } else if (!moveForward && forwardVelocity < 0.0) {
            forwardVelocity += 1.0;
        }
        if (canMoveSideways) {
            if (moveRight) {
                if (horizontalVelocity < sidewaysSpeedLimit) {
                    horizontalVelocity += 1.0;
                }
            } else if (horizontalVelocity > 0.0) {
                horizontalVelocity -= 1.0;
            }
            if (moveLeft) {
                if (horizontalVelocity > -sidewaysSpeedLimit) {
                    horizontalVelocity -= 1.0;
                }
            } else if (horizontalVelocity < 0.0) {
                horizontalVelocity += 1.0;
            }
        }
        if (!canMoveSideways) {
            if (horizontalVelocity > 0.0) {
                horizontalVelocity -= 2.0;
            } else if (horizontalVelocity < 0.0) {
                horizontalVelocity += 2.0;
            }
            if (horizontalVelocity >= -1.0 || horizontalVelocity <= 1.0) {
                horizontalVelocity = 0.0;
            }
        }
        if (horizontalVelocity != (double)((int)horizontalVelocity)) {
            horizontalVelocity = (int)horizontalVelocity;
        } else if (horizontalVelocity > sidewaysSpeedLimit) {
            horizontalVelocity = sidewaysSpeedLimit;
        } else if (horizontalVelocity < -sidewaysSpeedLimit) {
            horizontalVelocity = -sidewaysSpeedLimit;
        }
        if (forwardVelocity < 1.0 && forwardVelocity > -1.0) {
            forwardVelocity = 0.0;
        } else if (forwardVelocity < -reversingSpeedLimit) {
            forwardVelocity = -reversingSpeedLimit;
        } else if (forwardVelocity >= currentSpeedLimit) {
            forwardVelocity -= 1.0;
        }
        if (!canDriveOffroad) {
            Material[] offroadMaterials = new Material[]{Material.field_151570_A, Material.field_151568_F, Material.field_151571_B, Material.field_151589_v, Material.field_151596_z, Material.field_151572_C, Material.field_151578_c, Material.field_151588_w, Material.field_151584_j, Material.field_151598_x, Material.field_151585_k, Material.field_151595_p, Material.field_151597_y, Material.field_151583_m, Material.field_151582_l, Material.field_151569_G};
            Block block = player.field_70170_p.func_147439_a((int)player.field_70165_t, (int)player.field_70163_u - 2, (int)player.field_70161_v - 1);
            boolean isDrivingOffroad = false;
            for (Material mat : offroadMaterials) {
                if (!block.func_149688_o().equals(mat)) continue;
                isDrivingOffroad = true;
            }
            if (isDrivingOffroad && (forwardVelocity > 5.0 || forwardVelocity < -5.0 || horizontalVelocity > 5.0 || horizontalVelocity < -5.0)) {
                double multiplier = forwardVelocity / 20.0;
                TFMotionManager.drift(player, forwardVelocity, (rand.nextDouble() - 0.5) * multiplier, false);
                forwardVelocity *= 0.95;
            }
        }
        if (canDrift && driftPressed && player.field_70122_E && forwardVelocity > 10.0 && !inStealthMode) {
            TFMotionManager.drift(player, forwardVelocity, Math.toRadians(player.field_70177_z - player.field_70761_aq), true);
            forwardVelocity -= 3.0;
        } else {
            TFMotionManager.moveWithVelocity(player, forwardVelocity, horizontalVelocity);
        }
        TFData.FORWARD_VELOCITY.setWithoutNotify(player, forwardVelocity);
        TFData.HORIZONTAL_VELOCITY.setWithoutNotify(player, horizontalVelocity);
    }

    public static void motionJet(EntityPlayer player, double speedLimit, double nitroSpeedLimit, double idlingSpeedLimit) {
        double currentSpeedLimit;
        Minecraft mc = Minecraft.func_71410_x();
        boolean clientPlayer = player == mc.field_71439_g;
        boolean moveForward = mc.field_71474_y.field_74351_w.func_151470_d();
        boolean nitroPressed = mc.field_71474_y.field_151444_V.func_151470_d();
        double forwardVelocity = TFData.FORWARD_VELOCITY.get(player);
        double d = currentSpeedLimit = nitroPressed && TFData.NITRO.get(player).floatValue() > 0.0f ? nitroSpeedLimit : speedLimit;
        if (moveForward) {
            if (forwardVelocity < currentSpeedLimit) {
                forwardVelocity += (currentSpeedLimit - forwardVelocity) / 10.0;
            }
        } else if (forwardVelocity > 0.0) {
            forwardVelocity -= 1.0;
        }
        if (forwardVelocity >= currentSpeedLimit) {
            forwardVelocity -= 1.0;
        } else if (forwardVelocity < idlingSpeedLimit) {
            forwardVelocity = idlingSpeedLimit;
        }
        if (clientPlayer) {
            TFMotionManager.moveForward(player, forwardVelocity, true);
            if (player.field_70132_H && forwardVelocity > 60.0) {
                TFData.ALT_MODE.set(player, -1);
            }
            TFData.FORWARD_VELOCITY.setWithoutNotify(player, forwardVelocity);
        }
    }

    public static void drift(EntityPlayer player, double forwardVelocity, double driftAmount, boolean tireParticles) {
        TFMotionManager.moveWithVelocity(player, forwardVelocity, -driftAmount * 10.0);
        if (tireParticles) {
            for (int i = 0; i < 10; ++i) {
                Vec3 side = TFVectorHelper.getBackSideCoords(player, 0.15f, i < 5, -0.5, false);
                player.field_70170_p.func_72869_a("reddust", side.field_72450_a, player.field_70121_D.field_72338_b, side.field_72449_c, -1.0, 0.0, 0.0);
            }
        }
        if (driftAmount > (double)0.2f) {
            player.field_70177_z = (float)((double)player.field_70177_z + driftAmount * 2.0);
        }
        if (driftAmount < (double)-0.2f) {
            player.field_70177_z = (float)((double)player.field_70177_z - -driftAmount * 2.0);
        }
    }

    public static void moveWithVelocity(EntityPlayer player, double forwardVel, double horizontalVel) {
        Vec3 frontCoords = TFVectorHelper.getBackSideCoords(player, TFMotionManager.fromKMPH(horizontalVel), false, TFMotionManager.fromKMPH(forwardVel), false);
        player.field_70159_w = frontCoords.field_72450_a - player.field_70165_t;
        player.field_70179_y = frontCoords.field_72449_c - player.field_70161_v;
    }

    public static void moveForward(EntityPlayer player, double vel, boolean pitch) {
        Vec3 frontCoords = TFVectorHelper.getFrontCoords(player, TFMotionManager.fromKMPH(vel), pitch);
        player.field_70159_w = frontCoords.field_72450_a - player.field_70165_t;
        if (pitch) {
            player.field_70181_x = frontCoords.field_72448_b - player.field_70121_D.field_72338_b;
        }
        player.field_70179_y = frontCoords.field_72449_c - player.field_70161_v;
    }

    public static double fromKMPH(double speed) {
        return speed * 1000.0 / 60.0 / 60.0 / 20.0;
    }
}

