/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.common.item.armor;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fiskfille.tf.TransformersMod;
import fiskfille.tf.client.model.transformer.ModelTransformerBase;
import fiskfille.tf.client.model.transformer.definition.TFModelRegistry;
import fiskfille.tf.common.transformer.base.Transformer;
import fiskfille.tf.helper.TFArmorHelper;
import java.util.List;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.ISpecialArmor;

public abstract class ItemTransformerArmor
extends ItemArmor
implements ISpecialArmor {
    public ItemTransformerArmor(ItemArmor.ArmorMaterial material, int renderIndex, int armorPiece) {
        super(material, renderIndex, armorPiece);
        this.func_77637_a(TransformersMod.tabTransformers);
    }

    public boolean isValidArmor(ItemStack stack, int armorType, Entity entity) {
        if (entity instanceof EntityLivingBase) {
            EntityLivingBase livingBase = (EntityLivingBase)entity;
            for (int i = 0; i < 4; ++i) {
                ItemStack armor = livingBase.func_71124_b(1 + i);
                if (armor == null || !(armor.func_77973_b() instanceof ItemTransformerArmor) || this.getTransformer() == ((ItemTransformerArmor)armor.func_77973_b()).getTransformer()) continue;
                return false;
            }
        }
        return super.isValidArmor(stack, armorType, entity);
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        if (!source.func_76363_c()) {
            ItemStack itemstack = TFArmorHelper.getArmorShell(armor);
            if (itemstack != null) {
                ItemArmor item = (ItemArmor)itemstack.func_77973_b();
                return new ISpecialArmor.ArmorProperties(0, (double)item.field_77879_b / 25.0, armor.func_77958_k() + 1 - armor.func_77960_j());
            }
            return new ISpecialArmor.ArmorProperties(0, (double)this.field_77879_b / 25.0, armor.func_77958_k() + 1 - armor.func_77960_j());
        }
        return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        ItemStack itemstack = TFArmorHelper.getArmorShell(armor);
        if (itemstack != null) {
            return TFArmorHelper.getArmorValue(player, itemstack, slot);
        }
        return this.field_77879_b;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        stack.func_77972_a(damage, entity);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return TFModelRegistry.getModel(this.getTransformer()).getTexture(entity, "").toString();
    }

    public void func_77624_a(ItemStack itemstack, EntityPlayer player, List info, boolean p_77624_4_) {
        ItemStack itemstack1 = TFArmorHelper.getArmorShell(itemstack);
        if (itemstack1 != null) {
            info.add(itemstack1.func_82833_r());
        }
    }

    public abstract Transformer getTransformer();

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entity, ItemStack itemstack, int armorSlot) {
        ModelTransformerBase model = this.getTransformer().getModel().getMainModel();
        if (itemstack != null && model != null) {
            model.layerToRender = armorSlot + 1;
            model.field_78116_c.field_78806_j = armorSlot == 0;
            model.field_78114_d.field_78806_j = armorSlot == 0;
            model.field_78115_e.field_78806_j = armorSlot == 1;
            model.field_78112_f.field_78806_j = armorSlot == 1;
            model.field_78113_g.field_78806_j = armorSlot == 1;
            model.field_78123_h.field_78806_j = armorSlot == 2 || armorSlot == 3;
            model.field_78124_i.field_78806_j = armorSlot == 2 || armorSlot == 3;
            model.field_78117_n = entity.func_70093_af();
            model.field_78093_q = entity.func_70115_ae();
            model.field_78091_s = entity.func_70631_g_();
            int n = model.field_78120_m = entity.func_71124_b(0) != null ? 1 : 0;
            if (entity instanceof EntityPlayer) {
                ItemStack heldItem = entity.func_70694_bm();
                boolean bl = model.field_78118_o = ((EntityPlayer)entity).func_71057_bx() > 0 && heldItem != null && heldItem.func_77975_n() == EnumAction.bow;
                model.field_78120_m = ((EntityPlayer)entity).func_71057_bx() > 0 && heldItem != null && heldItem.func_77975_n() == EnumAction.block ? 3 : (entity.func_71124_b(0) != null ? 1 : 0);
            }
            return model;
        }
        return null;
    }

    public void func_94581_a(IIconRegister iconRegister) {
    }
}

