/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.common.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fiskfille.tf.common.block.TFBlocks;
import fiskfille.tf.common.item.TFItems;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemTransformiumDetector
extends Item {
    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean hand) {
        int time = entity.field_70173_aa;
        if (time > 0) {
            NBTTagCompound tagCompound = stack.func_77978_p();
            if (tagCompound == null) {
                tagCompound = new NBTTagCompound();
                stack.func_77982_d(tagCompound);
            }
            int energonFuel = tagCompound.func_74762_e("fuel");
            if (entity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entity;
                if (energonFuel > 0) {
                    int d;
                    if (time % 500 == 0) {
                        tagCompound.func_74768_a("fuel", --energonFuel);
                        if (energonFuel <= 0) {
                            player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"transformium_detector.no_fuel.message")));
                        }
                    }
                    if (time % 5 == 0) {
                        int posX = (int)entity.field_70165_t;
                        int posY = (int)entity.field_70163_u;
                        int posZ = (int)entity.field_70161_v;
                        int startX = posX - 10;
                        int startY = posY - 10;
                        int startZ = posZ - 10;
                        int endX = posX + 10;
                        int endY = posY + 10;
                        int endZ = posZ + 10;
                        int smallestDist = 1000;
                        for (int x = startX; x < endX; ++x) {
                            for (int y = startY; y < endY; ++y) {
                                for (int z = startZ; z < endZ; ++z) {
                                    int zDiff;
                                    int yDiff;
                                    int xDiff;
                                    int distance;
                                    if (world.func_147439_a(x, y, z) != TFBlocks.transformiumOre || (distance = (int)Math.sqrt((xDiff = x - posX) * xDiff + (yDiff = y - posY) * yDiff + (zDiff = z - posZ) * zDiff)) >= smallestDist) continue;
                                    smallestDist = distance;
                                }
                            }
                        }
                        if (smallestDist != 1000) {
                            tagCompound.func_74768_a("d", smallestDist);
                        } else {
                            tagCompound.func_74768_a("d", -1);
                        }
                    }
                    if (player.field_70170_p.field_72995_K && Minecraft.func_71410_x().field_71439_g == player && (d = tagCompound.func_74762_e("d")) > 0 && time % (d * 3) == 0) {
                        for (int i = 0; i < 3; ++i) {
                            entity.func_85030_a("note.harp", 1.0f, 1.2f);
                        }
                    }
                }
            }
        }
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        int fuel = stack.func_77978_p().func_74762_e("fuel");
        if (player.func_70093_af()) {
            if (player.field_71071_by.func_70447_i() != -1) {
                player.field_71071_by.func_70441_a(new ItemStack(TFItems.energonCrystalShard, fuel));
                stack.func_77978_p().func_74768_a("fuel", 0);
            } else if (world.field_72995_K) {
                player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"transformium_detector.no_space.message")));
            }
        } else if (player.field_71075_bZ.field_75098_d || player.field_71071_by.func_146026_a(TFItems.energonCrystalShard)) {
            stack.func_77978_p().func_74768_a("fuel", fuel + 1);
            if (world.field_72995_K) {
                player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"transformium_detector.insert_fuel.message")));
            }
        } else if (world.field_72995_K) {
            player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"transformium_detector.no_energon.message")));
        }
        return stack;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List informationList, boolean p_77624_4_) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound != null) {
            informationList.add(StatCollector.func_74838_a((String)"stats.fuel.name") + ": " + tagCompound.func_74762_e("fuel"));
        }
    }
}

