/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.common.item;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cpw.mods.fml.common.eventhandler.Event;
import fiskfille.tf.common.data.TFWorldData;
import fiskfille.tf.common.event.ItemHandlerEvent;
import fiskfille.tf.common.event.ItemStitchEvent;
import fiskfille.tf.common.item.ItemMetaBasic;
import fiskfille.tf.common.item.TFItems;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

public class ItemHandler {
    private static Map<Class, String> itemHandlers = Maps.newHashMap();
    public static boolean hasInit = false;

    public static void init() {
        LinkedList names = Lists.newLinkedList();
        LinkedList domains = Lists.newLinkedList();
        MinecraftForge.EVENT_BUS.post((Event)new ItemHandlerEvent.Init(itemHandlers));
        hasInit = true;
        for (Map.Entry<Class, String> e : itemHandlers.entrySet()) {
            for (Field field : e.getKey().getFields()) {
                String s = field.getType().getName();
                if (!s.equals(ItemStack[].class.getName())) continue;
                names.add(field.getName());
                domains.add(e.getValue());
            }
        }
        ItemMetaBasic.iconNames = names.toArray(new String[names.size()]);
        ItemMetaBasic.iconDomains = domains.toArray(new String[domains.size()]);
    }

    public static void load(World world) {
        TFWorldData data = TFWorldData.get(world);
        MinecraftForge.EVENT_BUS.post((Event)new ItemStitchEvent.Pre(world));
        for (Map.Entry<Class, String> e : itemHandlers.entrySet()) {
            for (Field field : e.getKey().getFields()) {
                String s = field.getType().getName();
                if (!s.equals(ItemStack[].class.getName())) continue;
                try {
                    ItemStack[] itemstacks = new ItemStack[65];
                    String name = field.getName();
                    int id = data.getNextAvailableId();
                    if (data.subItems.containsKey(name)) {
                        id = data.subItems.get(name);
                    } else {
                        data.subItems.put(name, id);
                    }
                    for (int amount = 0; amount < itemstacks.length; ++amount) {
                        itemstacks[amount] = new ItemStack(TFItems.craftingMaterial, amount, id);
                    }
                    field.set(null, itemstacks);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        ItemMetaBasic.subItems = data.subItems;
        MinecraftForge.EVENT_BUS.post((Event)new ItemStitchEvent.Post(world));
    }

    public static boolean matches(ItemStack itemstack, ItemStack[] item) {
        return itemstack != null && item[1].func_77973_b() == itemstack.func_77973_b() && item[1].func_77960_j() == itemstack.func_77960_j();
    }
}

