/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.common.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fiskfille.tf.TransformersAPI;
import fiskfille.tf.common.energon.Energon;
import fiskfille.tf.common.fluid.FluidEnergon;
import fiskfille.tf.common.fluid.FluidTankTF;
import fiskfille.tf.common.fluid.TFFluids;
import fiskfille.tf.helper.TFFormatHelper;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.ItemFluidContainer;

public class ItemFuelCanister
extends ItemFluidContainer {
    public static final String[] unlocalizedNames = new String[]{"", "creative_"};
    public IIcon[] icons;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] overlays;

    public ItemFuelCanister() {
        super(0, 2000);
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    public static boolean isEmpty(ItemStack itemstack) {
        return ItemFuelCanister.getFluidAmount(itemstack) <= 0;
    }

    public static boolean isFull(ItemStack itemstack) {
        return ItemFuelCanister.getFluidAmount(itemstack) >= ItemFuelCanister.getContainerCapacity(itemstack);
    }

    public static int getFluidAmount(ItemStack itemstack) {
        if (itemstack.field_77990_d == null || !itemstack.field_77990_d.func_74764_b("Fluid")) {
            return 0;
        }
        return itemstack.field_77990_d.func_74775_l("Fluid").func_74762_e("Amount");
    }

    public static FluidStack getContainerFluid(ItemStack itemstack) {
        if (itemstack.field_77990_d == null || !itemstack.field_77990_d.func_74764_b("Fluid")) {
            return null;
        }
        return FluidStack.loadFluidStackFromNBT((NBTTagCompound)itemstack.field_77990_d.func_74775_l("Fluid"));
    }

    public static int getContainerCapacity(ItemStack itemstack) {
        if (itemstack.func_77973_b() instanceof IFluidContainerItem) {
            return ((IFluidContainerItem)itemstack.func_77973_b()).getCapacity(itemstack);
        }
        return 0;
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        if (resource == null || resource.getFluid() != TFFluids.energon) {
            return 0;
        }
        return super.fill(container, resource, doFill);
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        return super.drain(container, maxDrain, container.func_77960_j() == 0 && doDrain);
    }

    public void func_77624_a(ItemStack itemstack, EntityPlayer player, List list, boolean p_77624_4_) {
        FluidTankTF tank = new FluidTankTF(this.getCapacity(itemstack));
        tank.setFluid(this.getFluid(itemstack));
        list.addAll(TFFormatHelper.toString(tank.format()));
    }

    public String func_77667_c(ItemStack itemstack) {
        int i = MathHelper.func_76125_a((int)itemstack.func_77960_j(), (int)0, (int)(unlocalizedNames.length - 1));
        return "item." + unlocalizedNames[i] + "fuel_canister";
    }

    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < unlocalizedNames.length; ++i) {
            list.add(new ItemStack(item, 1, i));
            for (Energon energon : TransformersAPI.getEnergonTypes()) {
                ItemStack itemstack = new ItemStack(item, 1, i);
                this.fill(itemstack, FluidEnergon.create(energon, this.capacity), true);
                list.add(itemstack);
            }
        }
    }

    public IIcon getIcon(ItemStack itemstack, int pass) {
        FluidStack fluidStack;
        if (pass > 0 && (fluidStack = this.getFluid(itemstack)) != null && fluidStack.amount > 0) {
            int i = Math.round((float)fluidStack.amount / (float)this.capacity * 4.0f);
            return this.overlays[i % this.overlays.length];
        }
        return super.getIcon(itemstack, pass);
    }

    public IIcon func_77617_a(int damage) {
        int i = MathHelper.func_76125_a((int)damage, (int)0, (int)(unlocalizedNames.length - 1));
        return this.icons[i];
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack itemstack, int pass) {
        FluidStack fluidStack;
        if (pass == 1 && (fluidStack = this.getFluid(itemstack)) != null && fluidStack.amount > 0) {
            return FluidEnergon.getLiquidColor(fluidStack);
        }
        return super.func_82790_a(itemstack, pass);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        int i;
        this.icons = new IIcon[unlocalizedNames.length];
        this.overlays = new IIcon[5];
        for (i = 0; i < this.icons.length; ++i) {
            this.icons[i] = iconRegister.func_94245_a("transformers:" + unlocalizedNames[i] + "fuel_canister");
        }
        for (i = 0; i < this.overlays.length; ++i) {
            this.overlays[i] = iconRegister.func_94245_a("transformers:fuel_canister_overlay_" + i);
        }
    }
}

