/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.common.item;

import fiskfille.tf.common.energon.power.IEnergyContainerItem;
import fiskfille.tf.helper.TFFormatHelper;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;

public class ItemEnergyContainer
extends Item
implements IEnergyContainerItem {
    protected float capacity;

    public ItemEnergyContainer(float max) {
        this.func_77625_d(1);
        this.capacity = max;
    }

    public ItemEnergyContainer setCapacity(float max) {
        this.capacity = max;
        return this;
    }

    public void func_77624_a(ItemStack itemstack, EntityPlayer player, List list, boolean flag) {
        list.add(StatCollector.func_74837_a((String)"gui.emb.storage", (Object[])new Object[]{TFFormatHelper.formatNumber(this.getEnergyStored(itemstack)), TFFormatHelper.formatNumber(this.getEnergyCapacity(itemstack))}));
    }

    @Override
    public float receiveEnergy(ItemStack itemstack, float amount, boolean simulate) {
        if (!itemstack.func_77942_o()) {
            itemstack.func_77982_d(new NBTTagCompound());
        }
        float energy = itemstack.func_77978_p().func_74760_g("Energy");
        float energyReceived = Math.min(this.getEnergyCapacity(itemstack) - energy, amount);
        if (!simulate) {
            itemstack.func_77978_p().func_74776_a("Energy", energy += energyReceived);
        }
        return energyReceived;
    }

    @Override
    public float extractEnergy(ItemStack itemstack, float amount, boolean simulate) {
        if (!itemstack.func_77942_o() || !itemstack.func_77978_p().func_74764_b("Energy")) {
            return 0.0f;
        }
        float energy = itemstack.func_77978_p().func_74760_g("Energy");
        float energyExtracted = Math.min(energy, amount);
        if (!simulate) {
            itemstack.func_77978_p().func_74776_a("Energy", energy -= energyExtracted);
        }
        return energyExtracted;
    }

    @Override
    public float getEnergyStored(ItemStack itemstack) {
        if (!itemstack.func_77942_o() || !itemstack.func_77978_p().func_74764_b("Energy")) {
            return 0.0f;
        }
        float energy = itemstack.func_77978_p().func_74760_g("Energy");
        if ((double)energy <= 1.0E-16) {
            energy = 0.0f;
            itemstack.func_77978_p().func_74776_a("Energy", 0.0f);
        }
        return energy;
    }

    @Override
    public float getEnergyCapacity(ItemStack itemstack) {
        return this.capacity;
    }
}

