/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.common.item;

import fiskfille.tf.common.tileentity.TileEntityControlPanel;
import fiskfille.tf.helper.TFDimensionHelper;
import fiskfille.tf.helper.TFTileHelper;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public class ItemCSD
extends Item {
    public ItemCSD() {
        this.func_77625_d(1);
    }

    public void func_77624_a(ItemStack itemstack, EntityPlayer player, List list, boolean flag) {
        DimensionalCoords coords = ItemCSD.getCoords(itemstack);
        list.add(coords.getFormatted().func_150254_d());
    }

    public boolean func_77648_a(ItemStack itemstack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        world.func_72805_g(x, y, z);
        if (player.func_70093_af()) {
            DimensionalCoords coords = new DimensionalCoords(x, y + 1, z, world.field_73011_w.field_76574_g);
            TileEntity tile = TFTileHelper.getTileBase(world.func_147438_o(x, y, z));
            if (tile instanceof TileEntityControlPanel) {
                coords.set(((TileEntityControlPanel)tile).data.destination);
            }
            ItemCSD.setCoords(itemstack, coords);
            if (world.field_72995_K) {
                player.func_146105_b((IChatComponent)new ChatComponentTranslation("csd.save.success", new Object[]{coords.getFormatted()}));
            }
            return true;
        }
        if (world.func_147438_o(x, y, z) instanceof TileEntityControlPanel) {
            TileEntityControlPanel tile = TFTileHelper.getTileBase((TileEntityControlPanel)world.func_147438_o(x, y, z));
            if (!tile.data.activationLeverState) {
                DimensionalCoords coords = ItemCSD.getCoords(itemstack);
                tile.setSwitchesTo(coords);
                tile.markBlockForUpdate();
                if (world.field_72995_K) {
                    player.func_146105_b((IChatComponent)new ChatComponentTranslation("csd.load.success", new Object[]{coords.getFormatted()}));
                }
                return true;
            }
            if (world.field_72995_K) {
                player.func_146105_b(new ChatComponentTranslation("csd.load.fail", new Object[0]).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.RED)));
            }
        }
        return false;
    }

    public static DimensionalCoords getCoords(ItemStack itemstack) {
        DimensionalCoords coords = new DimensionalCoords();
        if (itemstack.func_77942_o() && itemstack.func_77978_p().func_150297_b("Coordinates", 10)) {
            NBTTagCompound nbttagcompound = itemstack.func_77978_p().func_74775_l("Coordinates");
            coords.set(nbttagcompound.func_74762_e("x"), nbttagcompound.func_74762_e("y"), nbttagcompound.func_74762_e("z"), nbttagcompound.func_74762_e("dim"));
        }
        return coords;
    }

    public static DimensionalCoords setCoords(ItemStack itemstack, DimensionalCoords coords) {
        if (!itemstack.func_77942_o()) {
            itemstack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.func_74768_a("x", coords.field_71574_a);
        nbttagcompound.func_74768_a("y", coords.field_71572_b);
        nbttagcompound.func_74768_a("z", coords.field_71573_c);
        nbttagcompound.func_74768_a("dim", coords.dimension);
        itemstack.func_77978_p().func_74782_a("Coordinates", (NBTBase)nbttagcompound);
        return coords;
    }

    public static class DimensionalCoords
    extends ChunkCoordinates {
        public int dimension;

        public DimensionalCoords() {
        }

        public DimensionalCoords(int x, int y, int z, int dim) {
            super(x, y, z);
            this.dimension = dim;
        }

        public DimensionalCoords(ChunkCoordinates coords, int dim) {
            super(coords);
            this.dimension = dim;
        }

        public DimensionalCoords(TileEntity tile) {
            this.set(tile);
        }

        public static DimensionalCoords copy(DimensionalCoords coords) {
            if (coords != null) {
                return new DimensionalCoords().set(coords);
            }
            return null;
        }

        public DimensionalCoords set(int x, int y, int z, int dim) {
            this.field_71574_a = x;
            this.field_71572_b = y;
            this.field_71573_c = z;
            this.dimension = dim;
            return this;
        }

        public DimensionalCoords set(TileEntity tile) {
            if (tile.func_145831_w() != null) {
                return this.set(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, tile.func_145831_w().field_73011_w.field_76574_g);
            }
            return this;
        }

        public DimensionalCoords set(DimensionalCoords coords) {
            return this.set(coords.toArray());
        }

        public DimensionalCoords set(int ... args) {
            int[] aint = this.toArray();
            for (int i = 0; i < Math.min(args.length, aint.length); ++i) {
                aint[i] = args[i];
            }
            return this.set(aint[0], aint[1], aint[2], aint[3]);
        }

        public IChatComponent getFormatted() {
            ChatStyle green = new ChatStyle().func_150238_a(EnumChatFormatting.GREEN);
            return new ChatComponentTranslation("csd.format", new Object[]{new ChatComponentText(TFDimensionHelper.getDimensionName(this.dimension)).func_150255_a(green), new ChatComponentText(this.field_71574_a + "").func_150255_a(green), new ChatComponentText(this.field_71572_b + "").func_150255_a(green), new ChatComponentText(this.field_71573_c + "").func_150255_a(green)});
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.field_71574_a);
            buf.writeInt(this.field_71572_b);
            buf.writeInt(this.field_71573_c);
            buf.writeInt(this.dimension);
        }

        public DimensionalCoords fromBytes(ByteBuf buf) {
            this.set(buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt());
            return this;
        }

        public int[] toArray() {
            return new int[]{this.field_71574_a, this.field_71572_b, this.field_71573_c, this.dimension};
        }

        public static DimensionalCoords fromArray(int[] aint) {
            int[] aint1 = new int[4];
            for (int i = 0; i < Math.min(aint.length, aint1.length); ++i) {
                aint1[i] = aint[i];
            }
            return new DimensionalCoords(aint1[0], aint1[1], aint1[2], aint1[3]);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DimensionalCoords)) {
                return false;
            }
            DimensionalCoords coords = (DimensionalCoords)((Object)obj);
            return this.field_71574_a == coords.field_71574_a && this.field_71572_b == coords.field_71572_b && this.field_71573_c == coords.field_71573_c && this.dimension == coords.dimension;
        }

        public int hashCode() {
            return this.field_71574_a + this.field_71573_c << 8 + this.field_71572_b << 16 + this.dimension << 32;
        }

        public String toString() {
            return "Pos{x=" + this.field_71574_a + ", y=" + this.field_71572_b + ", z=" + this.field_71573_c + ", dim=" + this.dimension + '}';
        }

        public int compareTo(Object obj) {
            return this.compareTo((DimensionalCoords)((Object)obj));
        }

        public int compareTo(DimensionalCoords coords) {
            return this.dimension == coords.dimension ? (this.field_71572_b == coords.field_71572_b ? (this.field_71573_c == coords.field_71573_c ? this.field_71574_a - coords.field_71574_a : this.field_71573_c - coords.field_71573_c) : this.field_71572_b - coords.field_71572_b) : this.dimension - coords.dimension;
        }
    }
}

