/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.common.groundbridge;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.util.StatCollector;

public enum GroundBridgeError {
    INVALID_COORDS,
    NOT_ENOUGH_SPACE,
    NOT_ENOUGH_ENERGY,
    NO_PORTAL_LINKED,
    PORTAL_OBSTRUCTED,
    OUT_OF_BOUNDS;


    public static class ErrorContainer {
        private GroundBridgeError error;
        private Integer[] arguments;

        public ErrorContainer(GroundBridgeError error, Integer ... arguments) {
            this.error = error;
            this.arguments = arguments;
        }

        public GroundBridgeError getError() {
            return this.error;
        }

        public Integer[] getArguments() {
            return this.arguments;
        }

        public String translate() {
            return StatCollector.func_74837_a((String)("ground_bridge.error." + this.error.name().toLowerCase()), (Object[])this.arguments);
        }

        public void toBytes(ByteBuf buf) {
            buf.writeByte(this.error.ordinal() & 0xFF);
            buf.writeByte(this.arguments.length & 0xFF);
            for (int i = 0; i < this.arguments.length; ++i) {
                buf.writeInt(this.arguments[i].intValue());
            }
        }

        public static ErrorContainer fromBytes(ByteBuf buf) {
            try {
                GroundBridgeError error = GroundBridgeError.values()[buf.readByte()];
                ArrayList list = Lists.newArrayList();
                int length = buf.readByte() & 0xFF;
                for (int i = 0; i < length; ++i) {
                    list.add(buf.readInt());
                }
                return new ErrorContainer(error, list.toArray(new Integer[list.size()]));
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public String toString() {
            return this.getError().toString();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ErrorContainer) {
                boolean flag;
                ErrorContainer container = (ErrorContainer)obj;
                boolean bl = flag = container.arguments.length == this.arguments.length;
                if (flag) {
                    for (int i = 0; i < this.arguments.length; ++i) {
                        if (container.arguments[i].equals(this.arguments[i])) continue;
                        return false;
                    }
                }
                return container.error == this.error && flag;
            }
            return false;
        }
    }
}

