/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.common.generator;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import fiskfille.tf.common.block.TFBlocks;
import fiskfille.tf.common.generator.WorldGenCrystal;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class TFWorldGenHandler {
    private World world;
    private Random rand;
    private int xCoord;
    private int zCoord;
    public WorldGenerator transformiumGen = new WorldGenMinable(TFBlocks.transformiumOre, 8);
    public WorldGenerator energonGen = new WorldGenMinable(TFBlocks.energonOre, 6);
    public WorldGenerator energonCrystalGen = new WorldGenCrystal(TFBlocks.energonCrystal, Material.field_151576_e);
    public WorldGenerator redEnergonCrystalGen = new WorldGenCrystal(TFBlocks.redEnergonCrystal, Material.field_151576_e);

    @SubscribeEvent
    public void onOreGenPost(OreGenEvent.Post event) {
        this.world = event.world;
        this.rand = event.rand;
        this.xCoord = event.worldX;
        this.zCoord = event.worldZ;
        this.genStandardOre(2, this.transformiumGen, 16);
        this.genStandardOre(4, this.energonGen, 32);
    }

    @SubscribeEvent
    public void onPopulateChunkPost(PopulateChunkEvent.Post event) {
        this.world = event.world;
        this.rand = event.rand;
        this.xCoord = event.chunkX * 16;
        this.zCoord = event.chunkZ * 16;
        this.genStandardOre(100, this.energonCrystalGen, 48);
        this.genStandardOre(10, this.redEnergonCrystalGen, 24);
    }

    protected void genStandardOre(int veins, WorldGenerator generator, int maxHeight) {
        if (TerrainGen.generateOre((World)this.world, (Random)this.rand, (WorldGenerator)generator, (int)this.xCoord, (int)this.zCoord, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.CUSTOM)) {
            for (int i = 0; i < veins; ++i) {
                int x = this.xCoord + this.rand.nextInt(16);
                int y = this.rand.nextInt(maxHeight);
                int z = this.zCoord + this.rand.nextInt(16);
                generator.func_76484_a(this.world, this.rand, x, y, z);
            }
        }
    }
}

