/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.common.fluid;

import com.google.common.collect.Lists;
import cpw.mods.fml.common.network.ByteBufUtils;
import fiskfille.tf.TransformersAPI;
import fiskfille.tf.common.energon.Energon;
import fiskfille.tf.common.fluid.FluidEnergon;
import fiskfille.tf.helper.TFFormatHelper;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class FluidTankTF
extends FluidTank {
    protected int fluidUsage;
    protected int lastFluidAmount;

    public FluidTankTF(int capacity) {
        super(capacity);
    }

    public FluidTankTF(FluidStack stack, int capacity) {
        super(stack, capacity);
    }

    public FluidTankTF(Fluid fluid, int amount, int capacity) {
        super(fluid, amount, capacity);
    }

    public FluidTankTF copy() {
        FluidTankTF tank = new FluidTankTF(this.getCapacity());
        if (this.getFluid() != null) {
            tank.setFluid(this.getFluid().copy());
        }
        tank.setUsage(this.getUsage());
        return tank;
    }

    public void toBytes(ByteBuf buf) {
        boolean hasFluid = this.fluid != null;
        buf.writeBoolean(hasFluid);
        if (hasFluid) {
            NBTTagCompound tag = this.fluid.writeToNBT(new NBTTagCompound());
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
        }
        buf.writeShort(this.fluidUsage);
    }

    public void fromBytes(ByteBuf buf) {
        if (buf.readBoolean()) {
            NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)buf);
            this.fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag);
        }
        this.fluidUsage = buf.readShort();
        this.lastFluidAmount = this.getFluidAmount() - this.fluidUsage;
    }

    public FluidTank readFromNBT(NBTTagCompound nbt) {
        FluidTank tank = super.readFromNBT(nbt);
        this.fluidUsage = nbt.func_74765_d("FluidUsage");
        this.lastFluidAmount = this.getFluidAmount() - this.fluidUsage;
        return tank;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt = super.writeToNBT(nbt);
        nbt.func_74777_a("FluidUsage", (short)this.fluidUsage);
        return nbt;
    }

    public void setUsage(int usage) {
        this.fluidUsage = usage;
        this.lastFluidAmount = this.getFluidAmount();
    }

    public int getUsage() {
        return this.fluidUsage;
    }

    public int calculateUsage() {
        int amount = this.getFluidAmount();
        this.fluidUsage = amount - this.lastFluidAmount;
        this.lastFluidAmount = amount;
        return this.fluidUsage;
    }

    public List<IChatComponent> format() {
        ArrayList list = Lists.newArrayList();
        FluidStack stack = this.getFluid();
        if (stack != null && stack.amount > 0) {
            Map<String, Float> ratios = FluidEnergon.getRatios(stack);
            boolean flag = false;
            for (Map.Entry<String, Float> e : ratios.entrySet()) {
                Energon energon = TransformersAPI.getEnergonTypeByName(e.getKey());
                int percentage = Math.round(e.getValue().floatValue() * 100.0f);
                if (percentage <= 0) continue;
                IChatComponent name = new ChatComponentText(energon.getTranslatedName()).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.GRAY));
                IChatComponent ratio = new ChatComponentText(percentage + "").func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.YELLOW));
                list.add(new ChatComponentTranslation("gui.energon_processor.content", new Object[]{name, ratio}).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.GRAY)));
                flag = true;
            }
            if (flag) {
                list.add(null);
            } else {
                list.add(new ChatComponentTranslation("gui.energon_processor.unidentified", new Object[0]).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.RED)));
            }
        }
        IChatComponent amount = new ChatComponentText(TFFormatHelper.formatNumber(this.getFluidAmount())).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.YELLOW));
        IChatComponent capacity = new ChatComponentText(TFFormatHelper.formatNumber(this.getCapacity())).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.YELLOW));
        list.add(new ChatComponentTranslation("gui.energon_processor.filled", new Object[]{amount, capacity}).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.GRAY)));
        return list;
    }
}

