/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.common.fluid;

import com.google.common.collect.Maps;
import fiskfille.tf.TransformersAPI;
import fiskfille.tf.common.energon.Energon;
import fiskfille.tf.common.energon.IEnergon;
import fiskfille.tf.common.fluid.TFFluids;
import fiskfille.tf.helper.TFHelper;
import fiskfille.tf.helper.TFTextureHelper;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class FluidEnergon
extends Fluid {
    public FluidEnergon(String fluidName) {
        super(fluidName);
    }

    public IIcon getStillIcon() {
        return TFTextureHelper.energonStillIcon;
    }

    public IIcon getFlowingIcon() {
        return TFTextureHelper.energonFlowingIcon;
    }

    public int getColor(FluidStack stack) {
        return FluidEnergon.getLiquidColor(stack);
    }

    public static void refreshNBT(FluidStack stack) {
        if (stack.tag == null) {
            stack.tag = new NBTTagCompound();
        }
    }

    public static FluidStack create(ItemStack crystal) {
        IEnergon energon = (IEnergon)(crystal.func_77973_b() instanceof ItemBlock ? Block.func_149634_a((Item)crystal.func_77973_b()) : crystal.func_77973_b());
        return FluidEnergon.create(energon.getEnergonType(), energon.getMass());
    }

    public static FluidStack create(Energon energon, int amount) {
        FluidStack stack = new FluidStack(TFFluids.energon, amount);
        HashMap ratios = Maps.newHashMap();
        for (Energon energon1 : TransformersAPI.getEnergonTypes()) {
            ratios.put(energon1.getId(), Float.valueOf(energon.getId().equals(energon1.getId()) ? 1.0f : 0.0f));
        }
        FluidEnergon.setRatios(stack, ratios);
        return stack;
    }

    public static void merge(FluidStack stack1, FluidStack stack2, int amount) {
        Map<String, Float> ratios1 = FluidEnergon.getRatios(stack1);
        Map<String, Float> ratios2 = FluidEnergon.getRatios(stack2);
        if (stack1.amount == 0) {
            ratios1 = ratios2;
        } else {
            for (Map.Entry<String, Float> e : ratios1.entrySet()) {
                float f = (float)amount / (float)stack1.amount;
                e.setValue(Float.valueOf(e.getValue().floatValue() * (1.0f - f) + ratios2.get(e.getKey()).floatValue() * f));
            }
        }
        FluidEnergon.setRatios(stack1, ratios1);
    }

    public static void setRatios(FluidStack stack, Map<String, Float> ratios) {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        for (Energon energon : TransformersAPI.getEnergonTypes()) {
            if (ratios.containsKey(energon.getId())) continue;
            ratios.put(energon.getId(), Float.valueOf(0.0f));
        }
        for (Map.Entry entry : ratios.entrySet()) {
            nbttagcompound.func_74776_a((String)entry.getKey(), ((Float)entry.getValue()).floatValue());
        }
        FluidEnergon.refreshNBT(stack);
        stack.tag.func_74782_a("Ratio", (NBTBase)nbttagcompound);
        FluidEnergon.calculateLiquidColor(stack);
    }

    public static Map<String, Float> getRatios(FluidStack stack) {
        FluidEnergon.refreshNBT(stack);
        HashMap map = Maps.newHashMap();
        NBTTagCompound nbttagcompound = stack.tag.func_74775_l("Ratio");
        for (Energon energon : TransformersAPI.getEnergonTypes()) {
            map.put(energon.getId(), Float.valueOf(nbttagcompound.func_74760_g(energon.getId())));
        }
        return map;
    }

    public static void setRatio(FluidStack stack, String name, float ratio) {
        FluidEnergon.refreshNBT(stack);
        NBTTagCompound nbttagcompound = stack.tag.func_74775_l("Ratio");
        nbttagcompound.func_74776_a(name, ratio);
        stack.tag.func_74782_a("Ratio", (NBTBase)nbttagcompound);
        FluidEnergon.calculateLiquidColor(stack);
    }

    public static float getRatio(FluidStack stack, String name) {
        FluidEnergon.refreshNBT(stack);
        Maps.newHashMap();
        NBTTagCompound nbttagcompound = stack.tag.func_74775_l("Ratio");
        if (nbttagcompound.func_74764_b(name)) {
            return nbttagcompound.func_74760_g(name);
        }
        return 0.0f;
    }

    public static int calculateLiquidColor(FluidStack stack) {
        Map<String, Float> ratios = FluidEnergon.getRatios(stack);
        int liquidColor = -1;
        for (Map.Entry<String, Float> e : ratios.entrySet()) {
            Energon energon = TransformersAPI.getEnergonTypeByName(e.getKey());
            if (energon == null) continue;
            if (liquidColor == -1) {
                liquidColor = energon.getColor();
                continue;
            }
            liquidColor = TFHelper.blend(liquidColor, energon.getColor(), e.getValue().floatValue());
        }
        FluidEnergon.setLiquidColor(stack, liquidColor);
        return liquidColor;
    }

    public static void setLiquidColor(FluidStack stack, int color) {
        FluidEnergon.refreshNBT(stack);
        stack.tag.func_74768_a("Color", color);
    }

    public static int getLiquidColor(FluidStack stack) {
        return stack.tag != null && stack.tag.func_74764_b("Color") ? stack.tag.func_74762_e("Color") : -1;
    }
}

