/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.common.event;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import fiskfille.tf.TransformersMod;
import fiskfille.tf.common.achievement.TFAchievements;
import fiskfille.tf.common.data.TFData;
import fiskfille.tf.common.data.TFDataManager;
import fiskfille.tf.common.data.TFEntityData;
import fiskfille.tf.common.data.TFPlayerData;
import fiskfille.tf.common.data.TFWorldData;
import fiskfille.tf.common.event.ItemHandlerEvent;
import fiskfille.tf.common.event.ItemStitchEvent;
import fiskfille.tf.common.item.ItemHandler;
import fiskfille.tf.common.item.TFItems;
import fiskfille.tf.common.item.TFSubItems;
import fiskfille.tf.common.network.MessageBroadcastState;
import fiskfille.tf.common.network.MessageSendFlying;
import fiskfille.tf.common.network.base.TFNetworkManager;
import fiskfille.tf.common.recipe.TFRecipes;
import fiskfille.tf.common.transformer.base.Transformer;
import fiskfille.tf.config.TFConfig;
import fiskfille.tf.helper.TFHelper;
import fiskfille.tf.web.update.Update;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;

public class CommonEventHandler {
    private List<EntityPlayer> playersNotSunc = new ArrayList<EntityPlayer>();
    private boolean displayedUpdates;
    private Map<EntityPlayer, Boolean> prevFlying = new HashMap<EntityPlayer, Boolean>();

    @SubscribeEvent
    public void onHit(LivingAttackEvent event) {
        Entity cause = event.source.func_76346_g();
        if (cause instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)cause;
            Transformer transformer = TFHelper.getTransformer((EntityLivingBase)player);
            int altMode = TFData.ALT_MODE.get(player);
            if (TFHelper.isFullyTransformed(player) && !event.source.func_76352_a() && (transformer == null || transformer.canInteractInVehicleMode(player, altMode))) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onSmelt(PlayerEvent.ItemSmeltedEvent event) {
        if (event.smelting.func_77973_b() == TFItems.transformiumFragment) {
            event.player.func_71064_a((StatBase)TFAchievements.transformium, 1);
        }
    }

    @SubscribeEvent
    public void onCraft(PlayerEvent.ItemCraftedEvent event) {
        if (ItemHandler.matches(event.crafting, TFSubItems.tank_track)) {
            event.player.func_71064_a((StatBase)TFAchievements.tracks, 1);
        }
    }

    @SubscribeEvent
    public void onEntityLoad(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityPlayer) {
            event.entity.registerExtendedProperties("TFPlayer", (IExtendedEntityProperties)new TFPlayerData());
        }
        event.entity.registerExtendedProperties("TFEntity", (IExtendedEntityProperties)new TFEntityData());
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        EntityPlayer player = event.getPlayer();
        Transformer transformer = TFHelper.getTransformer((EntityLivingBase)player);
        int altMode = TFData.ALT_MODE.get(player);
        if (TFHelper.isFullyTransformed(player) && (transformer == null || transformer.canInteractInVehicleMode(player, altMode))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void startTracking(PlayerEvent.StartTracking event) {
        EntityPlayer player = event.entityPlayer;
        if (player != null && !player.field_70170_p.field_72995_K && event.target instanceof EntityPlayer) {
            EntityPlayer beingTracked = (EntityPlayer)event.target;
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            EntityPlayerMP beingTrackedMP = (EntityPlayerMP)beingTracked;
            TFNetworkManager.networkWrapper.sendTo((IMessage)new MessageBroadcastState(player), beingTrackedMP);
            TFNetworkManager.networkWrapper.sendTo((IMessage)new MessageBroadcastState(beingTracked), playerMP);
            TFNetworkManager.networkWrapper.sendTo((IMessage)new MessageSendFlying(beingTracked, beingTracked.field_71075_bZ.field_75100_b), playerMP);
            TFNetworkManager.networkWrapper.sendTo((IMessage)new MessageSendFlying(player, player.field_71075_bZ.field_75100_b), beingTrackedMP);
        }
    }

    @SubscribeEvent
    public void onClonePlayer(PlayerEvent.Clone event) {
        TFPlayerData.getData(event.entityPlayer).copy(TFPlayerData.getData(event.original));
    }

    @SubscribeEvent
    public void onEntityInteract(EntityInteractEvent event) {
        EntityPlayer player = event.entityPlayer;
        Transformer transformer = TFHelper.getTransformer((EntityLivingBase)player);
        int altMode = TFData.ALT_MODE.get(player);
        if (TFHelper.isFullyTransformed(player) && (transformer == null || transformer.canInteractInVehicleMode(player, altMode))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onSpawn(EntityJoinWorldEvent event) {
        Entity entity = event.entity;
        World world = entity.field_70170_p;
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            player.func_71064_a((StatBase)TFAchievements.transformersMod, 1);
            if (!world.field_72995_K) {
                this.playersNotSunc.add(player);
            } else {
                TFHelper.isFullyTransformed(player);
                if (!this.displayedUpdates && TFConfig.checkForUpdates) {
                    Update update = TransformersMod.latestUpdate;
                    if (update != null && update.isAvailable()) {
                        String[] updates;
                        player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.BLUE + "TransformersMod version " + update.getVersion() + " is now available!"));
                        player.func_145747_a((IChatComponent)new ChatComponentText(""));
                        player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.BLUE + "" + EnumChatFormatting.BOLD + "What's New: "));
                        for (String updatePart : updates = update.getUpdateLog().split(Pattern.quote("(newline)"))) {
                            EnumChatFormatting colour = EnumChatFormatting.RED;
                            if (updatePart.trim().startsWith("*")) {
                                colour = EnumChatFormatting.GOLD;
                            } else if (updatePart.trim().startsWith("+")) {
                                colour = EnumChatFormatting.GREEN;
                            } else if (updatePart.trim().startsWith("-")) {
                                colour = EnumChatFormatting.RED;
                            }
                            player.func_145747_a((IChatComponent)new ChatComponentText(colour + updatePart));
                        }
                        player.func_145747_a((IChatComponent)new ChatComponentText(""));
                    }
                    this.displayedUpdates = true;
                }
            }
        }
    }

    @SubscribeEvent
    public void onLivingJump(LivingEvent.LivingJumpEvent event) {
        EntityPlayer player;
        Transformer transformer;
        if (event.entity instanceof EntityPlayer && (transformer = TFHelper.getTransformer((EntityLivingBase)(player = (EntityPlayer)event.entity))) != null) {
            int altMode = TFData.ALT_MODE.get(player);
            if (!transformer.onJump(player) || !transformer.canJumpAsVehicle(player, altMode) && TFHelper.getTransformationTimer(player) >= 0.5f) {
                player.field_70181_x = 0.0;
            }
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        World world = event.world;
        if (!world.field_72995_K) {
            TFWorldData.load(world);
        }
        ItemHandler.load(world);
    }

    @SubscribeEvent
    public void onItemStitchPost(ItemStitchEvent.Post event) {
        TFRecipes.register();
        TFAchievements.register();
    }

    @SubscribeEvent
    public void onItemHandlerInit(ItemHandlerEvent.Init event) {
        event.registerItemHandler("transformers", TFSubItems.class);
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        TFEntityData.getData(event.entity).onUpdate();
        if (event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            if (!player.field_70170_p.field_72995_K && player.field_71075_bZ != null) {
                Boolean isFlying = this.prevFlying.get(player);
                boolean capabilitiesFlying = player.field_71075_bZ.field_75100_b;
                if (isFlying != null) {
                    if (isFlying != capabilitiesFlying) {
                        TFNetworkManager.networkWrapper.sendToDimension((IMessage)new MessageSendFlying(player, capabilitiesFlying), player.field_71093_bK);
                        this.prevFlying.put(player, capabilitiesFlying);
                    }
                } else {
                    TFNetworkManager.networkWrapper.sendToDimension((IMessage)new MessageSendFlying(player, capabilitiesFlying), player.field_71093_bK);
                    this.prevFlying.put(player, capabilitiesFlying);
                }
            }
            if (!player.field_70170_p.field_72995_K && this.playersNotSunc.size() > 0 && this.playersNotSunc.contains(player)) {
                TFDataManager.updatePlayerWithServerInfo(player);
                this.playersNotSunc.remove(player);
            }
        }
    }

    @SubscribeEvent
    public void onLivingFall(LivingFallEvent event) {
        EntityPlayer player;
        Transformer transformer;
        if (event.entity instanceof EntityPlayer && (transformer = TFHelper.getTransformer((EntityLivingBase)(player = (EntityPlayer)event.entity))) != null) {
            float newDist = transformer.fall(player, event.distance, TFData.ALT_MODE.get(player));
            if (newDist <= 0.0f) {
                event.setCanceled(true);
            } else {
                event.distance = newDist;
            }
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent event) {
        if (event.type == TickEvent.Type.CLIENT || event.type == TickEvent.Type.SERVER) {
            TransformersMod.proxy.runTasks();
        }
    }
}

