/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.common.entity;

import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import fiskfille.tf.common.achievement.TFAchievements;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class EntityMissile
extends EntityThrowable
implements IEntityAdditionalSpawnData {
    public boolean isInStealthMode;
    public boolean allowExplosions;

    public EntityMissile(World world) {
        super(world);
    }

    public EntityMissile(World world, EntityLivingBase entity, boolean explosions, boolean stealthMode) {
        super(world, entity);
        this.isInStealthMode = stealthMode;
        this.allowExplosions = explosions;
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, this.func_70182_d(), 1.0f);
    }

    public EntityMissile(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa < 5 && !this.isInStealthMode) {
            this.field_70163_u -= (double)0.2f;
        }
        for (int i = 0; i < 20; ++i) {
            float spread = (this.field_70146_Z.nextFloat() - 0.5f) / 4.0f;
            this.field_70170_p.func_72869_a("smoke", this.field_70165_t + (double)spread, this.field_70163_u + (double)spread, this.field_70161_v + (double)spread, 0.0, 0.0, 0.0);
        }
    }

    protected float func_70185_h() {
        return this.isInStealthMode ? 0.05f : 0.005f;
    }

    protected float func_70182_d() {
        return this.isInStealthMode ? 2.0f : 4.0f;
    }

    protected void func_70184_a(MovingObjectPosition mop) {
        if (!this.field_70170_p.field_72995_K) {
            if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                this.explode(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, mop.field_72310_e);
            } else if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY) {
                EntityPlayer player;
                this.field_70170_p.func_72876_a(null, mop.field_72308_g.field_70165_t, mop.field_72308_g.field_70163_u, mop.field_72308_g.field_70161_v, 4.0f, this.allowExplosions);
                if (mop.field_72308_g instanceof EntityBat && this.func_85052_h() instanceof EntityPlayer && (player = (EntityPlayer)this.func_85052_h()).func_70068_e(mop.field_72308_g) >= 25.0) {
                    player.func_71064_a((StatBase)TFAchievements.sharpshooter, 1);
                }
            }
        }
        this.func_70106_y();
    }

    public void explode(int x, int y, int z, int sideHit) {
        if (sideHit == 0) {
            --y;
        } else if (sideHit == 1) {
            ++y;
        } else if (sideHit == 2) {
            --z;
        } else if (sideHit == 3) {
            ++z;
        } else if (sideHit == 4) {
            --x;
        } else if (sideHit == 5) {
            ++x;
        }
        this.field_70170_p.func_72876_a(null, (double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), 4.0f, this.allowExplosions);
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74757_a("Explosions", this.allowExplosions);
        nbt.func_74757_a("StealthForce", this.isInStealthMode);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.allowExplosions = nbt.func_74767_n("Explosions");
        this.isInStealthMode = nbt.func_74767_n("StealthForce");
    }

    public void writeSpawnData(ByteBuf buf) {
        buf.writeBoolean(this.allowExplosions);
        buf.writeBoolean(this.isInStealthMode);
    }

    public void readSpawnData(ByteBuf buf) {
        this.allowExplosions = buf.readBoolean();
        this.isInStealthMode = buf.readBoolean();
    }
}

