/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.common.energon.power;

import fiskfille.tf.common.energon.power.IEnergyReceiver;
import fiskfille.tf.common.energon.power.IEnergyTransmitter;
import fiskfille.tf.common.energon.power.NetworkEntry;
import fiskfille.tf.common.energon.power.ReceiverEntry;
import fiskfille.tf.common.energon.power.ReceiverHandler;
import fiskfille.tf.common.item.ItemCSD;
import fiskfille.tf.helper.TFEnergyHelper;
import io.netty.buffer.ByteBuf;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class TransmissionHandler {
    private Set<ReceiverEntry> receivers = new HashSet<ReceiverEntry>();
    private Queue<ReceiverEntry> queuedReceivers = new ArrayDeque<ReceiverEntry>();
    private NetworkEntry owner;
    private boolean needsUpdate = false;

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.receivers.size());
        for (ReceiverEntry receiver : this.receivers) {
            receiver.toBytes(buf);
        }
    }

    public void fromBytes(ByteBuf buf) {
        int receiverCount = buf.readInt();
        for (int i = 0; i < receiverCount; ++i) {
            this.receivers.add(ReceiverEntry.fromBytes(buf));
        }
    }

    public void onUpdate(World world) {
        if (this.owner == null) {
            return;
        }
        Iterator<ReceiverEntry> iterator = this.receivers.iterator();
        while (iterator.hasNext()) {
            ReceiverEntry receiver = iterator.next();
            TileEntity receiverTile = receiver.getTile();
            if (receiverTile == null) {
                receiver.load(world);
                receiverTile = receiver.getTile();
            }
            if (receiverTile instanceof IEnergyReceiver) {
                boolean destroyed;
                boolean invalid = world.func_72863_F().func_73149_a(receiverTile.field_145851_c >> 4, receiverTile.field_145849_e >> 4) && (receiverTile.func_145837_r() || !this.exists(world, receiverTile));
                boolean outRange = !TFEnergyHelper.isInRange(this.owner.getTile(), receiverTile);
                boolean bl = destroyed = !invalid && !this.exists(world, receiverTile);
                if (!(invalid || outRange || destroyed)) {
                    boolean flag = receiver.canReach();
                    receiver.setCanReach(this.canPowerReach(receiver));
                    if (flag == receiver.canReach()) continue;
                    this.needsUpdate = true;
                    continue;
                }
            }
            iterator.remove();
            this.needsUpdate = true;
        }
        while (this.queuedReceivers.size() > 0) {
            ReceiverEntry receiver = this.queuedReceivers.poll();
            this.needsUpdate |= this.processQueue(world, receiver);
        }
        if (this.needsUpdate) {
            this.owner.getTile().func_70296_d();
        }
    }

    private boolean canPowerReach(ReceiverEntry entry) {
        TileEntity tile = this.owner.getTile();
        IEnergyTransmitter transmitter = this.owner.getTransmitter();
        IEnergyReceiver receiver = entry.getReceiver();
        ItemCSD.DimensionalCoords coords = entry.getCoords();
        Vec3 hit = receiver.getEnergyInputOffset().func_72441_c((double)((float)coords.field_71574_a + 0.5f), (double)((float)coords.field_71572_b + 0.5f), (double)((float)coords.field_71573_c + 0.5f));
        Vec3 original = receiver.getEnergyInputOffset().func_72441_c((double)((float)coords.field_71574_a + 0.5f), (double)((float)coords.field_71572_b + 0.5f), (double)((float)coords.field_71573_c + 0.5f));
        Vec3 output = transmitter.getEnergyOutputOffset().func_72441_c((double)((float)tile.field_145851_c + 0.5f), (double)((float)tile.field_145848_d + 0.5f), (double)((float)tile.field_145849_e + 0.5f));
        double deltaScale = 1.0 / hit.func_72438_d(output);
        output = Vec3.func_72443_a((double)(output.field_72450_a + (hit.field_72450_a - output.field_72450_a) * deltaScale), (double)(output.field_72448_b + (hit.field_72448_b - output.field_72448_b) * deltaScale), (double)(output.field_72449_c + (hit.field_72449_c - output.field_72449_c) * deltaScale));
        MovingObjectPosition result = TFEnergyHelper.rayTraceBlocks(tile.func_145831_w(), output, hit);
        if (result != null) {
            hit = result.field_72307_f;
        }
        return hit.field_72450_a == original.field_72450_a && hit.field_72448_b == original.field_72448_b && hit.field_72449_c == original.field_72449_c;
    }

    public void kill() {
        for (ReceiverEntry entry : this.receivers) {
            IEnergyReceiver receiver = entry.getReceiver();
            receiver.getReceiverHandler().remove(this.owner);
        }
    }

    private boolean processQueue(World world, ReceiverEntry receiver) {
        if (!this.receivers.contains(receiver)) {
            receiver.load(world);
            TileEntity tile = receiver.getTile();
            if (tile instanceof IEnergyTransmitter && TFEnergyHelper.getDescendants(receiver.getTransmitter()).contains((Object)this.owner.getCoords())) {
                return false;
            }
            if (tile instanceof IEnergyReceiver && ((IEnergyReceiver)tile).canReceiveEnergy(this.owner.getTile())) {
                this.add(receiver);
                return true;
            }
        }
        return false;
    }

    public void add(ReceiverEntry receiver) {
        if (!this.receivers.contains(receiver)) {
            this.receivers.add(receiver);
            if (receiver.getTile() != null) {
                IEnergyReceiver energyReceiver = receiver.getReceiver();
                energyReceiver.getReceiverHandler().add(this.owner);
            }
            this.needsUpdate = true;
        }
    }

    public void remove(ReceiverEntry entry) {
        if (this.receivers.contains(entry)) {
            this.receivers.remove(entry);
            if (entry.getTile() != null) {
                IEnergyReceiver receiver = entry.getReceiver();
                receiver.getReceiverHandler().remove(this.owner);
            }
            this.needsUpdate = true;
        }
    }

    private boolean exists(World world, TileEntity tile) {
        return world.func_147439_a(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e) == tile.func_145838_q();
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.receivers.clear();
        this.queuedReceivers.clear();
        NBTTagCompound energy = nbt.func_74775_l("EmB");
        NBTTagList receiverList = energy.func_150295_c("Receivers", 10);
        for (int i = 0; i < receiverList.func_74745_c(); ++i) {
            NBTTagCompound receiverTag = receiverList.func_150305_b(i);
            this.queue(ReceiverEntry.readFromNBT(receiverTag));
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagCompound energy = nbt.func_74775_l("EmB");
        NBTTagList receiverList = new NBTTagList();
        for (ReceiverEntry receiver : this.receivers) {
            this.writeReceiver(receiverList, receiver);
        }
        for (ReceiverEntry receiver : this.queuedReceivers) {
            this.writeReceiver(receiverList, receiver);
        }
        energy.func_74782_a("Receivers", (NBTBase)receiverList);
        nbt.func_74782_a("EmB", (NBTBase)energy);
    }

    private void writeReceiver(NBTTagList list, ReceiverEntry receiver) {
        NBTTagCompound tag = new NBTTagCompound();
        receiver.writeToNBT(tag);
        list.func_74742_a((NBTBase)tag);
    }

    public void queue(ReceiverEntry receiver) {
        this.queuedReceivers.add(receiver);
    }

    public void reset(World world, Set<ReceiverEntry> newReceivers) {
        for (ReceiverEntry receiver : this.receivers) {
            ReceiverHandler receiverHandler = TFEnergyHelper.getReceiverHandler(receiver.getTile());
            if (receiverHandler == null) continue;
            receiverHandler.remove(this.owner);
        }
        this.receivers.clear();
        this.queuedReceivers.clear();
        for (ReceiverEntry receiver : newReceivers) {
            this.processQueue(world, receiver);
        }
        this.needsUpdate = true;
    }

    public Set<ReceiverEntry> getReceivers() {
        return this.receivers;
    }

    public ReceiverEntry getReceiver(ItemCSD.DimensionalCoords coords) {
        for (ReceiverEntry receiver : this.receivers) {
            if (!receiver.getCoords().equals((Object)coords)) continue;
            return receiver;
        }
        return null;
    }

    public NetworkEntry getOwner() {
        return this.owner;
    }

    public void setOwner(TileEntity tile) {
        this.owner = new NetworkEntry(tile);
    }

    public boolean needsUpdate() {
        return this.needsUpdate;
    }

    public void setNeedsUpdate(boolean flag) {
        this.needsUpdate = flag;
    }
}

