/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.common.energon.power;

import fiskfille.tf.common.energon.power.IEnergyReceiver;
import fiskfille.tf.common.energon.power.IEnergyTransmitter;
import fiskfille.tf.common.item.ItemCSD;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class NetworkEntry {
    private ItemCSD.DimensionalCoords coords;
    private TileEntity owner;

    protected NetworkEntry(ItemCSD.DimensionalCoords coordinates, TileEntity tile) {
        this.coords = coordinates;
        this.owner = tile;
    }

    public NetworkEntry(TileEntity tile) {
        this(new ItemCSD.DimensionalCoords(tile), tile);
    }

    public ItemCSD.DimensionalCoords getCoords() {
        return this.coords;
    }

    public TileEntity getTile() {
        return this.owner;
    }

    public IEnergyTransmitter getTransmitter() {
        return (IEnergyTransmitter)this.getTile();
    }

    public IEnergyReceiver getReceiver() {
        return (IEnergyReceiver)this.getTile();
    }

    public void load(World world) {
        TileEntity tile = world.func_147438_o(this.coords.field_71574_a, this.coords.field_71572_b, this.coords.field_71573_c);
        if (tile instanceof IEnergyTransmitter || tile instanceof IEnergyReceiver) {
            this.owner = tile;
        }
    }

    public void writeToNBT(NBTTagCompound compound) {
        compound.func_74768_a("X", this.coords.field_71574_a);
        compound.func_74768_a("Y", this.coords.field_71572_b);
        compound.func_74768_a("Z", this.coords.field_71573_c);
        compound.func_74768_a("Dim", this.coords.dimension);
    }

    public static NetworkEntry readFromNBT(NBTTagCompound compound) {
        return new NetworkEntry(new ItemCSD.DimensionalCoords(compound.func_74762_e("X"), compound.func_74762_e("Y"), compound.func_74762_e("Z"), compound.func_74762_e("Dim")), null);
    }

    public void toBytes(ByteBuf buf) {
        this.coords.toBytes(buf);
    }

    public static NetworkEntry fromBytes(ByteBuf buf) {
        return new NetworkEntry(new ItemCSD.DimensionalCoords().fromBytes(buf), null);
    }

    public int hashCode() {
        return this.coords.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof NetworkEntry && ((NetworkEntry)obj).coords.equals((Object)this.coords);
    }
}

