/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.common.energon.power;

import fiskfille.tf.common.energon.power.EnergyStorage;
import fiskfille.tf.common.energon.power.ReceiverEntry;
import fiskfille.tf.common.tileentity.TileEntityRelayTower;
import fiskfille.tf.helper.TFEnergyHelper;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;

public class EnergyStorageRelay
extends EnergyStorage {
    protected final TileEntityRelayTower relay;

    public EnergyStorageRelay(TileEntityRelayTower tile) {
        super(0.0f);
        this.relay = tile;
    }

    @Override
    public EnergyStorageRelay copy() {
        EnergyStorageRelay storage = new EnergyStorageRelay(this.relay);
        return storage;
    }

    @Override
    public void toBytes(ByteBuf buf) {
    }

    @Override
    public void fromBytes(ByteBuf buf) {
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
    }

    @Override
    public float remove(float amount, boolean simulate) {
        List<ReceiverEntry> receivers = TFEnergyHelper.getReceiversToPower(this.relay);
        float removed = 0.0f;
        for (ReceiverEntry entry : receivers) {
            float f = entry.getReceiver().extractEnergy(amount / (float)receivers.size(), simulate);
            removed += f;
            this.relay.netEnergyTransfer.put(entry.getCoords(), Float.valueOf(this.relay.getNetTransfer(entry.getCoords()) - f));
        }
        return removed;
    }

    @Override
    public float add(float amount, boolean simulate) {
        List<ReceiverEntry> receivers = TFEnergyHelper.getReceiversToPower(this.relay);
        float added = 0.0f;
        for (ReceiverEntry entry : receivers) {
            float f = entry.getReceiver().receiveEnergy(amount / (float)receivers.size(), simulate);
            added += f;
            this.relay.netEnergyTransfer.put(entry.getCoords(), Float.valueOf(this.relay.getNetTransfer(entry.getCoords()) + f));
        }
        return added;
    }

    @Override
    public float getEnergy() {
        List<ReceiverEntry> receivers = TFEnergyHelper.getReceiverDescendants(this.relay);
        float energy = 0.0f;
        for (ReceiverEntry entry : receivers) {
            energy += entry.getReceiver().getEnergy();
        }
        return energy;
    }

    @Override
    public float getMaxEnergy() {
        List<ReceiverEntry> receivers = TFEnergyHelper.getReceiverDescendants(this.relay);
        float maxEnergy = 0.0f;
        for (ReceiverEntry entry : receivers) {
            maxEnergy += entry.getReceiver().getMaxEnergy();
        }
        return maxEnergy;
    }

    @Override
    public float set(float amount) {
        return 0.0f;
    }

    @Override
    public void setUsage(float usage) {
        this.energyUsage = usage;
        this.lastEnergy = this.getEnergy();
    }

    @Override
    public float getUsage() {
        return this.energyUsage;
    }

    @Override
    public float calculateUsage() {
        float energy = this.getEnergy();
        this.energyUsage = energy - this.lastEnergy;
        this.lastEnergy = energy;
        return this.energyUsage;
    }
}

