/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.common.energon.power;

import fiskfille.tf.common.energon.power.EnergyStorage;
import fiskfille.tf.common.energon.power.IEnergyContainerItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class EnergyStorageInventory
extends EnergyStorage {
    protected final TileEntity tile;
    protected final IInventory energyInventory;

    public EnergyStorageInventory(TileEntity tileentity, IInventory inventory) {
        super(0.0f);
        this.tile = tileentity;
        this.energyInventory = inventory;
    }

    @Override
    public EnergyStorageInventory copy() {
        EnergyStorageInventory storage = new EnergyStorageInventory(this.tile, this.energyInventory);
        return storage;
    }

    @Override
    public float remove(float amount, boolean simulate) {
        if (amount <= 0.0f) {
            return 0.0f;
        }
        float max = Math.min(amount, this.getEnergy());
        float removed = 0.0f;
        for (int i = 0; i < this.energyInventory.func_70302_i_(); ++i) {
            ItemStack stack = this.energyInventory.func_70301_a(i);
            if (stack == null || !(stack.func_77973_b() instanceof IEnergyContainerItem)) continue;
            IEnergyContainerItem container = (IEnergyContainerItem)stack.func_77973_b();
            float extracted = container.extractEnergy(stack, max, true);
            extracted = Math.min(extracted, max);
            removed += container.extractEnergy(stack, extracted, simulate || this.tile.func_145831_w().field_72995_K);
            if ((max -= extracted) <= 0.0f) break;
        }
        this.energy -= removed;
        return removed;
    }

    @Override
    public float add(float amount, boolean simulate) {
        if (amount <= 0.0f) {
            return 0.0f;
        }
        float max = Math.max(Math.min(amount, this.getMaxEnergy() - this.getEnergy()), 0.0f);
        float added = 0.0f;
        for (int i = 0; i < this.energyInventory.func_70302_i_(); ++i) {
            ItemStack stack = this.energyInventory.func_70301_a(i);
            if (stack == null || !(stack.func_77973_b() instanceof IEnergyContainerItem)) continue;
            IEnergyContainerItem container = (IEnergyContainerItem)stack.func_77973_b();
            float extracted = container.receiveEnergy(stack, max, true);
            extracted = Math.min(extracted, max);
            added += container.receiveEnergy(stack, extracted, simulate || this.tile.func_145831_w().field_72995_K);
            if ((max -= extracted) <= 0.0f) break;
        }
        this.energy += added;
        return added;
    }

    @Override
    public float getEnergy() {
        this.energy = 0.0f;
        for (int i = 0; i < this.energyInventory.func_70302_i_(); ++i) {
            ItemStack stack = this.energyInventory.func_70301_a(i);
            if (stack == null || !(stack.func_77973_b() instanceof IEnergyContainerItem)) continue;
            IEnergyContainerItem container = (IEnergyContainerItem)stack.func_77973_b();
            this.energy += container.getEnergyStored(stack);
        }
        return this.energy;
    }

    @Override
    public float getMaxEnergy() {
        int max = 0;
        for (int i = 0; i < this.energyInventory.func_70302_i_(); ++i) {
            ItemStack stack = this.energyInventory.func_70301_a(i);
            if (stack == null || !(stack.func_77973_b() instanceof IEnergyContainerItem)) continue;
            IEnergyContainerItem container = (IEnergyContainerItem)stack.func_77973_b();
            max = (int)((float)max + container.getEnergyCapacity(stack));
        }
        return max;
    }

    @Override
    public float set(float amount) {
        this.energy = Math.min(this.getMaxEnergy(), Math.max(0.0f, amount));
        return this.energy;
    }

    @Override
    public void setUsage(float usage) {
        this.energyUsage = usage;
        this.lastEnergy = this.getEnergy();
    }

    @Override
    public float getUsage() {
        return this.energyUsage;
    }

    @Override
    public float calculateUsage() {
        this.energyUsage = this.energy - this.lastEnergy;
        this.lastEnergy = this.energy;
        return this.energyUsage;
    }
}

